/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.event.bus;

import com.blamejared.crafttweaker.api.event.bus.FabricWiredReveal;
import com.blamejared.crafttweaker.api.event.bus.FabricWiredWrap;
import com.blamejared.crafttweaker.api.event.bus.IEventBus;
import com.blamejared.crafttweaker.api.event.bus.IEventBusWire;
import com.blamejared.crafttweaker.api.event.bus.IFabricPhaseMapper;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.google.common.reflect.TypeToken;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Objects;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_2960;

public final class FabricEventBusWire<E, S>
implements IEventBusWire {
    private static final MethodHandles.Lookup PUBLIC_LOOKUP = MethodHandles.publicLookup();
    private final Event<E> event;
    private final Class<E> originalEventClass;
    private final TypeToken<S> wrappedEventClass;
    private final IFabricPhaseMapper mapper;
    private final Method functionalMethod;
    private final MethodHandle wrapper;
    private final MethodHandle reveal;

    private FabricEventBusWire(Event<E> event, Class<E> originalEventClass, TypeToken<S> wrappedEventClass, IFabricPhaseMapper mapper, Method functionalMethod, MethodHandle wrapper, MethodHandle reveal) {
        this.event = event;
        this.originalEventClass = originalEventClass;
        this.wrappedEventClass = wrappedEventClass;
        this.mapper = mapper;
        this.functionalMethod = functionalMethod;
        this.wrapper = wrapper;
        this.reveal = reveal;
    }

    public static <E, S> FabricEventBusWire<E, S> of(Event<E> event, Class<E> originalEventClass, Class<S> wrappedEventClass) {
        return FabricEventBusWire.of(event, originalEventClass, TypeToken.of(wrappedEventClass));
    }

    public static <E, S> FabricEventBusWire<E, S> of(Event<E> event, Class<E> originalEventClass, TypeToken<S> wrappedEventClass) {
        return FabricEventBusWire.of(event, originalEventClass, wrappedEventClass, IFabricPhaseMapper.defaultToAll());
    }

    public static <E, S> FabricEventBusWire<E, S> of(Event<E> event, Class<E> originalEventClass, Class<S> wrappedEventClass, IFabricPhaseMapper mapper) {
        return FabricEventBusWire.of(event, originalEventClass, TypeToken.of(wrappedEventClass), mapper);
    }

    public static <E, S> FabricEventBusWire<E, S> of(Event<E> event, Class<E> originalEventClass, TypeToken<S> wrappedEventClass, IFabricPhaseMapper mapper) {
        Objects.requireNonNull(event, "event");
        Objects.requireNonNull(mapper, "mapper");
        Method functionalMethod = FabricEventBusWire.verifyOriginal(originalEventClass);
        WrapReveal wrapReveal = FabricEventBusWire.verifyWrapped(wrappedEventClass);
        FabricEventBusWire.compatibility(functionalMethod, wrapReveal);
        MethodHandle wrap = FabricEventBusWire.handle(wrapReveal.wrap());
        MethodHandle reveal = FabricEventBusWire.handle(wrapReveal.reveal());
        return new FabricEventBusWire<E, S>(event, originalEventClass, wrappedEventClass, mapper, functionalMethod, wrap, reveal);
    }

    private static <E> Method verifyOriginal(Class<E> originalEventClass) {
        Objects.requireNonNull(originalEventClass, "originalEventClass");
        if (!originalEventClass.isInterface()) {
            throw new IllegalArgumentException("All Fabric events are represented by interfaces, but got non-interface " + originalEventClass.getName());
        }
        return FabricEventBusWire.findFunctionalMethod(originalEventClass);
    }

    private static <E> Method findFunctionalMethod(Class<E> originalEventClass) {
        Method[] methods = originalEventClass.getDeclaredMethods();
        Method target = null;
        for (Method method : methods) {
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || method.isDefault() || !Modifier.isAbstract(modifiers)) continue;
            if (target != null) {
                throw new IllegalArgumentException(originalEventClass.getName() + " is not a functional interface");
            }
            target = method;
        }
        if (target == null) {
            throw new IllegalArgumentException(originalEventClass.getName() + " is not a functional interface");
        }
        return target;
    }

    private static <S> WrapReveal verifyWrapped(TypeToken<S> wrappedEventClass) {
        Objects.requireNonNull(wrappedEventClass, "wrappedEventClass");
        return FabricEventBusWire.verifyWrapped(wrappedEventClass.getRawType());
    }

    private static <S> WrapReveal verifyWrapped(Class<S> wrappedEventClass) {
        Method[] methods = wrappedEventClass.getDeclaredMethods();
        Method wrap = null;
        Method reveal = null;
        for (Method method : methods) {
            int modifiers = method.getModifiers();
            if (method.isAnnotationPresent(FabricWiredWrap.class)) {
                if (wrap != null) {
                    throw new IllegalArgumentException(wrappedEventClass.getName() + " declares two wrapping methods");
                }
                if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) {
                    throw new IllegalArgumentException(wrappedEventClass.getName() + " wrapper must be public and static");
                }
                if (method.getReturnType() != wrappedEventClass) {
                    throw new IllegalArgumentException(wrappedEventClass.getName() + " wrapper must return the same class");
                }
                wrap = method;
            }
            if (!method.isAnnotationPresent(FabricWiredReveal.class)) continue;
            if (reveal != null) {
                throw new IllegalArgumentException(wrappedEventClass.getName() + " declares two reveal methods");
            }
            if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) {
                throw new IllegalArgumentException(wrappedEventClass.getName() + " reveal must be public and static");
            }
            if (method.getParameterCount() != 1 || method.getParameterTypes()[0] != wrappedEventClass) {
                throw new IllegalArgumentException(wrappedEventClass.getName() + " reveal must accept its class as the single parameter");
            }
            reveal = method;
        }
        if (wrap == null) {
            throw new IllegalArgumentException(wrappedEventClass.getName() + " is missing a wrapper");
        }
        return new WrapReveal(wrap, reveal);
    }

    private static void compatibility(Method functionalMethod, WrapReveal wrapReveal) {
        FabricEventBusWire.compatibleArguments(functionalMethod, wrapReveal.wrap());
        FabricEventBusWire.compatibleReturnType(functionalMethod, wrapReveal.reveal());
    }

    private static void compatibleArguments(Method functional, Method wrap) {
        Parameter[] wrapParameters;
        Parameter[] functionalParameters = functional.getParameters();
        int length = functionalParameters.length;
        if (length != (wrapParameters = wrap.getParameters()).length) {
            throw new IllegalArgumentException("Incompatible wrapper: expected " + length + " parameters, but got " + wrapParameters.length);
        }
        for (int i = 0; i < length; ++i) {
            Parameter functionalParameter = functionalParameters[i];
            Parameter wrapParameter = wrapParameters[i];
            if (functionalParameter.getType().equals(wrapParameter.getType())) continue;
            String message = "Incompatible wrapper: type mismatch at parameter " + i + "; got " + String.valueOf(wrapParameter) + ", expected " + String.valueOf(functionalParameter);
            throw new IllegalArgumentException(message);
        }
    }

    private static void compatibleReturnType(Method functionalMethod, Method reveal) {
        Class<?> returnType = functionalMethod.getReturnType();
        if (returnType.equals(Void.TYPE)) {
            if (reveal != null) {
                throw new IllegalArgumentException("Incompatible reveal: functional method is void, so no reveal expected");
            }
            return;
        }
        if (reveal == null) {
            throw new IllegalArgumentException("Incompatible reveal: functional method is not void, so reveal expected");
        }
        Class<?> revealType = reveal.getReturnType();
        if (returnType != revealType) {
            throw new IllegalArgumentException("Incompatible reveal: invalid return type; expected " + returnType.getName() + ", got " + revealType.getName());
        }
    }

    private static MethodHandle handle(Method method) {
        if (method == null) {
            return null;
        }
        try {
            Class<?> clazz = method.getDeclaringClass();
            MethodType type = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
            String name = method.getName();
            return PUBLIC_LOOKUP.findStatic(clazz, name, type);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public <T> void registerBusForDispatch(TypeToken<T> eventType, IEventBus<T> bus) {
        if (!this.wrappedEventClass.equals(eventType)) {
            throw new IllegalStateException("Invalid event type");
        }
        this.mapper.prepareEvent(this.event);
        this.mapper.targetPhases().forEach(phase -> {
            E proxy = this.spinProxy((class_2960)phase, bus);
            this.event.register(phase, proxy);
        });
    }

    private <T> E spinProxy(class_2960 phase, IEventBus<T> bus) {
        try {
            MethodHandle rawListener = this.spinMethodHandle(phase, bus);
            MethodType functionalType = MethodType.methodType(this.functionalMethod.getReturnType(), this.functionalMethod.getParameterTypes());
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle implementationFactory = LambdaMetafactory.metafactory(lookup, this.functionalMethod.getName(), MethodType.methodType(this.originalEventClass, MethodHandle.class), functionalType, lookup.findVirtual(MethodHandle.class, "invokeExact", rawListener.type()), functionalType).getTarget();
            return this.originalEventClass.cast(implementationFactory.invoke(rawListener));
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to spin proxy for event listeners", e);
        }
    }

    private <T> MethodHandle spinMethodHandle(class_2960 phase, IEventBus<T> bus) throws ReflectiveOperationException {
        Class eventType = (Class)GenericUtil.uncheck(bus.eventType().getRawType());
        MethodType dispatchType = MethodType.methodType(Void.TYPE, IEventBus.class, Object.class, class_2960.class);
        MethodHandle dispatcherMethod = PUBLIC_LOOKUP.findVirtual(IFabricPhaseMapper.class, "dispatch", dispatchType);
        MethodType reorderedType = MethodType.methodType(Void.TYPE, IFabricPhaseMapper.class, Object.class, IEventBus.class, class_2960.class);
        MethodHandle reorderedDispatcher = MethodHandles.permuteArguments(dispatcherMethod, reorderedType, 0, 2, 1, 3);
        MethodHandle mapperBoundDispatcher = reorderedDispatcher.bindTo(this.mapper);
        MethodHandle boundDispatcher = MethodHandles.insertArguments(mapperBoundDispatcher, 1, bus, phase);
        MethodType castedType = MethodType.methodType(Void.TYPE, eventType);
        MethodHandle castedDispatcher = boundDispatcher.asType(castedType);
        MethodHandle eventIdentity = MethodHandles.identity(eventType);
        MethodHandle revealHandle = this.reveal == null ? MethodHandles.dropReturn(eventIdentity) : this.reveal;
        MethodHandle dispatcher = MethodHandles.foldArguments(revealHandle, castedDispatcher);
        return MethodHandles.collectArguments(dispatcher, 0, this.wrapper);
    }

    private record WrapReveal(Method wrap, Method reveal) {
    }
}

