/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.event.bus;

import com.blamejared.crafttweaker.api.event.IEventCancellationCarrier;
import com.blamejared.crafttweaker.api.event.Phase;
import com.blamejared.crafttweaker.api.event.bus.BusHandlingException;
import com.blamejared.crafttweaker.api.event.bus.CancelingEventBus;
import com.blamejared.crafttweaker.api.event.bus.DirectEventBus;
import com.blamejared.crafttweaker.api.event.bus.IEventBusWire;
import com.blamejared.crafttweaker.api.event.bus.IHandlerToken;
import com.google.common.reflect.TypeToken;
import java.util.Objects;
import java.util.function.Consumer;

public interface IEventBus<T> {
    public static <T> IEventBus<T> direct(Class<T> clazz, IEventBusWire wire) {
        Objects.requireNonNull(clazz, "class");
        Objects.requireNonNull(wire, "wire");
        return IEventBus.direct(TypeToken.of(clazz), wire);
    }

    public static <T> IEventBus<T> direct(TypeToken<T> token, IEventBusWire wire) {
        Objects.requireNonNull(token, "token");
        Objects.requireNonNull(wire, "wire");
        return DirectEventBus.of(token, wire);
    }

    public static <T> IEventBus<T> cancelable(Class<T> clazz, IEventBusWire wire, IEventCancellationCarrier<T> carrier) {
        Objects.requireNonNull(clazz, "class");
        Objects.requireNonNull(wire, "wire");
        Objects.requireNonNull(carrier, "carrier");
        return IEventBus.cancelable(TypeToken.of(clazz), wire, carrier);
    }

    public static <T> IEventBus<T> cancelable(TypeToken<T> token, IEventBusWire wire, IEventCancellationCarrier<T> carrier) {
        Objects.requireNonNull(token, "token");
        Objects.requireNonNull(wire, "wire");
        Objects.requireNonNull(carrier, "carrier");
        return CancelingEventBus.of(token, wire, carrier);
    }

    public IHandlerToken<T> registerHandler(Consumer<T> var1);

    public IHandlerToken<T> registerHandler(Phase var1, Consumer<T> var2);

    public IHandlerToken<T> registerHandler(boolean var1, Consumer<T> var2);

    public IHandlerToken<T> registerHandler(Phase var1, boolean var2, Consumer<T> var3);

    public void unregisterHandler(IHandlerToken<T> var1);

    public T post(T var1);

    public T post(Phase var1, T var2);

    public T postCatching(T var1, Consumer<BusHandlingException> var2);

    public T postCatching(Phase var1, T var2, Consumer<BusHandlingException> var3);

    public TypeToken<T> eventType();
}

