/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.manager.base;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveAll;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipe;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipeByModid;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipeByName;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipeByOutput;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipeByRegex;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.op.IDataOps;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.logging.CommonLoggers;
import com.blamejared.crafttweaker.api.recipe.RecipeList;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.api.util.NameUtil;
import com.blamejared.crafttweaker.api.zencode.util.PositionUtil;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_151;
import net.minecraft.class_156;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zencode.shared.CodePosition;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.recipe.IRecipeManager")
@Document(value="vanilla/api/recipe/manager/IRecipeManager")
public interface IRecipeManager<T extends class_1860<?>>
extends CommandStringDisplayable,
Iterable<class_8786<T>> {
    @ZenCodeType.Method
    default public void addJsonRecipe(String name, MapData mapData) {
        String fixedName = this.fixRecipeName(name);
        class_2960 recipeTypeKey = this.getBracketResourceLocation();
        IData requestedSerializer = mapData.getAt("type");
        class_2960 serializerKey = requestedSerializer == null ? recipeTypeKey : (class_2960)class_156.method_656(() -> {
            try {
                return class_2960.method_60654((String)requestedSerializer.getAsString());
            }
            catch (ClassCastException | IllegalStateException | class_151 ex) {
                throw new IllegalArgumentException("Expected 'type' field to be a valid resource location", ex);
            }
        });
        class_1865 serializer = class_7923.field_41189.method_17966(serializerKey).map(GenericUtil::uncheck).orElseThrow(() -> {
            if (requestedSerializer == null) {
                return new IllegalArgumentException("Recipe Type '%s' does not have a Recipe Serializer of the same ID. Please specify a serializer manually using the 'type' field in the JSON object".formatted(recipeTypeKey));
            }
            return new IllegalArgumentException("Recipe Serializer '%s' does not exist.".formatted(requestedSerializer));
        });
        class_2960 recipeName = CraftTweakerConstants.rl(fixedName);
        class_1860 recipe = (class_1860)serializer.method_53736().codec().parse(IDataOps.INSTANCE.withTagAddingRegistryAccess(), (Object)mapData).getOrThrow(IllegalStateException::new);
        class_3956 recipeType = recipe.method_17716();
        if (recipeType != this.getRecipeType()) {
            throw new IllegalArgumentException("Recipe Serializer \"%s\" resulted in Recipe Type \"%s\" but expected Recipe Type \"%s\"".formatted(class_7923.field_41189.method_10221((Object)recipe.method_8119()), class_7923.field_41188.method_10221((Object)recipeType), class_7923.field_41188.method_10221(this.getRecipeType())));
        }
        class_8786 holder = new class_8786(recipeName, recipe);
        CraftTweakerAPI.apply(new ActionAddRecipe(this, holder));
    }

    @ZenCodeType.Method
    default public @ZenCodeType.Nullable class_8786<T> getRecipeByName(String name) {
        return this.getRecipeList().get(name);
    }

    @ZenCodeType.Method
    default public List<class_8786<T>> getRecipesByOutput(IIngredient output) {
        return this.getRecipeList().getRecipesByOutput(output);
    }

    @ZenCodeType.Method
    default public List<class_8786<T>> getRecipesMatching(Predicate<class_8786<T>> predicate) {
        return this.getRecipeList().getRecipesMatching(predicate);
    }

    @ZenCodeType.Getter(value="allRecipes")
    default public List<class_8786<T>> getAllRecipes() {
        return new ArrayList<class_8786<T>>(this.getRecipeList().getRecipes());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="recipeMap")
    default public Map<class_2960, class_8786<T>> getRecipeMap() {
        return this.getRecipeList().getByName();
    }

    @ZenCodeType.Method
    default public void remove(IIngredient output) {
        CraftTweakerAPI.apply(new ActionRemoveRecipeByOutput(this, output));
    }

    @ZenCodeType.Method
    default public void removeByInput(IItemStack input) {
        CraftTweakerAPI.apply(new ActionRemoveRecipe(this, holder -> holder.comp_1933().method_8117().stream().anyMatch(ingredient -> ingredient.method_8093(input.getInternal()))));
    }

    @ZenCodeType.Method
    default public void removeByName(String ... names) {
        CraftTweakerAPI.apply(new ActionRemoveRecipeByName(this, (class_2960[])Arrays.stream(names).map(class_2960::method_60654).toArray(class_2960[]::new)));
    }

    @ZenCodeType.Method
    default public void removeByModid(String modid, @ZenCodeType.Optional(value="(name as string) as bool => false") Predicate<String> exclude) {
        CraftTweakerAPI.apply(new ActionRemoveRecipeByModid(this, modid, exclude));
    }

    @ZenCodeType.Method
    default public void removeByRegex(String regex, @ZenCodeType.Optional(value="(name as string) as bool => false") Predicate<String> exclude) {
        CraftTweakerAPI.apply(new ActionRemoveRecipeByRegex(this, regex, exclude));
    }

    @ZenCodeType.Method
    default public void removeMatching(Predicate<class_8786<T>> predicate) {
        CraftTweakerAPI.apply(new ActionRemoveRecipe<T>(this, predicate));
    }

    @ZenCodeType.Method
    default public void removeAll() {
        CraftTweakerAPI.apply(new ActionRemoveAll(this));
    }

    public class_3956<T> getRecipeType();

    default public RecipeList<T> getRecipeList() {
        return new RecipeList<T>(this.getRecipeType(), this.getRecipes(), CraftTweakerAPI.getAccessibleElementsProvider().accessibleRecipeManager().crafttweaker$getByName());
    }

    default public Collection<class_8786<T>> getRecipes() {
        return (Collection)GenericUtil.uncheck(CraftTweakerAPI.getAccessibleElementsProvider().accessibleRecipeManager().crafttweaker$getByType().get(this.getRecipeType()));
    }

    default public class_2960 getBracketResourceLocation() {
        return class_7923.field_41188.method_10221(this.getRecipeType());
    }

    @Override
    default public String getCommandString() {
        return "<recipetype:" + String.valueOf(this.getBracketResourceLocation()) + ">";
    }

    default public String fixRecipeName(String name) {
        CodePosition position = PositionUtil.getZCScriptPositionFromStackTrace();
        return NameUtil.fixing(name, (fixed, mistakes) -> CommonLoggers.api().warn("{}Invalid recipe name '{}', mistakes:\n{}\nNew recipe name: {}", position == CodePosition.UNKNOWN ? "" : String.valueOf(position) + ": ", (Object)name, (Object)String.join((CharSequence)"\n", mistakes), fixed));
    }

    default public class_2960 fixRecipeId(String name) {
        return this.fixRecipeId(name, CraftTweakerConstants::rl);
    }

    default public class_2960 fixRecipeId(String name, Function<String, class_2960> idMaker) {
        return idMaker.apply(this.fixRecipeName(name));
    }

    default public class_8786<T> createHolder(class_2960 id, T recipe) {
        return new class_8786(id, recipe);
    }

    @Override
    @NotNull
    default public Iterator<class_8786<T>> iterator() {
        return this.getAllRecipes().iterator();
    }
}

