/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.script.recipefs;

import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.api.util.HandleUtil;
import com.blamejared.crafttweaker.impl.script.recipefs.RecipeFileSystemProvider;
import java.lang.invoke.VarHandle;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Logger;

public final class RecipeFileSystemProviderInjector {
    private RecipeFileSystemProviderInjector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void inject(Logger logger) {
        if (RecipeFileSystemProviderInjector.exists()) {
            return;
        }
        try {
            VarHandle lock = HandleUtil.linkField(FileSystemProvider.class, HandleUtil.AccessType.STATIC, "lock", Object.class);
            VarHandle installedProviders = HandleUtil.linkField(FileSystemProvider.class, HandleUtil.AccessType.STATIC, "installedProviders", List.class);
            while (true) {
                Object object = lock.get();
                synchronized (object) {
                    List providers = (List)GenericUtil.uncheck(installedProviders.getVolatile());
                    ArrayList<RecipeFileSystemProvider> newProviders = new ArrayList<RecipeFileSystemProvider>(providers);
                    newProviders.add(new RecipeFileSystemProvider());
                    if (installedProviders.compareAndSet(providers, Collections.unmodifiableList(newProviders))) {
                        break;
                    }
                }
            }
            if (!RecipeFileSystemProviderInjector.exists()) {
                throw new RuntimeException("Unable to inject file system provider: discovered " + String.valueOf(FileSystemProvider.installedProviders()));
            }
            logger.info("Successfully injected RecipeFS file system");
        }
        catch (Throwable e) {
            throw new RuntimeException("An error occurred when attempting to inject RecipeFS file system provider", e);
        }
    }

    private static boolean exists() {
        return FileSystemProvider.installedProviders().stream().anyMatch(it -> "crt-recipe-fs".equals(it.getScheme()));
    }
}

