/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.parser;

import java.util.HashMap;
import java.util.Map;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.lexer.ParseException;
import org.openzen.zenscript.lexer.ZSToken;
import org.openzen.zenscript.lexer.ZSTokenParser;
import org.openzen.zenscript.lexer.ZSTokenType;
import org.openzen.zenscript.parser.BracketExpressionParser;
import org.openzen.zenscript.parser.expression.ParsedExpression;

public class PrefixedBracketParser
implements BracketExpressionParser {
    private final Map<String, BracketExpressionParser> subParsers = new HashMap<String, BracketExpressionParser>();
    private final BracketExpressionParser defaultParser;

    public PrefixedBracketParser(BracketExpressionParser defaultParser) {
        this.defaultParser = defaultParser;
    }

    public void register(String name, BracketExpressionParser parser) {
        this.subParsers.put(name, parser);
    }

    @Override
    public ParsedExpression parse(CodePosition position, ZSTokenParser tokens) throws ParseException {
        if (this.defaultParser == null) {
            ZSToken start = (ZSToken)tokens.required(ZSTokenType.T_IDENTIFIER, "identifier expected");
            tokens.required(ZSTokenType.T_COLON, ": expected");
            BracketExpressionParser subParser = this.subParsers.get(start.content);
            if (subParser == null) {
                throw new ParseException(position, "Invalid bracket expression: no prefix " + start.content);
            }
            return subParser.parse(position, tokens);
        }
        tokens.pushMark();
        ZSToken start = (ZSToken)tokens.next();
        if (start.type == ZSTokenType.T_IDENTIFIER && this.subParsers.containsKey(start.content)) {
            tokens.popMark();
            tokens.required(ZSTokenType.T_COLON, ": expected");
            return this.subParsers.get(start.content).parse(position, tokens);
        }
        tokens.reset();
        return this.defaultParser.parse(position, tokens);
    }
}

