/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.datagen;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_2960;
import net.spell_engine.api.effect.SpellEngineEffects;
import net.spell_engine.api.entity.SpellEntityPredicates;
import net.spell_engine.api.spell.ExternalSpellSchools;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.fx.Sound;
import net.spell_engine.client.util.Color;
import net.spell_engine.fx.SpellEngineParticles;
import net.spell_engine.fx.SpellEngineSounds;
import net.spell_power.api.SpellSchool;
import org.jetbrains.annotations.Nullable;

public class SpellBuilder {
    public static final String GROUP_PRIMARY = "primary";

    public static Spell createSpellActive() {
        Spell spell = new Spell();
        spell.type = Spell.Type.ACTIVE;
        spell.active = new Spell.Active();
        spell.active.cast = new Spell.Active.Cast();
        spell.learn = new Spell.Learn();
        return spell;
    }

    public static Spell createSpellPassive() {
        Spell spell = new Spell();
        spell.type = Spell.Type.PASSIVE;
        spell.passive = new Spell.Passive();
        return spell;
    }

    public static Spell createSpellModifier() {
        Spell spell = new Spell();
        spell.type = Spell.Type.MODIFIER;
        spell.range = 0.0f;
        spell.modifiers = new ArrayList<Spell.Modifier>();
        return spell;
    }

    public static void configureImpactEnableCondition(Spell.Impact impact, Spell.TargetCondition targetCondition) {
        Spell.Impact.TargetModifier targetModifier = new Spell.Impact.TargetModifier();
        targetModifier.conditions = List.of(targetCondition);
        impact.target_modifiers = List.of(targetModifier);
    }

    public static class Complex {
        public static void flameCloud(Spell spell, float radius, float coefficient, float timeToLive, @Nullable String attribute) {
            spell.deliver.type = Spell.Delivery.Type.CLOUD;
            spell.deliver.delay = 10;
            Spell.Delivery.Cloud cloud = new Spell.Delivery.Cloud();
            cloud.volume.radius = radius;
            cloud.volume.area.vertical_range_multiplier = 0.3f;
            cloud.volume.sound = new Sound(SpellEngineSounds.GENERIC_FIRE_IMPACT_2.id().toString());
            cloud.impact_tick_interval = 8;
            cloud.time_to_live_seconds = timeToLive;
            cloud.spawn.sound = new Sound(SpellEngineSounds.GENERIC_FIRE_IGNITE.id().toString());
            cloud.client_data = new Spell.Delivery.Cloud.ClientData();
            cloud.client_data.light_level = 15;
            cloud.client_data.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.flame_ground.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 3.0f, 0.0f, 0.0f), new ParticleBatch(SpellEngineParticles.flame_medium_a.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 2.0f, 0.02f, 0.1f), new ParticleBatch(SpellEngineParticles.flame_medium_b.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 1.0f, 0.02f, 0.1f), new ParticleBatch(SpellEngineParticles.flame_spark.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 3.0f, 0.03f, 0.2f)};
            spell.deliver.clouds = List.of(cloud);
            Spell.Impact damage = new Spell.Impact();
            if (attribute != null) {
                damage.attribute = attribute;
            }
            damage.action = new Spell.Impact.Action();
            damage.action.type = Spell.Impact.Action.Type.DAMAGE;
            damage.action.damage = new Spell.Impact.Action.Damage();
            damage.action.damage.knockback = 0.2f;
            damage.action.damage.spell_power_coefficient = coefficient;
            damage.sound = new Sound(SpellEngineSounds.GENERIC_FIRE_IMPACT_1.id().toString());
            damage.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.flame.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 20.0f, 0.05f, 0.15f), new ParticleBatch(SpellEngineParticles.flame_medium_a.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 20.0f, 0.05f, 0.15f)};
            spell.impacts = List.of(damage);
        }

        public static Spell.AreaImpact fireExplosion(float radius) {
            return Complex.fireExplosion(radius, radius / 2.5f);
        }

        public static Spell.AreaImpact fireExplosion(float radius, float scale) {
            Spell.AreaImpact area_impact = new Spell.AreaImpact();
            area_impact.radius = radius;
            area_impact.area.distance_dropoff = Spell.Target.Area.DropoffCurve.SQUARED;
            area_impact.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.fire_explosion.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 1.0f, 0.0f, 0.0f).scale(scale)};
            area_impact.sound = new Sound(SpellEngineSounds.GENERIC_FIRE_IMPACT_1.id());
            return area_impact;
        }

        public static void poisonCloud(Spell spell, float radius, float cloudDuration, float effectDuration, int effectAmplifierCap, float coefficient) {
            spell.deliver.type = Spell.Delivery.Type.CLOUD;
            spell.deliver.delay = 8;
            Spell.Delivery.Cloud cloud = new Spell.Delivery.Cloud();
            cloud.volume.radius = radius;
            cloud.volume.area.vertical_range_multiplier = 0.3f;
            cloud.volume.sound = new Sound(SpellEngineSounds.POISON_CLOUD_TICK.id().toString());
            cloud.impact_tick_interval = 8;
            cloud.time_to_live_seconds = cloudDuration;
            cloud.spawn.sound = new Sound(SpellEngineSounds.POISON_CLOUD_SPAWN.id().toString());
            cloud.client_data = new Spell.Delivery.Cloud.ClientData();
            cloud.client_data.light_level = 0;
            cloud.client_data.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.smoke_large.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 1.0f, 0.01f, 0.02f).color(2583652010L), new ParticleBatch(SpellEngineParticles.smoke_large.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 1.0f, 0.01f, 0.02f).color(0x33DD33EEL)};
            spell.deliver.clouds = List.of(cloud);
            Spell.Impact impact = Impacts.effectAdd("poison", effectDuration, 1, effectAmplifierCap);
            impact.action.status_effect.amplifier_cap_power_multiplier = coefficient;
            impact.action.status_effect.show_particles = true;
            impact.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.smoke_large.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 0.5f, 0.01f, 0.02f).color(0x33DD33AAL), new ParticleBatch(SpellEngineParticles.MagicParticles.get(SpellEngineParticles.MagicParticles.Shape.SKULL, SpellEngineParticles.MagicParticles.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 3.0f, 0.1f, 0.2f).color(0x33DD33AAL)};
            spell.impacts = List.of(impact);
        }
    }

    public static class Particles {
        public static ParticleBatch popUpSign(class_2960 signId, Color color) {
            return new ParticleBatch(signId.toString(), ParticleBatch.Shape.LINE_VERTICAL, ParticleBatch.Origin.CENTER, 1.0f, 0.8f, 0.8f).scale(0.8f).color(color.toRGBA()).followEntity(true);
        }

        public static ParticleBatch area(class_2960 id) {
            return new ParticleBatch(id.toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.GROUND, 1.0f, 0.0f, 0.0f);
        }

        public static ParticleBatch aura(class_2960 id) {
            return new ParticleBatch(id.toString(), ParticleBatch.Shape.LINE, ParticleBatch.Origin.CENTER, 1.0f, 0.0f, 0.0f).followEntity(true);
        }

        public static ParticleBatch[] zoneMagic(long color, class_2960 contour, List<class_2960> fillers, float multiplier) {
            ArrayList<ParticleBatch> particles = new ArrayList<ParticleBatch>();
            particles.add(new ParticleBatch(contour.toString(), ParticleBatch.Shape.PIPE, ParticleBatch.Origin.GROUND, 3.0f * multiplier, 0.05f, 0.15f).color(color));
            for (class_2960 filler : fillers) {
                particles.add(new ParticleBatch(filler.toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.GROUND, 3.0f * multiplier, 0.05f, 0.1f).color(color));
            }
            return particles.toArray(new ParticleBatch[0]);
        }
    }

    public static class Cost {
        public static void exhaust(Spell spell, float exhaust) {
            if (spell.cost == null) {
                spell.cost = new Spell.Cost();
            }
            spell.cost.exhaust = exhaust;
        }

        public static void cooldown(Spell spell, float duration) {
            if (spell.cost == null) {
                spell.cost = new Spell.Cost();
            }
            if (spell.cost.cooldown == null) {
                spell.cost.cooldown = new Spell.Cost.Cooldown();
            }
            spell.cost.cooldown.duration = duration;
        }

        public static void item(Spell spell, String itemId) {
            Cost.item(spell, itemId, 1);
        }

        public static void item(Spell spell, String itemId, int amount) {
            if (spell.cost == null) {
                spell.cost = new Spell.Cost();
            }
            if (spell.cost.item == null) {
                spell.cost.item = new Spell.Cost.Item();
            }
            spell.cost.item.id = itemId;
            spell.cost.item.amount = amount;
        }
    }

    public static class ImpactModifiers {
        public static Spell.Impact.TargetModifier create(String entityType) {
            Spell.TargetCondition condition = new Spell.TargetCondition();
            condition.entity_type = entityType;
            Spell.Impact.TargetModifier modifier = new Spell.Impact.TargetModifier();
            modifier.conditions = List.of(condition);
            return modifier;
        }

        public static Spell.Impact.TargetModifier extraDamageAgainstUndead() {
            Spell.Impact.TargetModifier modifier = ImpactModifiers.create("#minecraft:undead");
            Spell.Impact.Modifier powerModifier = new Spell.Impact.Modifier();
            powerModifier.power_multiplier = 0.5f;
            modifier.modifier = powerModifier;
            return modifier;
        }

        public static Spell.Impact.TargetModifier alwaysCritAgainstUndead() {
            Spell.Impact.TargetModifier modifier = ImpactModifiers.create("#minecraft:undead");
            Spell.Impact.Modifier powerModifier = new Spell.Impact.Modifier();
            powerModifier.critical_chance_bonus = 1.0f;
            modifier.modifier = powerModifier;
            return modifier;
        }
    }

    public static class Impacts {
        public static Spell.Impact damage(float coefficient, float knockback) {
            Spell.Impact impact = new Spell.Impact();
            impact.action = new Spell.Impact.Action();
            impact.action.type = Spell.Impact.Action.Type.DAMAGE;
            impact.action.damage = new Spell.Impact.Action.Damage();
            impact.action.damage.spell_power_coefficient = coefficient;
            impact.action.damage.knockback = knockback;
            return impact;
        }

        public static Spell.Impact heal(float spell_power_coefficient) {
            Spell.Impact impact = new Spell.Impact();
            impact.action = new Spell.Impact.Action();
            impact.action.type = Spell.Impact.Action.Type.HEAL;
            impact.action.heal = new Spell.Impact.Action.Heal();
            impact.action.heal.spell_power_coefficient = spell_power_coefficient;
            return impact;
        }

        public static Spell.Impact effectSet(String effectIdString, float duration, int amplifier) {
            Spell.Impact impact = new Spell.Impact();
            impact.action = new Spell.Impact.Action();
            impact.action.type = Spell.Impact.Action.Type.STATUS_EFFECT;
            impact.action.status_effect = new Spell.Impact.Action.StatusEffect();
            impact.action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.SET;
            impact.action.status_effect.effect_id = effectIdString;
            impact.action.status_effect.duration = duration;
            impact.action.status_effect.amplifier = amplifier;
            return impact;
        }

        public static Spell.Impact effectAdd(String effectIdString, float duration, int amplifier, int amplifierCap) {
            Spell.Impact impact = new Spell.Impact();
            impact.action = new Spell.Impact.Action();
            impact.action.type = Spell.Impact.Action.Type.STATUS_EFFECT;
            impact.action.status_effect = new Spell.Impact.Action.StatusEffect();
            impact.action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.ADD;
            impact.action.status_effect.effect_id = effectIdString;
            impact.action.status_effect.duration = duration;
            impact.action.status_effect.amplifier = amplifier;
            impact.action.status_effect.amplifier_cap = amplifierCap;
            return impact;
        }

        public static Spell.Impact effectCleanse() {
            Spell.Impact cleanse = new Spell.Impact();
            cleanse.action = new Spell.Impact.Action();
            cleanse.action.type = Spell.Impact.Action.Type.STATUS_EFFECT;
            cleanse.action.status_effect = new Spell.Impact.Action.StatusEffect();
            cleanse.action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.REMOVE;
            cleanse.action.status_effect.remove = new Spell.Impact.Action.StatusEffect.Remove();
            cleanse.action.status_effect.remove.id = "!" + class_1294.field_50116.method_55840();
            cleanse.action.status_effect.remove.selector = Spell.Impact.Action.StatusEffect.Remove.Selector.RANDOM;
            cleanse.action.status_effect.remove.select_beneficial = false;
            cleanse.sound = new Sound(SpellEngineSounds.GENERIC_DISPEL_1.id());
            return cleanse;
        }

        public static Spell.Impact effectRemove(String effectIdString) {
            Spell.Impact impact = new Spell.Impact();
            impact.action = new Spell.Impact.Action();
            impact.action.type = Spell.Impact.Action.Type.STATUS_EFFECT;
            impact.action.status_effect = new Spell.Impact.Action.StatusEffect();
            impact.action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.REMOVE;
            impact.action.status_effect.remove = new Spell.Impact.Action.StatusEffect.Remove();
            impact.action.status_effect.remove.id = effectIdString;
            return impact;
        }

        public static Spell.Impact stun(float duration) {
            Spell.Impact impact = Impacts.effectSet(SpellEngineEffects.STUN.id.toString(), duration, 0);
            impact.sound = new Sound(SpellEngineSounds.STUN_GENERIC.id().toString());
            return impact;
        }

        public static Spell.Impact taunt() {
            Spell.Impact taunt = new Spell.Impact();
            taunt.action = new Spell.Impact.Action();
            taunt.action.type = Spell.Impact.Action.Type.AGGRO;
            taunt.action.aggro = new Spell.Impact.Action.Aggro();
            taunt.action.aggro.mode = Spell.Impact.Action.Aggro.Mode.SET;
            return taunt;
        }

        public static Spell.Impact disengage(boolean onlyIfTargeted) {
            Spell.Impact taunt = new Spell.Impact();
            taunt.action = new Spell.Impact.Action();
            taunt.action.type = Spell.Impact.Action.Type.AGGRO;
            taunt.action.aggro = new Spell.Impact.Action.Aggro();
            taunt.action.aggro.mode = Spell.Impact.Action.Aggro.Mode.CLEAR;
            taunt.action.aggro.only_if_targeted = onlyIfTargeted;
            return taunt;
        }

        public static Spell.Impact fire(float duration) {
            Spell.Impact fire = new Spell.Impact();
            fire.action = new Spell.Impact.Action();
            fire.action.type = Spell.Impact.Action.Type.FIRE;
            fire.action.fire = new Spell.Impact.Action.Fire();
            fire.action.fire.duration = duration;
            return fire;
        }

        public static Spell.Impact resetCooldownActive(String spellPattern) {
            Spell.Impact impact = new Spell.Impact();
            impact.action = new Spell.Impact.Action();
            impact.action.type = Spell.Impact.Action.Type.COOLDOWN;
            impact.action.cooldown = new Spell.Impact.Action.Cooldown();
            impact.action.cooldown.actives = new Spell.Impact.Action.Cooldown.Modify();
            impact.action.cooldown.actives.id = spellPattern;
            impact.action.cooldown.actives.duration_multiplier = 0.0f;
            return impact;
        }

        public static Spell.Impact resetCooldownActiveAll() {
            Spell.Impact impact = new Spell.Impact();
            impact.action = new Spell.Impact.Action();
            impact.action.type = Spell.Impact.Action.Type.COOLDOWN;
            impact.action.cooldown = new Spell.Impact.Action.Cooldown();
            impact.action.cooldown.actives = new Spell.Impact.Action.Cooldown.Modify();
            impact.action.cooldown.actives.id = "*";
            impact.action.cooldown.actives.duration_multiplier = 0.0f;
            return impact;
        }
    }

    public static class Triggers {
        public static Spell.Trigger activeSpellHit(float chance, @Nullable String schoolRegex) {
            Spell.Trigger trigger = Triggers.spellHit(chance, schoolRegex);
            trigger.spell.type = Spell.Type.ACTIVE;
            return trigger;
        }

        public static Spell.Trigger spellHit(float chance, @Nullable String schoolRegex) {
            Spell.Trigger trigger = new Spell.Trigger();
            trigger.impact = new Spell.Trigger.ImpactCondition();
            trigger.impact.impact_type = Spell.Impact.Action.Type.DAMAGE.toString();
            trigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
            trigger.spell = new Spell.Trigger.SpellCondition();
            trigger.spell.school = schoolRegex;
            trigger.chance = chance;
            return trigger;
        }

        public static Spell.Trigger specificSpellHit(String spellId) {
            Spell.Trigger trigger = new Spell.Trigger();
            trigger.impact = new Spell.Trigger.ImpactCondition();
            trigger.impact.impact_type = Spell.Impact.Action.Type.DAMAGE.toString();
            trigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
            trigger.spell = new Spell.Trigger.SpellCondition();
            trigger.spell.id = spellId;
            return trigger;
        }

        public static Spell.Trigger activeSpellCrit() {
            Spell.Trigger trigger = new Spell.Trigger();
            trigger.impact = new Spell.Trigger.ImpactCondition();
            trigger.impact.critical = true;
            trigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
            trigger.spell = new Spell.Trigger.SpellCondition();
            trigger.spell.type = Spell.Type.ACTIVE;
            return trigger;
        }

        public static Spell.Trigger specificSpellAreaImpact(String spellId) {
            Spell.Trigger trigger = new Spell.Trigger();
            trigger.type = Spell.Trigger.Type.SPELL_AREA_IMPACT;
            trigger.spell = new Spell.Trigger.SpellCondition();
            trigger.spell.id = spellId;
            return trigger;
        }

        public static Spell.Trigger specificSpellCast(String spellId) {
            Spell.Trigger trigger = new Spell.Trigger();
            trigger.type = Spell.Trigger.Type.SPELL_CAST;
            trigger.spell = new Spell.Trigger.SpellCondition();
            trigger.spell.id = spellId;
            return trigger;
        }

        public static Spell.Trigger spellCast(SpellSchool school) {
            return Triggers.spellCast(school.id.toString());
        }

        public static Spell.Trigger spellCast(String school) {
            Spell.Trigger trigger = new Spell.Trigger();
            trigger.type = Spell.Trigger.Type.SPELL_CAST;
            trigger.spell = new Spell.Trigger.SpellCondition();
            trigger.spell.school = school;
            return trigger;
        }

        public static Spell.Trigger activeSpellCast() {
            return Triggers.activeSpellCast((String)null);
        }

        public static Spell.Trigger activeSpellCast(SpellSchool school) {
            return Triggers.activeSpellCast(school.id.toString());
        }

        public static Spell.Trigger activeSpellCast(String school) {
            Spell.Trigger trigger = Triggers.spellCast(school);
            trigger.spell.type = Spell.Type.ACTIVE;
            return trigger;
        }

        public static Spell.Trigger activeSpellHeal(float chance) {
            Spell.Trigger trigger = new Spell.Trigger();
            trigger.impact = new Spell.Trigger.ImpactCondition();
            trigger.impact.impact_type = Spell.Impact.Action.Type.HEAL.toString();
            trigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
            trigger.spell = new Spell.Trigger.SpellCondition();
            trigger.spell.type = Spell.Type.ACTIVE;
            trigger.chance = chance;
            return trigger;
        }

        public static Spell.Trigger meleeAttack(boolean mustWield) {
            Spell.Trigger trigger = new Spell.Trigger();
            trigger.type = Spell.Trigger.Type.MELEE_IMPACT;
            if (mustWield) {
                trigger.equipment_condition = class_1304.field_6173;
            }
            return trigger;
        }

        public static Spell.Trigger meleeKill(boolean mustWield) {
            Spell.TargetCondition deadCondition = TargetConditions.dead();
            Spell.Trigger trigger = Triggers.meleeAttack(mustWield);
            trigger.target_conditions = List.of(deadCondition);
            Spell.Trigger skillTrigger = new Spell.Trigger();
            skillTrigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
            skillTrigger.spell = new Spell.Trigger.SpellCondition();
            skillTrigger.spell.school = ExternalSpellSchools.PHYSICAL_MELEE.id.toString();
            skillTrigger.target_conditions = List.of(deadCondition);
            return trigger;
        }

        public static Spell.Trigger spellKill() {
            Spell.Trigger trigger = new Spell.Trigger();
            trigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
            trigger.impact = new Spell.Trigger.ImpactCondition();
            trigger.impact.impact_type = Spell.Impact.Action.Type.DAMAGE.toString();
            Spell.TargetCondition deadCondition = TargetConditions.dead();
            trigger.target_conditions = List.of(deadCondition);
            return trigger;
        }

        public static Spell.Trigger rangedAttack() {
            return Triggers.rangedAttack(false);
        }

        public static Spell.Trigger rangedAttack(boolean mustWield) {
            Spell.Trigger arrowTrigger = new Spell.Trigger();
            arrowTrigger.type = Spell.Trigger.Type.ARROW_IMPACT;
            if (mustWield) {
                arrowTrigger.equipment_condition = class_1304.field_6173;
            }
            return arrowTrigger;
        }

        public static List<Spell.Trigger> rangedKill() {
            return Triggers.rangedKill(false);
        }

        public static List<Spell.Trigger> rangedKill(boolean mustWield) {
            Spell.TargetCondition deadCondition = TargetConditions.dead();
            Spell.Trigger arrowTrigger = Triggers.rangedAttack(mustWield);
            arrowTrigger.target_conditions = List.of(deadCondition);
            Spell.Trigger skillTrigger = new Spell.Trigger();
            skillTrigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
            skillTrigger.spell = new Spell.Trigger.SpellCondition();
            skillTrigger.spell.school = ExternalSpellSchools.PHYSICAL_RANGED.id.toString();
            skillTrigger.target_conditions = List.of(deadCondition);
            return List.of(arrowTrigger, skillTrigger);
        }

        public static Spell.Trigger shieldBlock() {
            Spell.Trigger trigger = new Spell.Trigger();
            trigger.type = Spell.Trigger.Type.SHIELD_BLOCK;
            return trigger;
        }

        public static Spell.Trigger arrowHit() {
            Spell.Trigger trigger = new Spell.Trigger();
            trigger.type = Spell.Trigger.Type.ARROW_IMPACT;
            return trigger;
        }

        public static Spell.Trigger arrowShot() {
            Spell.Trigger trigger = new Spell.Trigger();
            trigger.type = Spell.Trigger.Type.ARROW_SHOT;
            return trigger;
        }

        public static Spell.Trigger arrowShot(boolean firedBySpell) {
            Spell.Trigger trigger = Triggers.arrowShot();
            trigger.arrow_shot = new Spell.Trigger.ArrowShotCondition();
            trigger.arrow_shot.from_spell = firedBySpell;
            return trigger;
        }

        public static Spell.Trigger roll() {
            Spell.Trigger trigger = new Spell.Trigger();
            trigger.type = Spell.Trigger.Type.ROLL;
            return trigger;
        }

        public static Spell.Trigger evade() {
            Spell.Trigger trigger = new Spell.Trigger();
            trigger.type = Spell.Trigger.Type.EVASION;
            return trigger;
        }

        public static Spell.Trigger damageTaken() {
            Spell.Trigger trigger = new Spell.Trigger();
            trigger.type = Spell.Trigger.Type.DAMAGE_TAKEN;
            return trigger;
        }

        public static Spell.Trigger damageIncoming() {
            Spell.Trigger trigger = new Spell.Trigger();
            trigger.type = Spell.Trigger.Type.DAMAGE_TAKEN;
            trigger.stage = Spell.Trigger.Stage.PRE;
            return trigger;
        }

        public static Spell.Trigger damageIncomingFatal() {
            Spell.Trigger trigger = Triggers.damageIncoming();
            trigger.damage = new Spell.Trigger.DamageCondition();
            trigger.damage.fatal = true;
            return trigger;
        }

        public static Spell.Trigger effectTick(String effectId) {
            Spell.Trigger trigger = new Spell.Trigger();
            trigger.type = Spell.Trigger.Type.EFFECT_TICK;
            trigger.effect = new Spell.Trigger.EffectCondition();
            trigger.effect.id = effectId;
            return trigger;
        }

        public static Spell.Trigger becomingLowHP(float healthThreshold) {
            Spell.Trigger trigger = Triggers.damageTaken();
            trigger.stage = Spell.Trigger.Stage.POST;
            trigger.caster_conditions = List.of(TargetConditions.lowHP(healthThreshold));
            return trigger;
        }
    }

    public static class Deliver {
        public static void stash(Spell spell, String stashEffectId, float duration, Spell.Trigger trigger) {
            Deliver.stash(spell, stashEffectId, duration, List.of(trigger));
        }

        public static void stash(Spell spell, String stashEffectId, float duration, List<Spell.Trigger> triggers) {
            spell.deliver.type = Spell.Delivery.Type.STASH_EFFECT;
            spell.deliver.stash_effect = new Spell.Delivery.StashEffect();
            spell.deliver.stash_effect.id = stashEffectId;
            spell.deliver.stash_effect.duration = duration;
            spell.deliver.stash_effect.triggers = triggers;
        }

        public static Spell.EntityPlacement placementByLook(float distanceOffset, float angleOffset, int delay) {
            Spell.EntityPlacement placement = new Spell.EntityPlacement();
            placement.location_offset_by_look = distanceOffset;
            placement.location_yaw_offset = angleOffset;
            placement.apply_yaw = true;
            placement.delay_ticks = delay;
            return placement;
        }

        public static Spell.Delivery.Cloud cloud(float timeToLive, float radius, class_2960 spawnSound, int light_level, ParticleBatch[] presenceParticles) {
            Spell.Delivery.Cloud cloud = new Spell.Delivery.Cloud();
            cloud.volume = new Spell.AreaImpact();
            cloud.volume.area.vertical_range_multiplier = 0.3f;
            cloud.volume.radius = radius;
            cloud.impact_tick_interval = 4;
            cloud.time_to_live_seconds = timeToLive;
            cloud.spawn.sound = new Sound(spawnSound.toString());
            cloud.client_data = new Spell.Delivery.Cloud.ClientData();
            cloud.client_data.light_level = light_level;
            cloud.client_data.particles = presenceParticles;
            return cloud;
        }
    }

    public static class TargetConditions {
        public static Spell.TargetCondition dead() {
            Spell.TargetCondition deadCondition = new Spell.TargetCondition();
            deadCondition.health_percent_below = 0.0f;
            deadCondition.health_percent_above = 0.0f;
            return deadCondition;
        }

        public static Spell.TargetCondition lowHP() {
            return TargetConditions.lowHP(0.5f);
        }

        public static Spell.TargetCondition lowHP(float maxHealthPercent) {
            Spell.TargetCondition deadCondition = new Spell.TargetCondition();
            deadCondition.health_percent_below = maxHealthPercent;
            deadCondition.health_percent_above = 0.01f;
            return deadCondition;
        }

        public static Spell.TargetCondition hasEffect(class_2960 effectId) {
            Spell.TargetCondition effectCondition = new Spell.TargetCondition();
            effectCondition.entity_predicate_id = SpellEntityPredicates.HAS_EFFECT.id().toString();
            effectCondition.entity_predicate_param = effectId.toString();
            return effectCondition;
        }

        public static Spell.TargetCondition ofPredicate(SpellEntityPredicates.Entry entityPredicate) {
            Spell.TargetCondition targetCondition = new Spell.TargetCondition();
            targetCondition.entity_predicate_id = entityPredicate.id().toString();
            return targetCondition;
        }
    }

    public static class Release {
        public static void visuals(Spell spell, @Nullable String playerAnimation, @Nullable ParticleBatch[] particles, @Nullable Sound sound) {
            spell.release = new Spell.Release();
            if (playerAnimation != null) {
                spell.release.animation = playerAnimation;
            }
            if (particles != null) {
                spell.release.particles = particles;
            }
            if (sound != null) {
                spell.release.sound = sound;
            }
        }
    }

    public static class Casting {
        public static void instant(Spell spell) {
            spell.active.cast = new Spell.Active.Cast();
            spell.active.cast.duration = 0.0f;
        }

        public static void cast(Spell spell, float duration) {
            spell.active.cast = new Spell.Active.Cast();
            spell.active.cast.duration = duration;
        }

        public static void channel(Spell spell, float duration, int ticks) {
            spell.active.cast = new Spell.Active.Cast();
            spell.active.cast.duration = duration;
            spell.active.cast.channel_ticks = ticks;
        }

        public static void visuals(Spell spell, @Nullable String playerAnimation, @Nullable ParticleBatch[] particles, @Nullable Sound sound) {
            if (spell.active.cast == null) {
                spell.active.cast = new Spell.Active.Cast();
            }
            if (playerAnimation != null) {
                spell.active.cast.animation = playerAnimation;
            }
            if (particles != null) {
                spell.active.cast.particles = particles;
            }
        }
    }
}

