/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.item;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.spell_engine.api.item.trinket.ISpellBookItem;
import net.spell_engine.api.item.trinket.SpellBookItem;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.compat.trinkets.SpellBookTrinketItem;
import net.spell_engine.compat.trinkets.TrinketsCompat;
import net.spell_engine.fx.SpellEngineSounds;
import net.spell_engine.internals.container.SpellAssignments;

public class SpellBooks {
    public static final ArrayList<ISpellBookItem> all = new ArrayList();

    public static List<ISpellBookItem> sorted(class_1937 world) {
        return all.stream().sorted(Comparator.comparing(spellBookItem -> spellBookItem.getPoolId().toString())).filter(spellBookItem -> {
            List<class_6880<Spell>> pool = SpellRegistry.entries(world, spellBookItem.getPoolId());
            return pool != null && !pool.isEmpty();
        }).collect(Collectors.toList());
    }

    public static ISpellBookItem create(class_2960 poolId) {
        return SpellBooks.create(poolId, SpellContainer.ContentType.MAGIC);
    }

    public static ISpellBookItem create(class_2960 poolId, SpellContainer.ContentType contentType) {
        return SpellBooks.create(poolId, contentType, 0);
    }

    public static ISpellBookItem create(class_2960 poolId, SpellContainer.ContentType contentType, int maxSpellCount) {
        SpellContainer container = new SpellContainer(contentType, false, poolId.toString(), maxSpellCount, List.of());
        SpellAssignments.book_containers.put(SpellBooks.itemIdFor(poolId), container);
        ISpellBookItem book = null;
        TrinketsCompat.init();
        book = TrinketsCompat.isEnabled() ? new SpellBookTrinketItem(new class_1792.class_1793().method_7889(1), poolId, SpellEngineSounds.SPELLBOOK_EQUIP.soundEvent()) : new SpellBookItem(poolId, new class_1792.class_1793().method_7889(1));
        all.add(book);
        return book;
    }

    public static class_2960 itemIdFor(class_2960 poolId) {
        return class_2960.method_60655((String)poolId.method_12836(), (String)(poolId.method_12832() + "_spell_book"));
    }

    public static void register(ISpellBookItem spellBook) {
        if (!(spellBook instanceof class_1792)) {
            throw new IllegalArgumentException("SpellBookItem must be an Item");
        }
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)SpellBooks.itemIdFor(spellBook.getPoolId()), (Object)((class_1792)spellBook));
    }

    public static void createAndRegister(class_2960 poolId, class_5321<class_1761> itemGroupKey) {
        SpellBooks.createAndRegister(poolId, SpellContainer.ContentType.MAGIC, itemGroupKey);
    }

    public static void createAndRegister(class_2960 poolId, SpellContainer.ContentType contentType, class_5321<class_1761> itemGroupKey) {
        ISpellBookItem item = SpellBooks.create(poolId, contentType);
        ItemGroupEvents.modifyEntriesEvent(itemGroupKey).register(content -> content.method_45421((class_1935)item));
        SpellBooks.register(item);
    }
}

