/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.item.armor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.spell_engine.api.config.ArmorSetConfig;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.armor.ConfigurableAttributes;
import net.spell_engine.mixin.item.ArmorMaterialLayerAccessor;
import org.jetbrains.annotations.Nullable;

public class Armor {
    public static void register(Map<String, ArmorSetConfig> configs, List<Entry> entries, class_5321<class_1761> itemGroupKey) {
        for (Entry entry : entries) {
            ArmorSetConfig config = configs.get(entry.name());
            if (config == null) {
                config = entry.defaults();
                configs.put(entry.name(), config);
            }
            for (Object piece : entry.armorSet().pieces()) {
                class_1304 slot = ((class_1738)piece).method_7685();
                ((ConfigurableAttributes)piece).setAttributes(Armor.attributesFrom(config, ((class_1738)piece).method_48398()));
            }
            entry.armorSet().register(itemGroupKey);
        }
    }

    private static class_9285 attributesFrom(ArmorSetConfig config, class_1738.class_8051 slot) {
        ArmorSetConfig.Piece piece = null;
        class_2960 modifierId = class_2960.method_60656((String)("armor." + slot.method_48400()));
        switch (slot) {
            case field_41937: {
                piece = config.feet;
                break;
            }
            case field_41936: {
                piece = config.legs;
                break;
            }
            case field_41935: {
                piece = config.chest;
                break;
            }
            case field_41934: {
                piece = config.head;
            }
        }
        class_9285.class_9286 builder = class_9285.method_57480();
        class_9274 attributeModifierSlot = class_9274.method_59524((class_1304)slot.method_48399());
        if (config.armor_toughness != 0.0f) {
            builder.method_57487(class_5134.field_23725, new class_1322(modifierId, (double)config.armor_toughness, class_1322.class_1323.field_6328), attributeModifierSlot);
        }
        if (config.knockback_resistance != 0.0f) {
            builder.method_57487(class_5134.field_23718, new class_1322(modifierId, (double)config.knockback_resistance, class_1322.class_1323.field_6328), attributeModifierSlot);
        }
        if (piece.armor != 0) {
            builder.method_57487(class_5134.field_23724, new class_1322(modifierId, (double)piece.armor, class_1322.class_1323.field_6328), attributeModifierSlot);
        }
        for (AttributeModifier attribute : piece.attributes) {
            try {
                class_6880.class_6883 entityAttribute = (class_6880.class_6883)class_7923.field_41190.method_55841(class_2960.method_60654((String)attribute.attribute)).get();
                builder.method_57487((class_6880)entityAttribute, new class_1322(modifierId, (double)attribute.value, attribute.operation), attributeModifierSlot);
            }
            catch (Exception e) {
                System.err.println("Failed to add item attribute modifier: " + e.getMessage());
            }
        }
        return builder.method_57486();
    }

    public record Entry(class_6880<class_1741> material, Set armorSet, ArmorSetConfig defaults, Equipment.LootProperties lootProperties) {
        public static Entry create(class_6880<class_1741> material, class_2960 id, int durability, Set.ItemFactory factory, ArmorSetConfig defaults) {
            return Entry.create(material, id, durability, factory, defaults, Equipment.LootProperties.EMPTY);
        }

        public static Entry create(class_6880<class_1741> material, class_2960 id, int durability, Set.ItemFactory factory, ArmorSetConfig defaults, Equipment.LootProperties lootProperties) {
            return Entry.create(material, id, durability, factory, defaults, lootProperties, null);
        }

        public static Entry create(class_6880<class_1741> material, class_2960 id, int durability, Set.ItemFactory factory, ArmorSetConfig defaults, Equipment.LootProperties lootProperties, @Nullable ItemSettingsTweaker settingsTweaker) {
            int tier;
            class_1792.class_1793 helmetSettings = new class_1792.class_1793().method_7895(class_1738.class_8051.field_41934.method_56690(durability));
            class_1792.class_1793 chestplateSettings = new class_1792.class_1793().method_7895(class_1738.class_8051.field_41935.method_56690(durability));
            class_1792.class_1793 leggingsSettings = new class_1792.class_1793().method_7895(class_1738.class_8051.field_41936.method_56690(durability));
            class_1792.class_1793 bootsSettings = new class_1792.class_1793().method_7895(class_1738.class_8051.field_41937.method_56690(durability));
            if (settingsTweaker != null) {
                settingsTweaker.helmet.accept(helmetSettings);
                settingsTweaker.chestplate.accept(chestplateSettings);
                settingsTweaker.leggings.accept(leggingsSettings);
                settingsTweaker.boots.accept(bootsSettings);
            }
            if ((tier = lootProperties.tier()) >= 3) {
                helmetSettings.method_24359();
                chestplateSettings.method_24359();
                leggingsSettings.method_24359();
                bootsSettings.method_24359();
            }
            Set set = new Set(id.method_12836(), id.method_12832(), factory.create(material, class_1738.class_8051.field_41934, helmetSettings), factory.create(material, class_1738.class_8051.field_41935, chestplateSettings), factory.create(material, class_1738.class_8051.field_41936, leggingsSettings), factory.create(material, class_1738.class_8051.field_41937, bootsSettings));
            return new Entry(material, set, defaults, lootProperties);
        }

        public Entry translatedName(String headName, String chestName, String legsName, String feetName) {
            this.armorSet.translate(headName, chestName, legsName, feetName);
            return this;
        }

        public String name() {
            return this.armorSet.name;
        }

        public <T extends class_1738> Entry bundle(Function<class_6880<class_1741>, Set<T>> factory) {
            Set<T> armorSet = factory.apply(this.material);
            return new Entry(this.material, armorSet, this.defaults, this.lootProperties);
        }

        public <T extends class_1738> Entry put(ArrayList<Entry> list) {
            list.add(this);
            return this;
        }
    }

    public static class Set<A extends class_1738> {
        public final String namespace;
        public final String name;
        public final A head;
        public final A chest;
        public final A legs;
        public final A feet;
        public String headTranslation;
        public String chestTranslation;
        public String legsTranslation;
        public String feetTranslation = "";

        public Set(String namespace, String name, A head, A chest, A legs, A feet) {
            this.namespace = namespace;
            this.name = name;
            this.head = head;
            this.chest = chest;
            this.legs = legs;
            this.feet = feet;
        }

        public List<A> pieces() {
            return Stream.of(this.head, this.chest, this.legs, this.feet).filter(Objects::nonNull).collect(Collectors.toList());
        }

        public class_2960 idOf(class_1738 piece) {
            String name = this.name + "_" + piece.method_7685().method_5923();
            return class_2960.method_60655((String)this.namespace, (String)name);
        }

        public List<String> idStrings() {
            return this.pieces().stream().map(piece -> this.idOf((class_1738)piece).toString()).toList();
        }

        public List<class_2960> pieceIds() {
            return this.pieces().stream().map(this::idOf).toList();
        }

        public Set<A> translate(String headName, String chestName, String legsName, String feetName) {
            this.headTranslation = headName;
            this.chestTranslation = chestName;
            this.legsTranslation = legsName;
            this.feetTranslation = feetName;
            return this;
        }

        public void register(class_5321<class_1761> itemGroupKey) {
            for (class_1738 piece : this.pieces()) {
                class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)this.idOf(piece), (Object)piece);
            }
            ItemGroupEvents.modifyEntriesEvent(itemGroupKey).register(content -> {
                for (class_1738 piece : this.pieces()) {
                    content.method_45421((class_1935)piece);
                }
            });
        }

        public static interface ItemFactory<T extends class_1738> {
            public T create(class_6880<class_1741> var1, class_1738.class_8051 var2, class_1792.class_1793 var3);
        }
    }

    public record ItemSettingsTweaker(Consumer<class_1792.class_1793> helmet, Consumer<class_1792.class_1793> chestplate, Consumer<class_1792.class_1793> leggings, Consumer<class_1792.class_1793> boots) {
        public static ItemSettingsTweaker standard(Consumer<class_1792.class_1793> consumer) {
            return new ItemSettingsTweaker(consumer, consumer, consumer, consumer);
        }
    }

    public static class CustomItem
    extends class_1738
    implements ConfigurableAttributes {
        private class_9285 attributeModifiers = class_9285.method_57480().method_57486();
        public final class_6880<class_1741> customMaterial;

        public CustomItem(class_6880<class_1741> material, class_1738.class_8051 slot, class_1792.class_1793 settings) {
            super(material, slot, settings);
            this.customMaterial = material;
        }

        @Override
        public void setAttributes(class_9285 attributeModifiers) {
            this.attributeModifiers = attributeModifiers;
        }

        public class_9285 method_7844() {
            return this.attributeModifiers;
        }

        public class_2960 getFirstLayerId() {
            class_1741.class_9196 fristLayer = (class_1741.class_9196)((class_1741)this.customMaterial.comp_349()).comp_2302().getFirst();
            return ((ArmorMaterialLayerAccessor)fristLayer).getId();
        }
    }
}

