/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.input;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_315;
import net.minecraft.class_3675;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.client.gui.HudMessages;
import net.spell_engine.client.input.Keybindings;
import net.spell_engine.client.input.WrappedKeybinding;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.casting.SpellCasterClient;
import net.spell_engine.internals.container.SpellContainerSource;
import net.spell_engine.mixin.client.control.KeybindingAccessor;
import net.spell_engine.network.Packets;
import org.jetbrains.annotations.Nullable;

public class SpellHotbar {
    public static SpellHotbar INSTANCE = new SpellHotbar();
    public List<Slot> slots = List.of();
    public StructuredSlots structuredSlots = new StructuredSlots(null, List.of());
    @Nullable
    private Handle handledThisTick = null;
    @Nullable
    private Handle lastPressed = null;
    private int itemUseCooldown = 0;
    private class_6880<Spell> attemptedSpell = null;
    private class_2960 lastSyncedSpellId = null;
    private final HashMap<class_304, UseCase> debounced = new HashMap();

    public boolean update(class_746 player, class_315 options) {
        boolean changed = false;
        int initialSlotCount = this.slots.size();
        SpellContainer mergedContainer = SpellContainerSource.activeContainerOf((class_1657)player);
        ArrayList<Slot> slots = new ArrayList<Slot>();
        ArrayList<Slot> otherSlots = new ArrayList<Slot>();
        Slot onUseKey = null;
        List<WrappedKeybinding> allBindings = Keybindings.Wrapped.all();
        class_3675.class_306 useKey = ((KeybindingAccessor)options.field_1904).getBoundKey();
        WrappedKeybinding useKeyBinding = new WrappedKeybinding(options.field_1904, WrappedKeybinding.VanillaAlternative.USE_KEY);
        if (mergedContainer != null && !mergedContainer.spell_ids().isEmpty()) {
            ItemUseExpectation itemUseExpectation = SpellHotbar.expectedUseStack((class_1657)player);
            if (itemUseExpectation != null) {
                onUseKey = new Slot(null, SpellCast.Mode.ITEM_USE, itemUseExpectation.itemStack, useKeyBinding, null);
            }
            List<String> spellIds = mergedContainer.spell_ids();
            List<class_6880.class_6883> spellEntryList = spellIds.stream().map(idString -> {
                class_2960 id = class_2960.method_60654((String)idString);
                return SpellRegistry.from(player.method_37908()).method_55841(id).orElse(null);
            }).filter(Objects::nonNull).toList();
            int keyBindingIndex = 0;
            for (class_6880 class_68802 : spellEntryList) {
                WrappedKeybinding.Unwrapped unwrapped;
                Spell spell = (Spell)class_68802.comp_349();
                if (spell == null) continue;
                WrappedKeybinding keyBinding = null;
                if (keyBindingIndex >= allBindings.size()) continue;
                keyBinding = allBindings.get(keyBindingIndex);
                ++keyBindingIndex;
                if (SpellEngineClient.config.spellHotbarUseKey && onUseKey == null) {
                    keyBinding = useKeyBinding;
                }
                Slot slot = new Slot((class_6880<Spell>)class_68802, SpellCast.Mode.from(spell), null, keyBinding, null);
                if (keyBinding != null && (unwrapped = keyBinding.get(options)) != null) {
                    class_3675.class_306 hotbarKey = ((KeybindingAccessor)unwrapped.keyBinding()).getBoundKey();
                    if (hotbarKey.equals((Object)useKey)) {
                        onUseKey = slot;
                    } else {
                        otherSlots.add(slot);
                    }
                }
                slots.add(slot);
            }
            if (itemUseExpectation != null) {
                if (itemUseExpectation.isMainHand()) {
                    slots.addFirst(onUseKey);
                } else {
                    slots.addLast(onUseKey);
                }
            }
        }
        changed = initialSlotCount != slots.size();
        this.structuredSlots = new StructuredSlots(onUseKey, otherSlots);
        this.slots = slots;
        return changed;
    }

    public void prepare(int itemUseCooldown) {
        this.itemUseCooldown = itemUseCooldown;
        this.handledThisTick = null;
        if (this.lastPressed == null) {
            this.attemptedSpell = null;
        }
        this.updateDebounced();
    }

    @Nullable
    public Handle handle(class_746 player, class_315 options) {
        return this.handle(player, this.slots, options);
    }

    @Nullable
    public Handle handle(class_746 player, @Nullable Slot slot, class_315 options) {
        if (slot == null) {
            return null;
        }
        return this.handle(player, List.of(slot), options);
    }

    @Nullable
    public Handle handle(class_746 player, List<Slot> slots, class_315 options) {
        if (this.handledThisTick != null || player.method_7325()) {
            return null;
        }
        if (Keybindings.bypass_spell_hotbar.method_1434() || SpellEngineClient.config.sneakingByPassSpellHotbar && options.field_1832.method_1434()) {
            return null;
        }
        if (this.itemUseCooldown > 0) {
            return null;
        }
        SpellCasterClient caster = (SpellCasterClient)player;
        SpellCast.Progress casted = caster.getSpellCastProgress();
        class_1799 casterStack = player.method_6047();
        for (Slot slot : slots) {
            WrappedKeybinding.Unwrapped unwrapped;
            if (slot.keybinding == null || (unwrapped = slot.keybinding.get(options)) == null) continue;
            class_304 keyBinding = unwrapped.keyBinding();
            boolean pressed = keyBinding.method_1434();
            Handle handle = Handle.from(slot, keyBinding, unwrapped.vanillaHandle());
            if (pressed) {
                this.lastPressed = handle;
            }
            switch (slot.castMode()) {
                case ITEM_USE: {
                    if (!options.field_1904.method_1434()) break;
                    return null;
                }
                case INSTANT: {
                    if (!pressed) break;
                    SpellCast.Attempt attempt = caster.startSpellCast(casterStack, slot.spell);
                    this.handledThisTick = handle;
                    this.displayAttempt(attempt, slot.spell);
                    return handle;
                }
                case CHARGE: 
                case CHANNEL: {
                    if (casted != null && casted.process().id().equals((Object)((class_5321)slot.spell.method_40230().get()).method_29177())) {
                        boolean needsToBeHeld;
                        boolean bl = needsToBeHeld = SpellHelper.isChanneled((Spell)casted.process().spell().comp_349()) ? SpellEngineClient.config.holdToCastChannelled : SpellEngineClient.config.holdToCastCharged;
                        if (needsToBeHeld) {
                            if (pressed) break;
                            caster.cancelSpellCast();
                            this.handledThisTick = handle;
                            return handle;
                        }
                        if (!pressed || !this.isReleased(keyBinding, UseCase.START)) break;
                        caster.cancelSpellCast();
                        this.debounce(keyBinding, UseCase.STOP);
                        this.handledThisTick = handle;
                        return handle;
                    }
                    if (!pressed || !this.isReleased(keyBinding, UseCase.STOP)) break;
                    SpellCast.Attempt attempt = caster.startSpellCast(casterStack, slot.spell);
                    this.debounce(keyBinding, UseCase.START);
                    this.handledThisTick = handle;
                    this.displayAttempt(attempt, slot.spell);
                    return handle;
                }
            }
            if (!pressed) continue;
            this.handledThisTick = handle;
            return handle;
        }
        this.lastPressed = null;
        return null;
    }

    private void displayAttempt(SpellCast.Attempt attempt, class_6880<Spell> spell) {
        if (Objects.equals(spell, this.attemptedSpell)) {
            return;
        }
        if (attempt.isFail()) {
            HudMessages.INSTANCE.castAttemptError(attempt);
        }
        this.attemptedSpell = spell;
    }

    public void syncItemUseSkill(class_746 player) {
        class_2960 idToSync = null;
        if (!Objects.equals(idToSync, this.lastSyncedSpellId)) {
            ClientPlayNetworking.send((class_8710)new Packets.SpellCastSync(idToSync, 1.0f, 1000));
            this.lastSyncedSpellId = idToSync;
        }
    }

    private boolean isReleased(class_304 keybinding, UseCase use) {
        return this.debounced.get(keybinding) != use;
    }

    private void debounce(class_304 keybinding, UseCase use) {
        this.debounced.put(keybinding, use);
    }

    private void updateDebounced() {
        this.debounced.entrySet().removeIf(entry -> !((class_304)entry.getKey()).method_1434());
    }

    public static ItemUseExpectation expectedUseStack(class_1657 player) {
        for (class_1268 hand : class_1268.values()) {
            class_1799 itemStack = player.method_5998(hand);
            if (itemStack.method_7976() == class_1839.field_8952) continue;
            return new ItemUseExpectation(hand, itemStack);
        }
        return null;
    }

    public boolean isShowingItemUse() {
        return this.structuredSlots.onUseKey != null && this.structuredSlots.onUseKey.itemStack != null;
    }

    public record StructuredSlots(@Nullable Slot onUseKey, List<Slot> other) {
    }

    public record Slot(class_6880<Spell> spell, SpellCast.Mode castMode, @Nullable class_1799 itemStack, @Nullable WrappedKeybinding keybinding, @Nullable class_304 modifier) {
        @Nullable
        public class_304 getKeyBinding(class_315 options) {
            WrappedKeybinding.Unwrapped unwrapped;
            if (this.keybinding != null && (unwrapped = this.keybinding.get(options)) != null) {
                return unwrapped.keyBinding();
            }
            return null;
        }
    }

    public record Handle(class_6880<Spell> spell, class_304 keyBinding, @Nullable WrappedKeybinding.Category category) {
        public static Handle from(Slot slot, class_304 keyBinding, @Nullable WrappedKeybinding.Category category) {
            return new Handle(slot.spell, keyBinding, category);
        }
    }

    public record ItemUseExpectation(class_1268 hand, class_1799 itemStack) {
        public boolean isMainHand() {
            return this.hand == class_1268.field_5808;
        }
    }

    private static enum UseCase {
        START,
        STOP;

    }
}

