/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.data_gen;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_8110;
import net.minecraft.class_8111;
import net.spell_engine.api.datagen.SimpleParticleGenerator;
import net.spell_engine.api.datagen.SimpleSoundGeneratorV2;
import net.spell_engine.api.tags.SpellEngineDamageTypeTags;
import net.spell_engine.fx.SpellEngineParticles;
import net.spell_engine.fx.SpellEngineSounds;
import net.spell_engine.rpg_series.datagen.RPGSeriesDataGen;

public class SpellEngineDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(ParticlesGen::new);
        pack.addProvider(SoundGen::new);
        pack.addProvider(DamageTypeTagGen::new);
        pack.addProvider(RPGSeriesDataGen.BaselineTagGenerator::new);
    }

    public static class DamageTypeTagGen
    extends FabricTagProvider<class_8110> {
        public DamageTypeTagGen(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, class_7924.field_42534, registriesFuture);
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            this.getOrCreateTagBuilder(SpellEngineDamageTypeTags.EVADABLE).addOptionalTag(class_8103.field_42247.comp_327()).add(class_8111.field_42320).add(class_8111.field_42348).add(class_8111.field_42360).add(class_8111.field_42319);
        }
    }

    public static class SoundGen
    extends SimpleSoundGeneratorV2 {
        public SoundGen(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        @Override
        public void generateSounds(SimpleSoundGeneratorV2.Builder builder) {
            builder.entries.add(new SimpleSoundGeneratorV2.Entry("spell_engine", SpellEngineSounds.entries.stream().map(entry -> SimpleSoundGeneratorV2.SoundEntry.withVariants(entry.id().method_12832(), entry.variants())).toList()));
        }
    }

    public static class ParticlesGen
    extends SimpleParticleGenerator {
        public ParticlesGen(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        @Override
        public void generateSimpleParticles(SimpleParticleGenerator.Builder builder) {
            int index;
            int frameCount;
            ArrayList<String> textures;
            for (SpellEngineParticles.MagicParticleFamily.Variant variant : SpellEngineParticles.MAGIC_FAMILY_VARIANTS.get()) {
                textures = new ArrayList<String>();
                frameCount = variant.frameCount();
                Object texture = "";
                switch (variant.shape()) {
                    case SPELL: {
                        texture = "minecraft:spell";
                        break;
                    }
                    case IMPACT: {
                        texture = "spell_engine:magic/impact_" + variant.familyName();
                        break;
                    }
                    case SPARK: {
                        texture = "minecraft:generic_0";
                        break;
                    }
                    case STRIPE: {
                        texture = "spell_engine:magic/vertical_stripe";
                    }
                }
                if (frameCount > 1) {
                    for (int i = 0; i < frameCount; ++i) {
                        int reversedIndex = frameCount - 1 - i;
                        textures.add((String)texture + "_" + reversedIndex);
                    }
                } else {
                    textures.add((String)texture);
                }
                if (textures.isEmpty()) {
                    // empty if block
                }
                builder.add(variant.id(), new SimpleParticleGenerator.ParticleData(textures));
            }
            for (SpellEngineParticles.Entry entry : SpellEngineParticles.simpleEntries()) {
                textures = new ArrayList();
                frameCount = entry.texture().frames();
                if (frameCount > 1) {
                    for (int i = 0; i < entry.texture().frames(); ++i) {
                        index = entry.texture().reverseOrder() ? frameCount - 1 - i : i;
                        textures.add(entry.texture().id().toString() + "_" + index);
                    }
                } else {
                    textures.add(entry.texture().id().toString());
                }
                builder.add(entry.id(), new SimpleParticleGenerator.ParticleData(textures));
            }
            for (SpellEngineParticles.TemplateEntry templateEntry : SpellEngineParticles.templateEntries()) {
                textures = new ArrayList();
                frameCount = templateEntry.texture().frames();
                if (frameCount > 1) {
                    for (int i = 0; i < templateEntry.texture().frames(); ++i) {
                        index = templateEntry.texture().reverseOrder() ? frameCount - 1 - i : i;
                        textures.add(templateEntry.texture().id().toString() + "_" + index);
                    }
                } else {
                    textures.add(templateEntry.texture().id().toString());
                }
                builder.add(templateEntry.id(), new SimpleParticleGenerator.ParticleData(textures));
            }
        }
    }
}

