/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals.container;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_8710;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.item.set.EquipmentSet;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.network.Packets;
import org.jetbrains.annotations.Nullable;

public class SpellContainerSource {
    public static final List<Entry> sources = new ArrayList<Entry>();
    public static final List<ItemEntry> itemSources = new ArrayList<ItemEntry>();
    public static final ItemEntry MAIN_HAND = SpellContainerSource.itemEntry("main_hand", (player, sourceName) -> List.of(player.method_6047()));
    public static final ItemEntry OFF_HAND = SpellContainerSource.itemEntry("off_hand", (player, sourceName) -> List.of(player.method_6079()));
    public static final ItemEntry ARMOR = SpellContainerSource.itemEntry("armor", (player, sourceName) -> List.of((class_1799)player.method_31548().field_7548.get(0), (class_1799)player.method_31548().field_7548.get(1), (class_1799)player.method_31548().field_7548.get(2), (class_1799)player.method_31548().field_7548.get(3)));

    public static SpellContainer activeContainerOf(class_1657 player) {
        return ((Owner)player).getSpellContainers().activeContainer;
    }

    public static List<class_6880<Spell>> activeSpellsOf(class_1657 player) {
        return ((Owner)player).getSpellContainers().actives;
    }

    public static List<class_6880<Spell>> passiveSpellsOf(class_1657 player) {
        return ((Owner)player).getSpellContainers().passives;
    }

    public static Result getSpellsOf(class_1657 player) {
        return ((Owner)player).getSpellContainers();
    }

    public static void setDirty(class_1657 player, Entry source) {
        SpellContainerSource.setDirty(player, source.name());
    }

    public static void setDirty(class_1657 player, ItemEntry source) {
        SpellContainerSource.setDirty(player, source.name());
    }

    public static void setDirty(class_1657 player, String source) {
        ((Owner)player).spellContainerCache().remove(source);
    }

    public static void setDirtyServerSide(class_1657 player) {
        ((Owner)player).markServerSideSpellContainersDirty();
    }

    public static void syncServerSideContainers(class_1657 player) {
        if (!player.method_37908().field_9236) {
            LinkedHashMap<String, SpellContainer> containers = ((Owner)player).serverSideSpellContainers();
            Packets.SpellContainerSync packet = new Packets.SpellContainerSync(containers);
            ServerPlayNetworking.send((class_3222)((class_3222)player), (class_8710)packet);
            SpellContainerSource.setDirty(player, MAIN_HAND);
        }
    }

    private static Entry entry(String name, Source source) {
        return SpellContainerSource.entry(name, source, null);
    }

    private static Entry entry(String name, Source source, @Nullable DirtyChecker dirtyChecker) {
        Entry newEntry = new Entry(name, source, dirtyChecker);
        sources.add(newEntry);
        return newEntry;
    }

    private static ItemEntry itemEntry(String name, ItemStackSource source) {
        ItemEntry newEntry = ItemEntry.of(name, source);
        SpellContainerSource.addItemSource(newEntry);
        return newEntry;
    }

    public static void addSource(Entry entry) {
        sources.add(entry);
    }

    public static void addSource(Entry entry, @Nullable String after) {
        boolean added = false;
        if (after != null) {
            int index = -1;
            for (int i = 0; i < sources.size(); ++i) {
                if (!sources.get(i).name().equals(after)) continue;
                index = i;
                break;
            }
            if (index != -1) {
                sources.add(index + 1, entry);
                added = true;
            }
        }
        if (!added) {
            sources.add(entry);
        }
    }

    public static void addItemSource(ItemEntry entry) {
        SpellContainerSource.addItemSource(entry, null);
    }

    public static void addItemSource(ItemEntry entry, @Nullable String after) {
        itemSources.add(entry);
        SpellContainerSource.addSource(new Entry(entry.name(), entry.source(), entry.checker()), after);
    }

    public static void init() {
    }

    public static void update(class_1657 player) {
        Owner owner = (Owner)player;
        ArrayList<SourcedContainer> allContainers = new ArrayList<SourcedContainer>();
        boolean updated = false;
        if (SpellEngineMod.config.spell_container_caching) {
            for (Entry entry : sources) {
                List<SourcedContainer> resolvedContainers = owner.spellContainerCache().get(entry.name());
                if (resolvedContainers != null) {
                    allContainers.addAll(resolvedContainers);
                    continue;
                }
                List<SourcedContainer> freshContainers = entry.source().getSpellContainers(player, entry.name());
                allContainers.addAll(freshContainers);
                owner.spellContainerCache().put(entry.name(), freshContainers);
                updated = true;
            }
        } else {
            for (Entry entry : sources) {
                List<SourcedContainer> freshContainers = entry.source().getSpellContainers(player, entry.name());
                allContainers.addAll(freshContainers);
            }
            updated = true;
        }
        for (Map.Entry entry : owner.serverSideSpellContainers().entrySet()) {
            allContainers.add(new SourcedContainer((String)entry.getKey(), null, (SpellContainer)entry.getValue()));
        }
        if (updated) {
            owner.spellModifierCache().clear();
            SpellContainerSource.updateEquipmentSets(player, allContainers);
            class_1799 heldItemStack = player.method_6047();
            SpellContainer spellContainer = SpellContainerHelper.containerFromItemStack(heldItemStack);
            SpellContainer activeContainer = SpellContainer.EMPTY;
            List<class_6880<Spell>> activeSpells = List.of();
            if (spellContainer != null && spellContainer.is_proxy()) {
                MergeResult merged = SpellContainerSource.mergedContainerSources(allContainers, spellContainer.is_proxy(), spellContainer.content(), Spell.Type.ACTIVE, player.method_37908());
                activeContainer = merged.container();
                activeSpells = merged.spells();
            }
            List<class_6880<Spell>> passiveSpells = SpellContainerSource.mergedContainerSources(allContainers, null, Spell.Type.PASSIVE, player.method_37908());
            class_2378<Spell> registry = SpellRegistry.from(player.method_37908());
            LinkedHashSet<class_6880.class_6883> modifiers = new LinkedHashSet<class_6880.class_6883>();
            for (SourcedContainer container : allContainers) {
                SpellContainer spellContainer2 = container.container();
                for (String idString : spellContainer2.spell_ids()) {
                    class_2960 id = class_2960.method_60654((String)idString);
                    class_6880.class_6883 spell = registry.method_55841(id).orElse(null);
                    if (spell == null || ((Spell)spell.comp_349()).type != Spell.Type.MODIFIER) continue;
                    modifiers.add(spell);
                }
            }
            ((Owner)player).setSpellContainers(new Result(activeContainer, activeSpells, passiveSpells, modifiers.stream().toList(), allContainers));
        }
    }

    public static List<class_6880<Spell>> mergedContainerSources(List<SourcedContainer> sources, @Nullable SpellContainer.ContentType contentType, Spell.Type type, class_1937 world) {
        if (sources.isEmpty()) {
            return List.of();
        }
        ArrayList<class_6880<Spell>> spells = new ArrayList<class_6880<Spell>>();
        class_2378<Spell> registry = SpellRegistry.from(world);
        for (SourcedContainer source : sources) {
            SpellContainer spellContainer = source.container();
            if (type == Spell.Type.ACTIVE && source.name.equals("off_hand") && !SpellEngineMod.config.spell_container_from_offhand_any && !spellContainer.slotMatches(class_1304.field_6171.method_15434()) || !spellContainer.contentMatches(contentType)) continue;
            for (String idString : spellContainer.spell_ids()) {
                class_2960 id = class_2960.method_60654((String)idString);
                class_6880.class_6883 spell = registry.method_55841(id).orElse(null);
                if (spell == null || ((Spell)spell.comp_349()).type != type) continue;
                spells.add((class_6880<Spell>)spell);
            }
        }
        HashSet<class_6880<Spell>> toRemove = new HashSet<class_6880<Spell>>();
        for (class_6880 class_68802 : spells) {
            Spell spell = (Spell)class_68802.comp_349();
            String tag = spell.group;
            if (tag == null) continue;
            for (class_6880<Spell> other : spells) {
                class_2960 otherId;
                class_2960 spellId = ((class_5321)class_68802.method_40230().get()).method_29177();
                if (spellId.equals((Object)(otherId = ((class_5321)other.method_40230().get()).method_29177())) || !tag.equals(((Spell)other.comp_349()).group)) continue;
                if (((Spell)class_68802.comp_349()).tier == ((Spell)other.comp_349()).tier && ((Spell)class_68802.comp_349()).sub_tier > ((Spell)other.comp_349()).sub_tier) {
                    toRemove.add(other);
                }
                if (((Spell)class_68802.comp_349()).tier <= ((Spell)other.comp_349()).tier) continue;
                toRemove.add(other);
            }
        }
        spells.removeAll(toRemove);
        return spells;
    }

    public static MergeResult mergedContainerSources(List<SourcedContainer> sources, boolean proxy, @Nullable SpellContainer.ContentType contentType, Spell.Type type, class_1937 world) {
        if (sources.isEmpty()) {
            return MergeResult.EMPTY;
        }
        List<class_6880<Spell>> spells = SpellContainerSource.mergedContainerSources(sources, contentType, type, world);
        LinkedHashSet<String> spellIds = new LinkedHashSet<String>();
        for (class_6880<Spell> spell : spells) {
            spellIds.add(((class_5321)spell.method_40230().get()).method_29177().toString());
        }
        SpellContainer.ContentType finalContentType = contentType != null ? contentType : SpellContainer.ContentType.MAGIC;
        SpellContainer container = new SpellContainer(finalContentType, proxy, null, 0, new ArrayList<String>(spellIds));
        return new MergeResult(container, spells);
    }

    @Nullable
    public static SourcedContainer getFirstSourceOfSpell(class_2960 spellId, class_1657 player) {
        Result result = ((Owner)player).getSpellContainers();
        for (SourcedContainer source : result.sources()) {
            if (!SpellContainerSource.contains(source.container(), spellId)) continue;
            return source;
        }
        return null;
    }

    private static boolean contains(SpellContainer container, class_2960 spellId) {
        return container != null && container.spell_ids().contains(spellId.toString());
    }

    private static void updateEquipmentSets(class_1657 player, ArrayList<SourcedContainer> allContainers) {
        ArrayList<EquipmentSet.SourcedItemStack> equipmentStacks = new ArrayList<EquipmentSet.SourcedItemStack>();
        for (ItemEntry entry : itemSources) {
            String sourceName = entry.name();
            List<class_1799> stacks = entry.source().getSpellContainerItemStacks(player, sourceName);
            stacks.stream().map(stack -> new EquipmentSet.SourcedItemStack((class_1799)stack, sourceName)).forEach(equipmentStacks::add);
        }
        List<EquipmentSet.Result> equipmentSets = EquipmentSet.collectFrom(equipmentStacks, player.method_37908());
        ((EquipmentSet.Owner)player).setActiveEquipmentSets(equipmentSets);
        allContainers.addAll(SpellContainerSource.sourcedContainersFrom(equipmentSets));
    }

    private static List<SourcedContainer> sourcedContainersFrom(List<EquipmentSet.Result> results) {
        ArrayList<SourcedContainer> spellContainers = new ArrayList<SourcedContainer>();
        for (EquipmentSet.Result result : results) {
            EquipmentSet.Definition set = (EquipmentSet.Definition)result.set().comp_349();
            for (EquipmentSet.Bonus bonus : set.bonuses()) {
                if (result.items().size() < bonus.requiredPieceCount() || bonus.spells() == null) continue;
                spellContainers.add(new SourcedContainer(set.name(), result.items().getFirst(), bonus.spells()));
            }
        }
        return spellContainers;
    }

    public static interface Owner {
        public Map<String, List<SourcedContainer>> spellContainerCache();

        public Map<class_2960, List<Spell.Modifier>> spellModifierCache();

        public LinkedHashMap<String, SpellContainer> serverSideSpellContainers();

        public void markServerSideSpellContainersDirty();

        public void setSpellContainers(Result var1);

        public Result getSpellContainers();
    }

    public record Result(SpellContainer activeContainer, List<class_6880<Spell>> actives, List<class_6880<Spell>> passives, List<class_6880<Spell>> modifiers, List<SourcedContainer> sources) {
        public static final Result EMPTY = new Result(SpellContainer.EMPTY, List.of(), List.of(), List.of(), List.of());
    }

    public record Entry(String name, Source source, @Nullable DirtyChecker checker) {
    }

    public record ItemEntry(String name, ItemStackSource source, @Nullable DirtyChecker checker) {
        public static ItemEntry of(String name, ItemStackSource source, @Nullable DirtyChecker dirtyChecker) {
            return new ItemEntry(name, source, dirtyChecker);
        }

        public static ItemEntry of(String name, ItemStackSource source) {
            return ItemEntry.of(name, source, player -> source.getSpellContainerItemStacks(player, name));
        }
    }

    public static interface Source {
        public List<SourcedContainer> getSpellContainers(class_1657 var1, String var2);
    }

    public static interface DirtyChecker {
        public Object current(class_1657 var1);
    }

    public static interface ItemStackSource
    extends Source {
        public List<class_1799> getSpellContainerItemStacks(class_1657 var1, String var2);

        @Override
        default public List<SourcedContainer> getSpellContainers(class_1657 player, String name) {
            List<class_1799> itemStacks = this.getSpellContainerItemStacks(player, name);
            ArrayList<SourcedContainer> sources = new ArrayList<SourcedContainer>();
            for (class_1799 itemStack : itemStacks) {
                SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
                if (container == null || !container.isValid()) continue;
                sources.add(new SourcedContainer(name, itemStack, container));
            }
            return sources;
        }
    }

    public record SourcedContainer(String name, @Nullable class_1799 itemStack, SpellContainer container) {
    }

    public record MergeResult(SpellContainer container, List<class_6880<Spell>> spells) {
        public static final MergeResult EMPTY = new MergeResult(SpellContainer.EMPTY, List.of());
    }
}

