/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.network;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.config.ServerConfig;
import net.spell_engine.internals.SpellCooldownManager;
import net.spell_engine.internals.casting.SpellCast;
import org.jetbrains.annotations.Nullable;

public class Packets {

    public record Ack(String code) implements class_8710
    {
        public static class_2960 ID = class_2960.method_60655((String)"spell_engine", (String)"ack");
        public static final class_8710.class_9154<Ack> PACKET_ID = new class_8710.class_9154(ID);
        public static final class_9139<class_2540, Ack> CODEC = class_9139.method_56438(Ack::write, Ack::read);

        public void write(class_2540 buffer) {
            buffer.method_10814(this.code);
        }

        public static Ack read(class_2540 buffer) {
            String code = buffer.method_19772();
            return new Ack(code);
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }

    public record SpellRegistrySync(List<String> chunks) implements class_8710
    {
        public static class_2960 ID = class_2960.method_60655((String)"spell_engine", (String)"spell_registry_sync");
        public static final class_8710.class_9154<SpellRegistrySync> PACKET_ID = new class_8710.class_9154(ID);
        public static final class_9139<class_2540, SpellRegistrySync> CODEC = class_9139.method_56438(SpellRegistrySync::write, SpellRegistrySync::read);

        private void write(class_2540 buffer) {
            buffer.method_53002(this.chunks.size());
            for (String chunk : this.chunks) {
                buffer.method_10814(chunk);
            }
        }

        private static SpellRegistrySync read(class_2540 buffer) {
            int chunkCount = buffer.readInt();
            ArrayList<String> chunks = new ArrayList<String>();
            for (int i = 0; i < chunkCount; ++i) {
                chunks.add(buffer.method_19772());
            }
            return new SpellRegistrySync(chunks);
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }

    public record ConfigSync(ServerConfig config) implements class_8710
    {
        public static class_2960 ID = class_2960.method_60655((String)"spell_engine", (String)"config_sync");
        public static final class_8710.class_9154<ConfigSync> PACKET_ID = new class_8710.class_9154(ID);
        public static final class_9139<class_2540, ConfigSync> CODEC = class_9139.method_56438(ConfigSync::write, ConfigSync::read);
        private static final Gson gson = new Gson();

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }

        public void write(class_2540 buffer) {
            String json = gson.toJson((Object)this.config);
            buffer.method_10814(json);
        }

        public static ConfigSync read(class_2540 buffer) {
            Gson gson = new Gson();
            String json = buffer.method_19772();
            ServerConfig config = (ServerConfig)gson.fromJson(json, ServerConfig.class);
            return new ConfigSync(config);
        }
    }

    public record SpellContainerSync(LinkedHashMap<String, SpellContainer> containers) implements class_8710
    {
        public static class_2960 ID = class_2960.method_60655((String)"spell_engine", (String)"spell_container_sync");
        public static final class_8710.class_9154<SpellContainerSync> PACKET_ID = new class_8710.class_9154(ID);
        public static final class_9139<class_2540, SpellContainerSync> CODEC = class_9139.method_56438(SpellContainerSync::write, SpellContainerSync::read);
        private static final Gson gson = new Gson();

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }

        public void write(class_2540 buffer) {
            buffer.method_53002(this.containers.size());
            for (Map.Entry<String, SpellContainer> entry : this.containers.entrySet()) {
                buffer.method_10814(entry.getKey());
                String json = gson.toJson((Object)entry.getValue());
                buffer.method_10814(json);
            }
        }

        public static SpellContainerSync read(class_2540 buffer) {
            int size = buffer.readInt();
            LinkedHashMap<String, SpellContainer> containers = new LinkedHashMap<String, SpellContainer>();
            for (int i = 0; i < size; ++i) {
                String key = buffer.method_19772();
                String json = buffer.method_19772();
                SpellContainer container = (SpellContainer)gson.fromJson(json, SpellContainer.class);
                containers.put(key, container);
            }
            return new SpellContainerSync(containers);
        }
    }

    public record ParticleBatches(SourceType sourceType, float countMultiplier, List<Spawn> spawns) implements class_8710
    {
        public static class_2960 ID = class_2960.method_60655((String)"spell_engine", (String)"particle_effects");
        public static final class_8710.class_9154<ParticleBatches> PACKET_ID = new class_8710.class_9154(ID);
        public static final class_9139<class_9129, ParticleBatches> CODEC = class_9139.method_56438(ParticleBatches::write, ParticleBatches::read);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }

        public void write(class_9129 buffer) {
            buffer.method_53002(this.sourceType.ordinal());
            buffer.method_53002(this.spawns.size());
            for (Spawn spawn : this.spawns) {
                buffer.method_53002(spawn.sourceEntityId);
                buffer.method_52941(spawn.yaw);
                buffer.method_52941(spawn.pitch);
                buffer.method_52940(spawn.sourceLocation.field_1352);
                buffer.method_52940(spawn.sourceLocation.field_1351);
                buffer.method_52940(spawn.sourceLocation.field_1350);
                ParticleBatches.write(spawn.batch, (class_2540)buffer, this.countMultiplier);
            }
        }

        private static void write(ParticleBatch batch, class_2540 buffer, float countMultiplier) {
            buffer.method_10814(batch.particle_id);
            buffer.method_53002(batch.shape.ordinal());
            buffer.method_53002(batch.origin.ordinal());
            buffer.method_53002(batch.rotation != null ? batch.rotation.ordinal() : -1);
            buffer.method_52941(batch.roll);
            buffer.method_52941(batch.roll_offset);
            buffer.method_52941(batch.count * countMultiplier);
            buffer.method_52941(batch.min_speed);
            buffer.method_52941(batch.max_speed);
            buffer.method_52941(batch.angle);
            buffer.method_52941(batch.extent);
            buffer.method_52941(batch.pre_spawn_travel);
            buffer.method_52964(batch.invert);
            buffer.method_52974(batch.color_rgba);
            buffer.method_52941(batch.scale);
            buffer.method_52964(batch.follow_entity);
            buffer.method_52941(batch.max_age);
        }

        private static ParticleBatch readBatch(class_9129 buffer) {
            return new ParticleBatch(buffer.method_19772(), ParticleBatch.Shape.values()[buffer.readInt()], ParticleBatch.Origin.values()[buffer.readInt()], ParticleBatch.Rotation.from(buffer.readInt()), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readBoolean(), buffer.readLong(), buffer.readFloat(), buffer.readBoolean(), buffer.readFloat());
        }

        public static ParticleBatches read(class_9129 buffer) {
            SourceType sourceType = SourceType.values()[buffer.readInt()];
            int spawnCount = buffer.readInt();
            ArrayList<Spawn> spawns = new ArrayList<Spawn>();
            for (int i = 0; i < spawnCount; ++i) {
                spawns.add(new Spawn(buffer.readInt(), buffer.readFloat(), buffer.readFloat(), new class_243(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()), ParticleBatches.readBatch(buffer)));
            }
            return new ParticleBatches(sourceType, 1.0f, spawns);
        }

        public static enum SourceType {
            ENTITY,
            COORDINATE;

        }

        public record Spawn(int sourceEntityId, float yaw, float pitch, class_243 sourceLocation, ParticleBatch batch) {
        }
    }

    public record SpellAnimation(int playerId, SpellCast.Animation type, String name, float speed) implements class_8710
    {
        public static class_2960 ID = class_2960.method_60655((String)"spell_engine", (String)"spell_animation");
        public static final class_8710.class_9154<SpellAnimation> PACKET_ID = new class_8710.class_9154(ID);
        public static final class_9139<class_9129, SpellAnimation> CODEC = class_9139.method_56438(SpellAnimation::write, SpellAnimation::read);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }

        public void write(class_9129 buffer) {
            buffer.method_53002(this.playerId);
            buffer.method_53002(this.type.ordinal());
            buffer.method_10814(this.name);
            buffer.method_52941(this.speed);
        }

        public static SpellAnimation read(class_9129 buffer) {
            int playerId = buffer.readInt();
            SpellCast.Animation type = SpellCast.Animation.values()[buffer.readInt()];
            String name = buffer.method_19772();
            float speed = buffer.readFloat();
            return new SpellAnimation(playerId, type, name, speed);
        }
    }

    public record SpellCooldownSync(int baseTick, Map<class_2960, SpellCooldownManager.Entry> cooldowns) implements class_8710
    {
        public static class_2960 ID = class_2960.method_60655((String)"spell_engine", (String)"cooldown_sync");
        public static final class_8710.class_9154<SpellCooldownSync> PACKET_ID = new class_8710.class_9154(ID);
        public static final class_9139<class_9129, SpellCooldownSync> CODEC = class_9139.method_56438(SpellCooldownSync::write, SpellCooldownSync::read);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }

        public void write(class_9129 buffer) {
            buffer.method_53002(this.baseTick);
            buffer.method_53002(this.cooldowns.size());
            for (Map.Entry<class_2960, SpellCooldownManager.Entry> entry : this.cooldowns.entrySet()) {
                buffer.method_10814(entry.getKey().toString());
                buffer.method_53002(entry.getValue().startTick());
                buffer.method_53002(entry.getValue().endTick());
            }
        }

        public static SpellCooldownSync read(class_9129 buffer) {
            int baseTick = buffer.readInt();
            int size = buffer.readInt();
            HashMap<class_2960, SpellCooldownManager.Entry> cooldowns = new HashMap<class_2960, SpellCooldownManager.Entry>();
            for (int i = 0; i < size; ++i) {
                class_2960 spellId = class_2960.method_60654((String)buffer.method_19772());
                int startTick = buffer.readInt();
                int endTick = buffer.readInt();
                cooldowns.put(spellId, new SpellCooldownManager.Entry(startTick, endTick));
            }
            return new SpellCooldownSync(baseTick, cooldowns);
        }
    }

    public record SpellCooldown(class_2960 spellId, int duration) implements class_8710
    {
        public static class_2960 ID = class_2960.method_60655((String)"spell_engine", (String)"spell_cooldown");
        public static final class_8710.class_9154<SpellCooldown> PACKET_ID = new class_8710.class_9154(ID);
        public static final class_9139<class_9129, SpellCooldown> CODEC = class_9139.method_56438(SpellCooldown::write, SpellCooldown::read);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }

        public void write(class_9129 buffer) {
            buffer.method_10814(this.spellId.toString());
            buffer.method_53002(this.duration);
        }

        public static SpellCooldown read(class_9129 buffer) {
            class_2960 spellId = class_2960.method_60654((String)buffer.method_19772());
            int duration = buffer.readInt();
            return new SpellCooldown(spellId, duration);
        }
    }

    public record SpellRequest(SpellCast.Action action, class_2960 spellId, float progress, int[] targets, @Nullable class_243 location) implements class_8710
    {
        public static class_2960 ID = class_2960.method_60655((String)"spell_engine", (String)"release_request");
        public static final class_8710.class_9154<SpellRequest> PACKET_ID = new class_8710.class_9154(ID);
        public static final class_9139<class_9129, SpellRequest> CODEC = class_9139.method_56438(SpellRequest::write, SpellRequest::read);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }

        public void write(class_9129 buffer) {
            buffer.method_10817((Enum)this.action);
            buffer.method_10814(this.spellId.toString());
            buffer.method_52941(this.progress);
            buffer.method_10806(this.targets);
            if (this.location != null) {
                buffer.method_52964(true);
                buffer.method_52940(this.location.field_1352);
                buffer.method_52940(this.location.field_1351);
                buffer.method_52940(this.location.field_1350);
            } else {
                buffer.method_52964(false);
            }
        }

        public static SpellRequest read(class_9129 buffer) {
            SpellCast.Action action = (SpellCast.Action)buffer.method_10818(SpellCast.Action.class);
            class_2960 spellId = class_2960.method_60654((String)buffer.method_19772());
            float progress = buffer.readFloat();
            int[] targets = buffer.method_10787();
            class_243 location = null;
            boolean hasLocation = buffer.readBoolean();
            if (hasLocation) {
                double x = buffer.readDouble();
                double y = buffer.readDouble();
                double z = buffer.readDouble();
                location = new class_243(x, y, z);
            }
            return new SpellRequest(action, spellId, progress, targets, location);
        }
    }

    public record SpellCastSync(class_2960 spellId, float speed, int length) implements class_8710
    {
        public static class_2960 ID = class_2960.method_60655((String)"spell_engine", (String)"cast_sync");
        public static final class_8710.class_9154<SpellCastSync> PACKET_ID = new class_8710.class_9154(ID);
        public static final class_9139<class_9129, SpellCastSync> CODEC = class_9139.method_56438(SpellCastSync::write, SpellCastSync::read);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }

        public void write(class_9129 buffer) {
            if (this.spellId == null) {
                buffer.method_10814("");
            } else {
                buffer.method_10814(this.spellId.toString());
            }
            buffer.method_52941(this.speed);
            buffer.method_53002(this.length);
        }

        public static SpellCastSync read(class_9129 buffer) {
            String string = buffer.method_19772();
            class_2960 spellId = null;
            if (!string.isEmpty()) {
                spellId = class_2960.method_60654((String)string);
            }
            float speed = buffer.readFloat();
            int length = buffer.readInt();
            return new SpellCastSync(spellId, speed, length);
        }
    }
}

