/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.network;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_8605;
import net.minecraft.class_8610;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.config.ServerConfig;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.casting.SpellCastSyncHelper;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.internals.container.SpellAssignments;
import net.spell_engine.internals.container.SpellContainerSource;
import net.spell_engine.internals.target.SpellTarget;
import net.spell_engine.network.Packets;

public class ServerNetwork {
    public static void init() {
        PayloadTypeRegistry.configurationS2C().register(Packets.ConfigSync.PACKET_ID, Packets.ConfigSync.CODEC);
        PayloadTypeRegistry.configurationS2C().register(Packets.SpellRegistrySync.PACKET_ID, Packets.SpellRegistrySync.CODEC);
        PayloadTypeRegistry.configurationC2S().register(Packets.Ack.PACKET_ID, Packets.Ack.CODEC);
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend((class_8610)handler, (class_2960)Packets.ConfigSync.ID)) {
                handler.addTask((class_8605)new ConfigurationTask(SpellEngineMod.config));
            } else {
                handler.method_52396((class_2561)class_2561.method_43470((String)"Network configuration task not supported: spell_engine:config"));
            }
        });
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend((class_8610)handler, (class_2960)Packets.SpellRegistrySync.ID)) {
                if (SpellAssignments.encoded.isEmpty()) {
                    throw new AssertionError((Object)"Spell registry is empty!");
                }
                handler.addTask((class_8605)new SpellRegistrySyncTask(SpellAssignments.encoded));
            } else {
                handler.method_52396((class_2561)class_2561.method_43470((String)"Network configuration task not supported: spell_engine:spell_registry"));
            }
        });
        ServerConfigurationNetworking.registerGlobalReceiver(Packets.Ack.PACKET_ID, (packet, context) -> {
            if (packet.code().equals("spell_engine:config")) {
                context.networkHandler().completeTask(ConfigurationTask.KEY);
            }
            if (packet.code().equals("spell_engine:spell_registry")) {
                context.networkHandler().completeTask(SpellRegistrySyncTask.KEY);
            }
        });
        PayloadTypeRegistry.playC2S().register(Packets.SpellCastSync.PACKET_ID, Packets.SpellCastSync.CODEC);
        PayloadTypeRegistry.playC2S().register(Packets.SpellRequest.PACKET_ID, Packets.SpellRequest.CODEC);
        PayloadTypeRegistry.playS2C().register(Packets.SpellCooldown.PACKET_ID, Packets.SpellCooldown.CODEC);
        PayloadTypeRegistry.playS2C().register(Packets.SpellCooldownSync.PACKET_ID, Packets.SpellCooldownSync.CODEC);
        PayloadTypeRegistry.playS2C().register(Packets.ParticleBatches.PACKET_ID, Packets.ParticleBatches.CODEC);
        PayloadTypeRegistry.playS2C().register(Packets.SpellAnimation.PACKET_ID, Packets.SpellAnimation.CODEC);
        PayloadTypeRegistry.playS2C().register(Packets.SpellContainerSync.PACKET_ID, Packets.SpellContainerSync.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(Packets.SpellCastSync.PACKET_ID, (packet, context) -> {
            MinecraftServer server = context.server();
            class_3222 player = context.player();
            class_3218 world = (class_3218)Iterables.tryFind((Iterable)server.method_3738(), element -> element == player.method_37908()).orNull();
            if (world == null || world.field_9236) {
                return;
            }
            world.method_8503().method_40000(() -> {
                if (packet.spellId() == null) {
                    SpellCastSyncHelper.clearCasting((class_1657)player);
                } else {
                    SpellHelper.startCasting((class_1657)player, packet.spellId(), packet.speed(), packet.length());
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(Packets.SpellRequest.PACKET_ID, (packet, context) -> {
            MinecraftServer server = context.server();
            class_3222 player = context.player();
            class_3218 world = (class_3218)Iterables.tryFind((Iterable)server.method_3738(), element -> element == player.method_37908()).orNull();
            if (world == null || world.field_9236) {
                return;
            }
            world.method_8503().method_40000(() -> {
                Optional spellEntry = SpellRegistry.from((class_1937)world).method_55841(packet.spellId());
                if (spellEntry.isEmpty()) {
                    return;
                }
                ArrayList<class_1297> targets = new ArrayList<class_1297>();
                for (int targetId : packet.targets()) {
                    class_1297 entity = world.method_31424(targetId);
                    if (entity != null) {
                        targets.add(entity);
                        continue;
                    }
                    System.err.println("Spell Engine: Trying to perform spell " + packet.spellId().toString() + " Entity not found: " + targetId);
                }
                SpellTarget.SearchResult target = new SpellTarget.SearchResult(targets, packet.location());
                SpellHelper.performSpell((class_1937)world, (class_1657)player, (class_6880<Spell>)((class_6880)spellEntry.get()), target, packet.action(), packet.progress());
            });
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            ((SpellCasterEntity)handler.method_32311()).getCooldownManager().pushSync();
            SpellContainerSource.syncServerSideContainers((class_1657)player);
        });
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, target) -> {
            ((SpellCasterEntity)player).getCooldownManager().pushSync();
            SpellContainerSource.syncServerSideContainers((class_1657)player);
        });
    }

    public record ConfigurationTask(ServerConfig config) implements class_8605
    {
        public static final String name = "spell_engine:config";
        public static final class_8605.class_8606 KEY = new class_8605.class_8606("spell_engine:config");

        public class_8605.class_8606 method_52375() {
            return KEY;
        }

        public void method_52376(Consumer<class_2596<?>> sender) {
            Packets.ConfigSync packet = new Packets.ConfigSync(this.config);
            sender.accept(ServerConfigurationNetworking.createS2CPacket((class_8710)packet));
        }
    }

    public record SpellRegistrySyncTask(List<String> encodedChunks) implements class_8605
    {
        public static final String name = "spell_engine:spell_registry";
        public static final class_8605.class_8606 KEY = new class_8605.class_8606("spell_engine:spell_registry");

        public class_8605.class_8606 method_52375() {
            return KEY;
        }

        public void method_52376(Consumer<class_2596<?>> sender) {
            Packets.SpellRegistrySync packet = new Packets.SpellRegistrySync(this.encodedChunks);
            sender.accept(ServerConfigurationNetworking.createS2CPacket((class_8710)packet));
        }
    }
}

