/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.rpg_series;

import java.util.HashMap;
import java.util.Set;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.item.v1.EnchantmentEvents;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1792;
import net.minecraft.class_1893;
import net.minecraft.class_5321;
import net.spell_engine.api.item.weapon.StaffItem;
import net.spell_engine.rpg_series.config.Defaults;
import net.spell_engine.rpg_series.loot.LootConfig;
import net.spell_engine.rpg_series.loot.LootHelper;
import net.tinyconfig.ConfigManager;

public class RPGSeriesCore {
    public static final String NAMESPACE = "rpg_series";
    public static ConfigManager<LootConfig> lootEquipmentConfig = new ConfigManager("loot_equipment_v2", (Object)Defaults.itemLootConfig).builder().setDirectory("rpg_series").sanitize(true).constrain(LootConfig::constrainValues).build();
    public static ConfigManager<LootConfig> lootScrollsConfig = new ConfigManager("loot_scrolls_v1", (Object)Defaults.scrollLootConfig).builder().setDirectory("rpg_series").sanitize(true).constrain(LootConfig::constrainValues).build();

    public static void init() {
        lootEquipmentConfig.refresh();
        lootScrollsConfig.refresh();
        LootHelper.TAG_CACHE.refresh();
        LootTableEvents.MODIFY.register((key, tableBuilder, source, registries) -> {
            LootHelper.configureV2(registries, key.method_29177(), tableBuilder, (LootConfig)RPGSeriesCore.lootEquipmentConfig.value, new HashMap<String, class_1792>());
            LootHelper.configureV2(registries, key.method_29177(), tableBuilder, (LootConfig)RPGSeriesCore.lootScrollsConfig.value, new HashMap<String, class_1792>());
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> LootHelper.updateTagCache((LootConfig)RPGSeriesCore.lootEquipmentConfig.value));
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, serverResourceManager, success) -> LootHelper.updateTagCache((LootConfig)RPGSeriesCore.lootEquipmentConfig.value));
        Set<class_5321> staffEnchantments = Set.of(class_1893.field_9121, class_1893.field_9124, class_1893.field_9110);
        EnchantmentEvents.ALLOW_ENCHANTING.register((enchantment, target, enchantingContext) -> {
            if (target.method_7909() instanceof StaffItem && staffEnchantments.contains(enchantment.method_40230().get())) {
                return TriState.TRUE;
            }
            return TriState.DEFAULT;
        });
    }
}

