/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.annotations.Action;
import me.fzzyhmstrs.fzzy_config.annotations.RequiresAction;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedDouble;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.item.interfaces.Weapon;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;
import net.rosemarythyme.simplymore.registry.ModItemsRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.util.Styles;

public class BladeOfTheGrotesqueItem
extends SimplyMoreUniqueSwordItem {
    int skillCooldown;
    int skillLength;

    public BladeOfTheGrotesqueItem(class_1832 toolMaterial, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, attackDamage, attackSpeed, Weapon.SwordTypes.SWORD, settings);
        this.skillCooldown = BladeOfTheGrotesqueItem.effect.blade_of_the_grotesque.cooldown;
        this.skillLength = BladeOfTheGrotesqueItem.effect.blade_of_the_grotesque.selfStunTime;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!user.method_37908().method_8608()) {
            user.method_6092(new class_1293(ModEffectsRegistry.getReference(ModEffectsRegistry.SOLIDIFIED), this.skillLength));
            user.method_37908().method_8396(null, user.method_24515(), class_3417.field_17710, user.method_5634(), 2.0f, 1.0f);
            ((class_3218)user.method_37908()).method_14199((class_2394)class_2398.field_22247, user.method_23317(), user.method_23320() - 0.25, user.method_23321(), 1000, 0.2, 0.5, 0.2, 1.0);
            user.method_7357().method_7906((class_1792)this, this.skillCooldown);
        }
        return super.method_7836(world, user, hand);
    }

    public static void causeStun(class_1309 player) {
        double boxRange = BladeOfTheGrotesqueItem.effect.blade_of_the_grotesque.auraRange;
        class_238 box = new class_238(player.method_23317() + boxRange, player.method_23318() + boxRange, player.method_23321() + boxRange, player.method_23317() - boxRange, player.method_23318() - boxRange, player.method_23321() - boxRange);
        List livingEntities = player.method_37908().method_18467(class_1309.class, box);
        for (class_1309 livingEntity : livingEntities) {
            if (livingEntity == player || SimplyMoreHelperMethods.checkFriendlyFire(livingEntity, player)) continue;
            livingEntity.method_37222(new class_1293(ModEffectsRegistry.getReference(ModEffectsRegistry.STUNNED), BladeOfTheGrotesqueItem.effect.blade_of_the_grotesque.auraStunTime), (class_1297)player);
        }
    }

    public void setSpeed(class_1799 stack) {
        class_9285 modifiers = (class_9285)stack.method_57824(class_9334.field_49636);
        if (modifiers == null) {
            modifiers = class_9285.method_57480().method_57486();
        }
        stack.method_57379(class_9334.field_49636, (Object)modifiers.method_57484(class_5134.field_23719, new class_1322(class_2960.method_60655((String)"simplymore", (String)"grotesque_slowdown"), (double)BladeOfTheGrotesqueItem.effect.blade_of_the_grotesque.selfSlow, class_1322.class_1323.field_6328), class_9274.field_49217));
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (world.method_8510() % 20L == 0L) {
            this.setSpeed(stack);
        }
        if (world.method_8510() % 40L == 0L && entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            if (selected) {
                ((class_3218)player.method_37908()).method_14199((class_2394)class_2398.field_11241, player.method_23317(), player.method_23318(), player.method_23321(), 200, 2.0, 2.0, 2.0, (double)0.1f);
                double boxRange = BladeOfTheGrotesqueItem.effect.blade_of_the_grotesque.auraRange;
                class_238 box = new class_238(player.method_23317() + boxRange, player.method_23318() + boxRange, player.method_23321() + boxRange, player.method_23317() - boxRange, player.method_23318() - boxRange, player.method_23321() - boxRange);
                List livingEntities = entity.method_37908().method_18467(class_1309.class, box);
                for (class_1309 livingEntity : livingEntities) {
                    if (livingEntity == entity || SimplyMoreHelperMethods.checkFriendlyFire(livingEntity, (class_1309)entity)) continue;
                    if (livingEntity.method_6059(ModEffectsRegistry.getReference(ModEffectsRegistry.GROTESQUE_WARD))) {
                        int amplifier = livingEntity.method_6112(ModEffectsRegistry.getReference(ModEffectsRegistry.GROTESQUE_WARD)).method_5578();
                        amplifier = Math.min(amplifier + 1, BladeOfTheGrotesqueItem.effect.blade_of_the_grotesque.maxAuraWard);
                        livingEntity.method_6092(new class_1293(ModEffectsRegistry.getReference(ModEffectsRegistry.GROTESQUE_WARD), 50, amplifier));
                        continue;
                    }
                    livingEntity.method_6092(new class_1293(ModEffectsRegistry.getReference(ModEffectsRegistry.GROTESQUE_WARD), 50, 0));
                }
            }
        }
        SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, class_2398.field_11251, class_2398.field_11251, class_2398.field_22247);
        super.method_7888(stack, world, entity, slot, selected);
    }

    public void method_7851(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> tooltip, class_1836 type) {
        class_2583 textStyle = Styles.TEXT;
        class_2583 abilityStyle = Styles.ABILITY;
        class_2583 rightClickStyle = Styles.RIGHT_CLICK;
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.blade_of_the_grotesque.tooltip1").method_10862(abilityStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.blade_of_the_grotesque.tooltip2").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.blade_of_the_grotesque.tooltip3").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.blade_of_the_grotesque.tooltip4").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.onrightclick").method_10862(rightClickStyle));
        tooltip.add((class_2561)class_2561.method_43469((String)"item.simplymore.blade_of_the_grotesque.tooltip5", (Object[])new Object[]{SimplyMoreHelperMethods.translateTicks(this.skillLength)}).method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.blade_of_the_grotesque.tooltip6").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.blade_of_the_grotesque.tooltip7").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.blade_of_the_grotesque.tooltip8").method_10862(textStyle));
        super.method_7851(itemStack, tooltipContext, tooltip, type);
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0)
        public int selfStunTime = 50;
        @ValidatedInt.Restrict(min=0)
        public int auraStunTime = 50;
        @ValidatedDouble.Restrict(min=0.0)
        public double auraRange = 4.0;
        @ValidatedInt.Restrict(min=0)
        @RequiresAction(action=Action.RESTART)
        public int selfStunnedArmorBuff = 10;
        @ValidatedInt.Restrict(min=0)
        @RequiresAction(action=Action.RESTART)
        public int attackerStunnedArmorBuff = 10;
        @ValidatedInt.Restrict(min=0)
        public int cooldown = 500;
        @RequiresAction(action=Action.RESTART)
        public float selfSlow = -0.02f;
        @ValidatedInt.Restrict(min=0)
        public int maxAuraWard = 5;

        public EffectSettings() {
            super((Supplier)new ItemStackTooltipAppender(new Supplier[]{ModItemsRegistry.BLADE_OF_THE_GROTESQUE}));
        }
    }
}

