/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import net.rosemarythyme.simplymore.config.ConfigWrapper;
import net.rosemarythyme.simplymore.config.WeaponAttributesConfig;
import net.rosemarythyme.simplymore.entity.JetAreaEffectCloudEntity;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.item.components.CounterComponent;
import net.rosemarythyme.simplymore.item.interfaces.Weapon;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;
import net.rosemarythyme.simplymore.registry.ModItemsRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.util.Styles;

public class BrassturnItem
extends SimplyMoreUniqueSwordItem {
    WeaponAttributesConfig attributes = ConfigWrapper.attributes;

    public BrassturnItem(class_1832 toolMaterial, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, attackDamage, attackSpeed, Weapon.SwordTypes.SWORD, settings);
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (attacker.method_37908().method_8608()) {
            return super.method_7873(stack, target, attacker);
        }
        int oxidisation = BrassturnItem.getOxidisation(stack) + 1;
        BrassturnItem.saveOxidisation(stack, oxidisation);
        if (SimplyMoreHelperMethods.chance(attacker, BrassturnItem.effect.brassturn.chance)) {
            attacker.method_37908().method_43128(null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), class_3417.field_14986, class_3419.field_15248, 0.5f, 2.0f);
            attacker.method_37908().method_8649((class_1297)new JetAreaEffectCloudEntity(target.method_37908(), target.method_23317(), target.method_23318(), target.method_23321(), attacker));
        }
        return super.method_7873(stack, target, attacker);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (BrassturnItem.getOxidisation(itemStack) <= 0) {
            return class_1271.method_22431((Object)itemStack);
        }
        if (itemStack.method_7919() >= itemStack.method_7936() - 1) {
            return class_1271.method_22431((Object)itemStack);
        }
        user.method_6019(hand);
        return class_1271.method_22428((Object)itemStack);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        class_1937 class_19372;
        if (BrassturnItem.getOxidisation(stack) <= 0) {
            user.method_6075();
        }
        if (remainingUseTicks % BrassturnItem.effect.brassturn.scrapeTime == 0 && (class_19372 = user.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            int oxidisation = BrassturnItem.getOxidisation(stack) - 1;
            BrassturnItem.saveOxidisation(stack, oxidisation);
            if (SimplyMoreHelperMethods.chance(user, BrassturnItem.effect.brassturn.sparkChance)) {
                serverWorld.method_14199((class_2394)class_2398.field_29642, user.method_23317(), user.method_23318(), user.method_23321(), 20, 0.5, 1.0, 0.5, 0.2);
                serverWorld.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14891, class_3419.field_15248, 0.5f, 2.0f);
                int boxSize = 3;
                class_238 box = new class_238(user.method_23317() - (double)boxSize, user.method_23318() - 2.0, user.method_23321() - (double)boxSize, user.method_23317() + (double)boxSize, user.method_23318() + (double)boxSize, user.method_23321() + (double)boxSize);
                List livingEntities = user.method_37908().method_18467(class_1309.class, box);
                for (class_1309 livingEntity : livingEntities) {
                    if (livingEntity == user || SimplyMoreHelperMethods.checkFriendlyFire(livingEntity, user)) continue;
                    livingEntity.method_6092(new class_1293(ModEffectsRegistry.getReference(ModEffectsRegistry.STUNNED), BrassturnItem.effect.brassturn.stunTime, 0));
                }
            } else {
                serverWorld.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_29541, class_3419.field_15248, 1.0f, 1.0f);
            }
        }
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return 999999;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public static int getOxidisation(class_1799 stack) {
        CounterComponent oxidisation = SimplyMoreHelperMethods.getCounterComponent(stack);
        if (oxidisation == null) {
            return 16;
        }
        return oxidisation.value();
    }

    public static void saveOxidisation(class_1799 stack, int oxidisation) {
        SimplyMoreHelperMethods.setCounterComponent(stack, new CounterComponent(0, 16, 0).set(oxidisation));
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, class_2398.field_22247);
        this.applyAttackSpeed(stack);
        super.method_7888(stack, world, entity, slot, selected);
    }

    public void applyAttackSpeed(class_1799 stack) {
        float oxidisationAmount = (float)BrassturnItem.getOxidisation(stack) / 16.0f;
        double minimumModifier = (double)(4.0f + this.attributes.uniqueWeaponsSwingSpeed.brassturn_attack_speed) - 0.6;
        double attackSpeedModifier = minimumModifier * (double)(-oxidisationAmount);
        class_9285 modifiers = (class_9285)stack.method_57824(class_9334.field_49636);
        if (modifiers == null) {
            modifiers = class_9285.method_57480().method_57486();
        }
        stack.method_57379(class_9334.field_49636, (Object)modifiers.method_57484(class_5134.field_23723, new class_1322(class_2960.method_60655((String)"simplymore", (String)"oxidisation"), attackSpeedModifier, class_1322.class_1323.field_6328), class_9274.field_49217));
    }

    public void method_7851(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> tooltip, class_1836 type) {
        class_2583 textStyle = Styles.TEXT;
        class_2583 abilityStyle = Styles.ABILITY;
        class_2583 rightClickStyle = Styles.RIGHT_CLICK;
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.brassturn.tooltip1").method_10862(abilityStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.brassturn.tooltip2").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.brassturn.tooltip3").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.brassturn.tooltip4").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43470((String)" "));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.onrightclickheld").method_10862(rightClickStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.brassturn.tooltip5").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.brassturn.tooltip6").method_10862(textStyle));
        super.method_7851(itemStack, tooltipContext, tooltip, type);
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedFloat.Restrict(min=0.0f, max=1.0f)
        public float chance = 0.15f;
        @ValidatedInt.Restrict(min=0)
        public int stunTime = 15;
        @ValidatedInt.Restrict(min=1)
        public int scrapeTime = 5;
        @ValidatedFloat.Restrict(min=0.0f, max=1.0f)
        public float sparkChance = 0.25f;

        public EffectSettings() {
            super((Supplier)new ItemStackTooltipAppender(new Supplier[]{ModItemsRegistry.BRASSTURN}));
        }
    }
}

