/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.item.interfaces.CooldownOnUnselected;
import net.rosemarythyme.simplymore.item.interfaces.Weapon;
import net.rosemarythyme.simplymore.registry.ModItemsRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.util.Styles;

public class CindergorgeItem
extends SimplyMoreUniqueSwordItem
implements CooldownOnUnselected {
    int skillCooldown;

    public CindergorgeItem(class_1832 toolMaterial, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, attackDamage, attackSpeed, Weapon.SwordTypes.SWORD, settings);
        this.skillCooldown = CindergorgeItem.effect.cindergorge.cooldown;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (itemStack.method_7919() >= itemStack.method_7936() - 1) {
            return class_1271.method_22431((Object)itemStack);
        }
        user.method_6019(hand);
        this.startUsing(itemStack, hand);
        return class_1271.method_22428((Object)itemStack);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        int ticksUntilUseEnd = this.method_7881(stack, user) - remainingUseTicks;
        if (remainingUseTicks == 1) {
            user.method_6075();
        }
        float originalYaw = user.method_36454();
        float turnAngle = 54.0f * (1.0f - (float)remainingUseTicks / (float)CindergorgeItem.effect.cindergorge.maxUseTime);
        user.method_36456(originalYaw + turnAngle);
        if (user instanceof class_3222) {
            double yawAngle = Math.toRadians(user.method_36454());
            double cosYaw = Math.cos(yawAngle);
            double sinYaw = Math.sin(yawAngle);
            for (int distanceMultiplier = 1; distanceMultiplier < CindergorgeItem.effect.cindergorge.range; ++distanceMultiplier) {
                double offsetX = (double)(-distanceMultiplier) * sinYaw;
                double offsetZ = (double)distanceMultiplier * cosYaw;
                double spawnX = user.method_23317() + 1.2 * offsetX;
                double spawnZ = user.method_23321() + 1.2 * offsetZ;
                ((class_3218)world).method_14199((class_2394)class_2398.field_11240, spawnX, user.method_23320(), spawnZ, 20, 0.2, 0.2, 0.2, 0.1);
                world.method_43128(null, spawnX, user.method_23320(), spawnZ, class_3417.field_15013, class_3419.field_15248, 0.1f, 1.0f);
                for (class_1309 entity : user.method_37908().method_18467(class_1309.class, new class_238(spawnX - 0.75, user.method_23320() - 0.75, spawnZ - 0.75, spawnX + 0.75, user.method_23320() + 0.75, spawnZ + 0.75))) {
                    if (SimplyMoreHelperMethods.checkFriendlyFire(entity, user) || entity == user || entity.method_5655()) continue;
                    entity.method_5643(user.method_48923().method_48794(), CindergorgeItem.effect.cindergorge.fireDamage);
                    entity.method_5639(3.0f);
                }
            }
        }
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        float relativeTime = 1.0f - (float)remainingUseTicks / (float)CindergorgeItem.effect.cindergorge.maxUseTime;
        float cooldown = (float)this.skillCooldown * relativeTime;
        cooldown = Math.max(cooldown, 120.0f);
        user.method_6092(new class_1293(class_1294.field_5916, (int)(150.0f * relativeTime)));
        super.method_7840(stack, world, user, remainingUseTicks);
        ((class_1657)user).method_7357().method_7906((class_1792)this, (int)cooldown);
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return CindergorgeItem.effect.cindergorge.maxUseTime;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8951;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            this.detectCooldown(player, selected, stack, this.skillCooldown, false);
        }
        SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, class_2398.field_11239);
        super.method_7888(stack, world, entity, slot, selected);
    }

    public void method_7851(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> tooltip, class_1836 type) {
        class_2583 textStyle = Styles.TEXT;
        class_2583 abilityStyle = Styles.ABILITY;
        class_2583 rightClickStyle = Styles.RIGHT_CLICK;
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.cindergorge.tooltip1").method_10862(abilityStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.cindergorge.tooltip2").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.cindergorge.tooltip3").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.cindergorge.tooltip4").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43470((String)" "));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.onrightclickheld").method_10862(rightClickStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.cindergorge.tooltip5").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.cindergorge.tooltip6").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.cindergorge.tooltip7").method_10862(textStyle));
        super.method_7851(itemStack, tooltipContext, tooltip, type);
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedFloat.Restrict(min=0.0f, max=1.0f)
        public float chance = 0.4f;
        @ValidatedFloat.Restrict(min=0.0f)
        public float thornsDamage = 3.0f;
        @ValidatedFloat.Restrict(min=0.0f)
        public float fireThornsDamage = 6.0f;
        @ValidatedInt.Restrict(min=0)
        public int maxUseTime = 200;
        @ValidatedInt.Restrict(min=0)
        public int range = 5;
        @ValidatedFloat.Restrict(min=0.0f)
        public float fireDamage = 5.0f;
        @ValidatedInt.Restrict(min=0)
        public int cooldown = 600;

        public EffectSettings() {
            super((Supplier)new ItemStackTooltipAppender(new Supplier[]{ModItemsRegistry.CINDERGORGE}));
        }
    }
}

