/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.class_8046;
import net.rosemarythyme.simplymore.entity.GhostFallingBlockEntity;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.item.components.CounterComponent;
import net.rosemarythyme.simplymore.item.interfaces.Weapon;
import net.rosemarythyme.simplymore.registry.ModItemsRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.util.Styles;
import org.joml.Vector3d;

public class ExedrillItem
extends SimplyMoreUniqueSwordItem {
    int skillCooldown;
    static int maxHeat = ExedrillItem.effect.exedrill.maxHeat;
    static final int minHeat = 0;

    @Override
    public CounterComponent getDefaultComponent() {
        return new CounterComponent(0, maxHeat);
    }

    public ExedrillItem(class_1832 toolMaterial, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, attackDamage, attackSpeed, Weapon.SwordTypes.LANCE, settings);
        this.skillCooldown = ExedrillItem.effect.exedrill.cooldown;
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        float chance;
        if (attacker.method_37908().method_8608()) {
            return super.method_7873(stack, target, attacker);
        }
        if (ExedrillItem.getHeat(stack) >= maxHeat && attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            ExedrillItem.setHeat(stack, 0);
            List<class_1309> targets = ExedrillItem.tremorEffectHitbox(8, attacker.method_19538(), (class_3218)attacker.method_37908(), player);
            attacker.method_37908().method_60511(null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), (class_6880)class_3417.field_15152, class_3419.field_15248, 0.5f, 0.5f);
            attacker.method_37908().method_60511(null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), (class_6880)class_3417.field_15152, class_3419.field_15248, 0.5f, 1.0f);
            ((class_3218)attacker.method_37908()).method_14199((class_2394)class_2398.field_11236, attacker.method_23317(), attacker.method_23320(), attacker.method_23321(), 4, 0.25, 0.25, 0.25, 0.0);
            targets.forEach(livingEntity -> {
                if (attacker.method_5854() == livingEntity) {
                    return;
                }
                livingEntity.method_5643(player.method_48923().method_48819((class_1297)player, (class_1297)player), ExedrillItem.effect.exedrill.explosionDamage);
                double deltaX = livingEntity.method_23317() - player.method_23317();
                double deltaZ = livingEntity.method_23321() - player.method_23321();
                double distance = Math.hypot(deltaX, deltaZ);
                float knockbackStrength = ExedrillItem.effect.exedrill.earthquakeStrength;
                double normalizedDeltaX = deltaX / distance;
                double normalizedDeltaZ = deltaZ / distance;
                if (distance == 0.0) {
                    return;
                }
                livingEntity.method_5762(normalizedDeltaX * (double)knockbackStrength, (double)0.4f, normalizedDeltaZ * (double)knockbackStrength);
            });
            return super.method_7873(stack, target, attacker);
        }
        ExedrillItem.setHeat(stack, ExedrillItem.getHeat(stack) + ExedrillItem.effect.exedrill.hitHeatAmount);
        float f = chance = attacker.method_5854() instanceof class_1309 ? ExedrillItem.effect.exedrill.chanceMounted : ExedrillItem.effect.exedrill.chance;
        if (SimplyMoreHelperMethods.chance(attacker, chance) && attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            List<class_1309> targets = ExedrillItem.tremorEffectHitbox(5, attacker.method_19538(), (class_3218)attacker.method_37908(), player);
            ExedrillItem.setHeat(stack, ExedrillItem.getHeat(stack) + ExedrillItem.effect.exedrill.trembleHeatAmount);
            attacker.method_37908().method_60511(null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), (class_6880)class_3417.field_15152, class_3419.field_15248, 0.5f, 0.5f);
            int effectTime = ExedrillItem.effect.exedrill.trembleEffectTime;
            targets.forEach(entity -> {
                if (attacker.method_5854() == entity) {
                    return;
                }
                entity.method_6092(new class_1293(class_1294.field_5909, effectTime, 1));
                entity.method_6092(new class_1293(class_1294.field_5901, effectTime));
                entity.method_5762(0.0, 0.2, 0.0);
            });
        }
        return super.method_7873(stack, target, attacker);
    }

    public static int getHeat(class_1799 stack) {
        int heat = SimplyMoreHelperMethods.getCounterComponent(stack).value();
        heat = Math.max(0, heat);
        heat = Math.min(maxHeat, heat);
        return heat;
    }

    public static void setHeat(class_1799 stack, int value) {
        SimplyMoreHelperMethods.setCounterComponent(stack, SimplyMoreHelperMethods.getCounterComponent(stack).set(value));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (user.method_37908().method_8608()) {
            return super.method_7836(world, user, hand);
        }
        for (int i = 0; i < ExedrillItem.effect.exedrill.rocksAmount; ++i) {
            Vector3d normalisedVector = SimplyMoreHelperMethods.getNormalised2dVector(user.method_36454() + (float)user.method_59922().method_39332(-40, 40));
            class_243 rockVelocity = new class_243(normalisedVector.x() * (double)ExedrillItem.effect.exedrill.rockSpeed, (double)0.45f, normalisedVector.z() * (double)ExedrillItem.effect.exedrill.rockSpeed);
            GhostFallingBlockEntity rock = new GhostFallingBlockEntity(world, user.method_23317(), user.method_23318(), user.method_23321(), rockVelocity, (class_1309)user);
            class_2487 nbt = new class_2487();
            nbt.method_10566("BlockState", (class_2520)class_2512.method_10686((class_2680)class_2246.field_10340.method_9564()));
            rock.method_5749(nbt);
            user.method_37908().method_8649((class_1297)rock);
            user.method_37908().method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_26942, class_3419.field_15248, 0.5f, 0.5f);
        }
        user.method_7357().method_7906((class_1792)this, this.skillCooldown);
        return super.method_7836(world, user, hand);
    }

    public static List<class_1309> tremorEffectHitbox(int range, class_243 pos, class_3218 world, class_1657 player) {
        world.method_14199((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10566.method_9564()), pos.method_10216(), pos.method_10214() + 0.5, pos.method_10215(), (int)(Math.pow(range, 2.0) * 30.0), (double)range, 0.5, (double)range, 1.0);
        class_238 box = new class_238(player.method_23317() - (double)range, player.method_23318() - 2.0, player.method_23321() - (double)range, player.method_23317() + (double)range, player.method_23318() + (double)range, player.method_23321() + (double)range);
        return player.method_37908().method_18467(class_1309.class, box).stream().filter(livingEntity -> {
            class_8046 pet;
            return livingEntity != player && !SimplyMoreHelperMethods.checkFriendlyFire(livingEntity, (class_1309)player) && (!(livingEntity instanceof class_8046) || (pet = (class_8046)livingEntity).method_24921() != player);
        }).toList();
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, class_2398.field_22247);
        super.method_7888(stack, world, entity, slot, selected);
    }

    public void method_7851(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> tooltip, class_1836 type) {
        class_2583 textStyle = Styles.TEXT;
        class_2583 abilityStyle = Styles.ABILITY;
        class_2583 rightClickStyle = Styles.RIGHT_CLICK;
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.exedrill.tooltip1").method_10862(abilityStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.exedrill.tooltip2").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.exedrill.tooltip3").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.exedrill.tooltip4").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.exedrill.tooltip5").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.exedrill.tooltip6").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.exedrill.tooltip7").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.onrightclick").method_10862(rightClickStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.exedrill.tooltip8").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.exedrill.tooltip9").method_10862(textStyle));
        super.method_7851(itemStack, tooltipContext, tooltip, type);
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0)
        public int cooldown = 250;
        @ValidatedFloat.Restrict(min=0.0f, max=1.0f)
        public float chance = 0.15f;
        @ValidatedInt.Restrict(min=0)
        public int trembleEffectTime = 80;
        @ValidatedFloat.Restrict(min=0.0f, max=1.0f)
        public float chanceMounted = 0.3f;
        @ValidatedInt.Restrict(min=0)
        public int trembleHeatAmount = 6;
        @ValidatedInt.Restrict(min=0)
        public int hitHeatAmount = 1;
        @ValidatedInt.Restrict(min=0)
        public int maxHeat = 25;
        @ValidatedFloat.Restrict(min=0.0f)
        public float explosionDamage = 12.0f;
        @ValidatedFloat.Restrict(min=0.0f)
        public float rockDamage = 6.0f;
        @ValidatedFloat.Restrict(min=0.0f)
        public float rockSpeed = 0.4f;
        @ValidatedInt.Restrict(min=0)
        public int rockStunTime = 14;
        @ValidatedInt.Restrict(min=0)
        public int rocksAmount = 5;
        @ValidatedInt.Restrict(min=0)
        public float earthquakeStrength = 1.8f;

        public EffectSettings() {
            super((Supplier)new ItemStackTooltipAppender(new Supplier[]{ModItemsRegistry.EXEDRILL}));
        }
    }
}

