/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.item.interfaces.Weapon;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;
import net.rosemarythyme.simplymore.registry.ModItemsRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.Styles;

public class GrandfrostItem
extends SimplyMoreUniqueSwordItem {
    int skillCooldown;

    public GrandfrostItem(class_1832 toolMaterial, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, attackDamage, attackSpeed, Weapon.SwordTypes.GRANDSWORD, settings);
        this.skillCooldown = GrandfrostItem.effect.grandfrost.cooldown;
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (!attacker.method_37908().method_8608() && (target.method_6039() || SimplyMoreHelperMethods.chance(attacker, GrandfrostItem.effect.grandfrost.chance))) {
            target.method_37222(new class_1293(ModEffectsRegistry.getReference(ModEffectsRegistry.CHILL), GrandfrostItem.effect.grandfrost.chillTime, 0), (class_1297)attacker);
        }
        return super.method_7873(stack, target, attacker);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (user.method_37908().method_8608()) {
            return super.method_7836(world, user, hand);
        }
        int boxSize = GrandfrostItem.effect.grandfrost.blizzardRange;
        class_238 box = new class_238(user.method_23317() - (double)boxSize, user.method_23318() - 2.0, user.method_23321() - (double)boxSize, user.method_23317() + (double)boxSize, user.method_23318() + (double)boxSize, user.method_23321() + (double)boxSize);
        List livingEntities = user.method_37908().method_18467(class_1309.class, box);
        if (livingEntities.size() > 1) {
            boolean isNonTeammateNearby = false;
            for (class_1309 livingEntity : livingEntities) {
                double deltaZ;
                if (livingEntity == user || SimplyMoreHelperMethods.checkFriendlyFire(livingEntity, (class_1309)user)) continue;
                isNonTeammateNearby = true;
                class_243 userPosition = user.method_19538();
                class_243 entityPosition = livingEntity.method_19538();
                double deltaX = entityPosition.method_10216() - userPosition.method_10216();
                double distance = Math.hypot(deltaX, deltaZ = entityPosition.method_10215() - userPosition.method_10215());
                if (distance == 0.0) {
                    return super.method_7836(world, user, hand);
                }
                float knockbackStrength = GrandfrostItem.effect.grandfrost.blizzardStrength;
                double normalizedDeltaX = deltaX / distance;
                double normalizedDeltaZ = deltaZ / distance;
                livingEntity.method_6092(new class_1293(ModEffectsRegistry.getReference(ModEffectsRegistry.CHILL), GrandfrostItem.effect.grandfrost.blizzardEffectTime, 0));
                livingEntity.method_6092(new class_1293(class_1294.field_5909, GrandfrostItem.effect.grandfrost.blizzardEffectTime, 3));
                livingEntity.method_18800(normalizedDeltaX * (double)knockbackStrength, 0.4, normalizedDeltaZ * (double)knockbackStrength);
                livingEntity.field_6037 = true;
            }
            if (isNonTeammateNearby) {
                user.method_7357().method_7906((class_1792)this, this.skillCooldown);
                ((class_3218)user.method_37908()).method_14199((class_2394)class_2398.field_28013, user.method_23317(), user.method_23318() + 3.0, user.method_23321(), 1000, 3.0, 0.0, 3.0, 0.25);
                user.method_37908().method_8396(null, user.method_24515(), (class_3414)SoundRegistry.ELEMENTAL_SWORD_ICE_ATTACK_03.get(), user.method_5634(), 2.0f, 0.3f);
            }
        }
        return super.method_7836(world, user, hand);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, class_2398.field_11230, class_2398.field_11230, class_2398.field_28013);
        super.method_7888(stack, world, entity, slot, selected);
    }

    public void method_7851(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> tooltip, class_1836 type) {
        class_2583 textStyle = Styles.TEXT;
        class_2583 abilityStyle = Styles.ABILITY;
        class_2583 rightClickStyle = Styles.RIGHT_CLICK;
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.grandfrost.tooltip1").method_10862(abilityStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.grandfrost.tooltip2").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.grandfrost.tooltip3").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.onrightclick").method_10862(rightClickStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.grandfrost.tooltip4").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.grandfrost.tooltip5").method_10862(textStyle));
        super.method_7851(itemStack, tooltipContext, tooltip, type);
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedFloat.Restrict(min=0.0f, max=1.0f)
        public float chance = 0.25f;
        @ValidatedInt.Restrict(min=0)
        public int chillTime = 140;
        @ValidatedInt.Restrict(min=0)
        public int blizzardRange = 5;
        @ValidatedFloat.Restrict(min=0.0f)
        public float blizzardStrength = 3.5f;
        @ValidatedInt.Restrict(min=0)
        public int blizzardEffectTime = 200;
        @ValidatedInt.Restrict(min=0)
        public int cooldown = 500;

        public EffectSettings() {
            super((Supplier)new ItemStackTooltipAppender(new Supplier[]{ModItemsRegistry.GRANDFROST}));
        }
    }
}

