/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.item.interfaces.Weapon;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;
import net.rosemarythyme.simplymore.registry.ModItemsRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.Styles;

public class LustrousMoxieItem
extends SimplyMoreUniqueSwordItem {
    int skillCooldown;

    public LustrousMoxieItem(class_1832 toolMaterial, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, attackDamage, attackSpeed, Weapon.SwordTypes.SWORD, settings);
        this.skillCooldown = LustrousMoxieItem.effect.lustrous_moxie.cooldown;
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (!attacker.method_37908().method_8608()) {
            class_1293 radiantMarkEffect = target.method_6112(ModEffectsRegistry.getReference(ModEffectsRegistry.RADIANT_MARK));
            if (target.method_6059(ModEffectsRegistry.getReference(ModEffectsRegistry.RADIANT_MARK)) && radiantMarkEffect != null) {
                target.method_5643(attacker.method_48923().method_48831(), (float)(radiantMarkEffect.method_5578() + 1));
            }
            if (SimplyMoreHelperMethods.chance(attacker, LustrousMoxieItem.effect.lustrous_moxie.chance)) {
                if (target.method_6059(ModEffectsRegistry.getReference(ModEffectsRegistry.RADIANT_MARK)) && radiantMarkEffect != null) {
                    int amplifier = radiantMarkEffect.method_5578() + 1;
                    int duration = 240 - amplifier * 40;
                    target.method_37222(new class_1293(ModEffectsRegistry.getReference(ModEffectsRegistry.RADIANT_MARK), duration, amplifier), (class_1297)attacker);
                } else {
                    target.method_37222(new class_1293(ModEffectsRegistry.getReference(ModEffectsRegistry.RADIANT_MARK), 200, 0), (class_1297)attacker);
                }
            }
        }
        return super.method_7873(stack, target, attacker);
    }

    public void attack(class_1657 user) {
        if (user.method_37908().method_8608()) {
            return;
        }
        class_1309 target = this.locateRadiantMarkedTarget(user);
        if (target != null) {
            this.damageAndKnockbackAndTeleportToRadiantMarkedTarget(target, user);
            this.damageAndKnockbackNearbyNonRadiantMarkedEntities(target, user);
            user.method_6092(new class_1293(ModEffectsRegistry.getReference(ModEffectsRegistry.STUNNED_MOXIE), LustrousMoxieItem.effect.lustrous_moxie.stunTime, 0));
            user.method_37908().method_45447(null, user.method_24515(), (class_3414)SoundRegistry.ELEMENTAL_SWORD_ICE_ATTACK_01.get(), class_3419.field_15248);
            user.method_7357().method_7906((class_1792)this, this.skillCooldown);
        }
    }

    private class_1309 locateRadiantMarkedTarget(class_1657 user) {
        int boxRange = LustrousMoxieItem.effect.lustrous_moxie.range;
        class_238 box = new class_238(user.method_23317() - (double)boxRange, user.method_23318() - (double)boxRange, user.method_23321() - (double)boxRange, user.method_23317() + (double)boxRange, user.method_23318() + (double)boxRange, user.method_23321() + (double)boxRange);
        List potentiallyMarkedLivingEntities = user.method_37908().method_18467(class_1309.class, box);
        class_1309 markedEntity = potentiallyMarkedLivingEntities.stream().filter(livingEntity -> livingEntity.method_6059(ModEffectsRegistry.getReference(ModEffectsRegistry.RADIANT_MARK))).findAny().orElse(null);
        if (markedEntity == null || markedEntity == user || SimplyMoreHelperMethods.checkFriendlyFire(markedEntity, (class_1309)user)) {
            return null;
        }
        return markedEntity;
    }

    private void damageAndKnockbackAndTeleportToRadiantMarkedTarget(class_1309 targetEntity, class_1657 user) {
        if (targetEntity == user.method_6052()) {
            user.method_6082(targetEntity.method_23317(), targetEntity.method_23318(), targetEntity.method_23321(), false);
            ((class_3218)user.method_37908()).method_14199((class_2394)class_2398.field_29643, user.method_23317(), user.method_23318() + 2.0, user.method_23321(), 500, 3.0, 3.0, 3.0, 0.0);
            targetEntity.method_6016(ModEffectsRegistry.getReference(ModEffectsRegistry.RADIANT_MARK));
            this.knockbackAndDamageEntity(targetEntity, user, LustrousMoxieItem.effect.lustrous_moxie.targetDamage);
        }
    }

    private void damageAndKnockbackNearbyNonRadiantMarkedEntities(class_1309 targetEntity, class_1657 user) {
        int boxRange = LustrousMoxieItem.effect.lustrous_moxie.aoe;
        class_238 box = new class_238(user.method_23317() - (double)boxRange, user.method_23318() - (double)boxRange, user.method_23321() - (double)boxRange, user.method_23317() + (double)boxRange, user.method_23318() + (double)boxRange, user.method_23321() + (double)boxRange);
        List nearbyLivingEntities = user.method_37908().method_18467(class_1309.class, box);
        nearbyLivingEntities.remove(targetEntity);
        for (class_1309 livingEntity : nearbyLivingEntities) {
            this.knockbackAndDamageEntity(livingEntity, user, LustrousMoxieItem.effect.lustrous_moxie.aoeDamage);
        }
    }

    private void knockbackAndDamageEntity(class_1309 targetEntity, class_1657 user, float damage) {
        if (targetEntity == user || SimplyMoreHelperMethods.checkFriendlyFire(targetEntity, (class_1309)user)) {
            return;
        }
        targetEntity.method_5643(user.method_48923().method_48802(user), damage);
        class_243 userPosition = user.method_19538();
        class_243 entityPosition = targetEntity.method_19538();
        double deltaX = entityPosition.method_10216() - userPosition.method_10216();
        double deltaZ = entityPosition.method_10215() - userPosition.method_10215();
        double distance = Math.hypot(deltaX, deltaZ);
        if (distance == 0.0) {
            return;
        }
        double normalizedDeltaX = deltaX / distance;
        double normalizedDeltaZ = deltaZ / distance;
        targetEntity.method_18800(normalizedDeltaX * (double)LustrousMoxieItem.effect.lustrous_moxie.knockbackStrength, 0.2, normalizedDeltaZ * (double)LustrousMoxieItem.effect.lustrous_moxie.knockbackStrength);
        targetEntity.field_6037 = true;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        user.method_6019(hand);
        return itemStack.method_7919() >= itemStack.method_7936() - 1 ? class_1271.method_22431((Object)itemStack) : class_1271.method_22428((Object)itemStack);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (!user.method_37908().field_9236 && user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            if (remainingUseTicks == 1) {
                this.attack(player);
            }
        }
        super.method_7852(world, user, stack, remainingUseTicks);
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return 15;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8951;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, class_2398.field_29643);
        super.method_7888(stack, world, entity, slot, selected);
    }

    public void method_7851(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> tooltip, class_1836 type) {
        class_2583 textStyle = Styles.TEXT;
        class_2583 abilityStyle = Styles.ABILITY;
        class_2583 rightClickStyle = Styles.RIGHT_CLICK;
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.lustrous_moxie.tooltip1").method_10862(abilityStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.lustrous_moxie.tooltip2").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.lustrous_moxie.tooltip3").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.lustrous_moxie.tooltip4").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.lustrous_moxie.tooltip5").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.lustrous_moxie.tooltip6").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.onrightclickheld").method_10862(rightClickStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.lustrous_moxie.tooltip7").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.lustrous_moxie.tooltip8").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.lustrous_moxie.tooltip9").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.lustrous_moxie.tooltip10").method_10862(textStyle));
        super.method_7851(itemStack, tooltipContext, tooltip, type);
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedFloat.Restrict(min=0.0f, max=1.0f)
        public float chance = 0.2f;
        @ValidatedInt.Restrict(min=0)
        public int cooldown = 400;
        @ValidatedInt.Restrict(min=0)
        public int stunTime = 30;
        @ValidatedInt.Restrict(min=0)
        public int range = 20;
        @ValidatedInt.Restrict(min=0)
        public int aoe = 5;
        @ValidatedFloat.Restrict(min=0.0f)
        public float knockbackStrength = 2.0f;
        @ValidatedFloat.Restrict(min=0.0f)
        public float targetDamage = 15.0f;
        @ValidatedFloat.Restrict(min=0.0f)
        public float aoeDamage = 10.0f;

        public EffectSettings() {
            super((Supplier)new ItemStackTooltipAppender(new Supplier[]{ModItemsRegistry.LUSTROUS_MOXIE}));
        }
    }
}

