/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import net.rosemarythyme.simplymore.entity.RiftAreaEffectCloudEntity;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.item.interfaces.Weapon;
import net.rosemarythyme.simplymore.registry.ModItemsRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.util.Styles;
import org.joml.Vector3f;

public class MatterbaneItem
extends SimplyMoreUniqueSwordItem {
    int skillCooldown;

    public MatterbaneItem(class_1832 toolMaterial, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, attackDamage, attackSpeed, Weapon.SwordTypes.SWORD, settings);
        this.skillCooldown = MatterbaneItem.effect.matterbane.cooldown;
    }

    public Vector3f getColor(class_1799 stack) {
        class_9282 color = (class_9282)stack.method_57824(class_9334.field_49644);
        if (color == null) {
            return new Vector3f(1.0f, 0.0f, 0.0f);
        }
        int rgb = color.comp_2384();
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return new Vector3f((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!user.method_37908().method_8608()) {
            Vector3f color = this.getColor(user.method_5998(hand));
            RiftAreaEffectCloudEntity riftAreaEffectCloudEntity = new RiftAreaEffectCloudEntity(user.method_37908(), user.method_23317(), user.method_23318() + 3.0, user.method_23321(), (class_1309)user, color);
            user.method_37908().method_8649((class_1297)riftAreaEffectCloudEntity);
            user.method_37908().method_8396(null, user.method_24515(), class_3417.field_38066, user.method_5634(), 1.0f, 2.0f);
            user.method_7357().method_7906((class_1792)this, this.skillCooldown);
        }
        return super.method_7836(world, user, hand);
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (!attacker.method_37908().method_8608() && SimplyMoreHelperMethods.chance(attacker, MatterbaneItem.effect.matterbane.chance) && attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            this.fireBolt(player, this.getColor(attacker.method_5998(class_1268.field_5808)));
        }
        return super.method_7873(stack, target, attacker);
    }

    public void fireBolt(class_1657 user, Vector3f color) {
        user.method_37908().method_8396(null, user.method_24515(), class_3417.field_15168, user.method_5634(), 1.0f, 2.0f);
        for (int j = 0; j < MatterbaneItem.effect.matterbane.range * 4; ++j) {
            float yaw = (float)Math.toRadians(user.method_36454() + 90.0f);
            float velocityX = (float)Math.cos(yaw) * 0.25f;
            float velocityZ = (float)Math.sin(yaw) * 0.25f;
            double dX = velocityX * (float)j;
            double dZ = velocityZ * (float)j;
            double x = user.method_23317();
            double y = (user.method_23320() + user.method_23318()) / 2.0;
            double z = user.method_23321();
            class_2390 particleEffect = new class_2390(color, 2.0f);
            ((class_3218)user.method_37908()).method_14199((class_2394)particleEffect, x + dX, y, z + dZ, 1, 0.0, 0.0, 0.0, 0.0);
            for (class_1309 entity : user.method_37908().method_18467(class_1309.class, new class_238(x - 0.6 + dX, y - 0.6, z - 0.6 + dZ, x + 0.6 + dX, y + 0.6, z + 0.6 + dZ))) {
                if (SimplyMoreHelperMethods.checkFriendlyFire(entity, (class_1309)user) || entity == user || entity.method_5655()) continue;
                entity.method_5643(user.method_48923().method_48831(), (float)MatterbaneItem.effect.matterbane.damage);
            }
        }
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, class_2398.field_22247);
        super.method_7888(stack, world, entity, slot, selected);
    }

    public void method_7851(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> tooltip, class_1836 type) {
        class_2583 textStyle = Styles.TEXT;
        class_2583 abilityStyle = Styles.ABILITY;
        class_2583 rightClickStyle = Styles.RIGHT_CLICK;
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.matterbane.tooltip1").method_10862(abilityStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.matterbane.tooltip2").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43469((String)"item.simplymore.matterbane.tooltip3", (Object[])new Object[]{MatterbaneItem.effect.matterbane.range}).method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.matterbane.tooltip4").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.onrightclick").method_10862(rightClickStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.matterbane.tooltip5").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.matterbane.tooltip6").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.matterbane.tooltip7").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.matterbane.tooltip8").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.matterbane.tooltip9").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.matterbane.tooltip10").method_10862(textStyle));
        super.method_7851(itemStack, tooltipContext, tooltip, type);
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedFloat.Restrict(min=0.0f, max=1.0f)
        public float chance = 0.2f;
        @ValidatedInt.Restrict(min=0)
        public int range = 8;
        @ValidatedFloat.Restrict(min=0.0f)
        public int damage = 6;
        @ValidatedInt.Restrict(min=0)
        public int cooldown = 1200;

        public EffectSettings() {
            super((Supplier)new ItemStackTooltipAppender(new Supplier[]{ModItemsRegistry.MATTERBANE}));
        }
    }
}

