/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.item.interfaces.Weapon;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;
import net.rosemarythyme.simplymore.registry.ModItemsRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class RevvengineItem
extends SimplyMoreUniqueSwordItem {
    public RevvengineItem(class_1832 toolMaterial, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, attackDamage, attackSpeed, Weapon.SwordTypes.SWORD, settings);
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (attacker.method_37908().method_8608()) {
            return super.method_7873(stack, target, attacker);
        }
        if (SimplyMoreHelperMethods.chance(attacker, RevvengineItem.effect.revvengine.chance)) {
            target.method_37222(new class_1293(ModEffectsRegistry.getReference(ModEffectsRegistry.BLEED), RevvengineItem.effect.revvengine.bleedTime, 0), (class_1297)attacker);
        }
        float extraDamage = RevvengineItem.getHealthModifiedValue(attacker, RevvengineItem.effect.revvengine.damageBuff, (float)HelperMethods.getEntityAttackDamage((class_1309)attacker));
        if (attacker instanceof class_1657) {
            class_1657 playerAttacker = (class_1657)attacker;
            target.field_6008 = 0;
            target.method_5643(target.method_48923().method_48802(playerAttacker), extraDamage);
        }
        return super.method_7873(stack, target, attacker);
    }

    public static float getHealthModifiedValue(class_1309 entity, float percentage, float value) {
        float hpPercentage = entity.method_6032() / entity.method_6063();
        float extraPercentage = percentage * (1.0f - hpPercentage);
        return value * extraPercentage;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        user.method_6019(hand);
        return itemStack.method_7919() >= itemStack.method_7936() - 1 ? class_1271.method_22431((Object)itemStack) : class_1271.method_22428((Object)itemStack);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        int ticksUsed;
        if (user.method_37908().method_8608()) {
            super.method_7852(world, user, stack, remainingUseTicks);
            return;
        }
        if (user.field_6012 % 5 == 0) {
            user.method_37908().method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), (class_3414)SoundRegistry.MAGIC_BOW_PULL_BACK_SHORT_VERSION_02.get(), class_3419.field_15248, 1.0f, 0.5f);
        }
        if ((ticksUsed = this.method_7881(stack, user) - remainingUseTicks) >= RevvengineItem.effect.revvengine.p3windup) {
            ((class_3218)user.method_37908()).method_14199((class_2394)new class_2390(new Vector3f(0.0f, 0.0f, 0.0f), 1.0f), user.method_23317(), user.method_23320(), user.method_23321(), 22, 0.75, 0.75, 0.75, (double)0.3f);
            ((class_3218)user.method_37908()).method_14199((class_2394)class_2398.field_11239, user.method_23317(), user.method_23318(), user.method_23321(), 3, (double)0.2f, (double)0.2f, (double)0.2f, (double)0.3f);
        } else if (ticksUsed >= RevvengineItem.effect.revvengine.p2windup) {
            ((class_3218)user.method_37908()).method_14199((class_2394)new class_2390(new Vector3f(0.5f, 0.5f, 0.5f), 1.0f), user.method_23317(), user.method_23320(), user.method_23321(), 15, 0.75, 0.75, 0.75, (double)0.3f);
        } else if (ticksUsed >= RevvengineItem.effect.revvengine.p1windup) {
            ((class_3218)user.method_37908()).method_14199((class_2394)new class_2390(new Vector3f(1.0f, 1.0f, 1.0f), 1.0f), user.method_23317(), user.method_23320(), user.method_23321(), 8, 0.75, 0.75, 0.75, (double)0.3f);
        }
        super.method_7852(world, user, stack, remainingUseTicks);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (user.method_37908().method_8608()) {
            super.method_7840(stack, world, user, remainingUseTicks);
            return;
        }
        int ticksUsed = this.method_7881(stack, user) - remainingUseTicks;
        int time = 0;
        int amplifier = 0;
        if (ticksUsed >= RevvengineItem.effect.revvengine.p3windup) {
            amplifier = 1;
            time = (int)RevvengineItem.getHealthModifiedValue(user, RevvengineItem.effect.revvengine.rangeBuff, 45.0f);
            time += 40;
            ((class_1657)user).method_7357().method_7906((class_1792)this, RevvengineItem.effect.revvengine.p3cooldown);
        } else if (ticksUsed >= RevvengineItem.effect.revvengine.p2windup) {
            time = (int)RevvengineItem.getHealthModifiedValue(user, RevvengineItem.effect.revvengine.rangeBuff, 25.0f);
            time += 25;
            ((class_1657)user).method_7357().method_7906((class_1792)this, RevvengineItem.effect.revvengine.p2cooldown);
        } else if (ticksUsed >= RevvengineItem.effect.revvengine.p1windup) {
            this.phase1(user);
        }
        if (time > 0) {
            user.method_6092(new class_1293(ModEffectsRegistry.getReference(ModEffectsRegistry.RAVENOUS), time, amplifier));
        }
        super.method_7840(stack, world, user, remainingUseTicks);
    }

    public void phase1(class_1309 user) {
        class_243 position = user.method_33571();
        Vector3d normalisedVector = SimplyMoreHelperMethods.getNormalised2dVector(user.method_36454());
        class_243 particlePos = new class_243(position.method_10216() + normalisedVector.x(), position.method_10214(), position.method_10215() + normalisedVector.z());
        class_238 box = new class_238(particlePos.method_10216() - 1.0, particlePos.method_10214() - 1.0, particlePos.method_10215() - 1.0, particlePos.method_10216() + 1.0, particlePos.method_10214() + 1.0, particlePos.method_10215() + 1.0);
        for (class_1309 livingEntity : user.method_37908().method_18467(class_1309.class, box)) {
            if (SimplyMoreHelperMethods.checkFriendlyFire(livingEntity, user) || livingEntity == user || livingEntity.method_5655()) continue;
            livingEntity.method_5643(user.method_48923().method_48802((class_1657)user), RevvengineItem.getHealthModifiedValue(user, RevvengineItem.effect.revvengine.damageBuff, RevvengineItem.effect.revvengine.p1damage) + (float)RevvengineItem.effect.revvengine.p1damage);
            livingEntity.method_6092(new class_1293(ModEffectsRegistry.getReference(ModEffectsRegistry.BLEED), RevvengineItem.effect.revvengine.bleedTime, 0));
        }
        ((class_1657)user).method_7357().method_7906((class_1792)this, RevvengineItem.effect.revvengine.p1cooldown);
        user.method_37908().method_43128(null, particlePos.method_10216(), particlePos.method_10214(), particlePos.method_10215(), class_3417.field_14999, class_3419.field_15248, 1.0f, 0.5f);
        ((class_3218)user.method_37908()).method_14199((class_2394)class_2398.field_11227, particlePos.method_10216(), particlePos.method_10214(), particlePos.method_10215(), 1, 0.0, 0.0, 0.0, 0.0);
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return 9999999;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, class_2398.field_22247);
        super.method_7888(stack, world, entity, slot, selected);
    }

    public void method_7851(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> tooltip, class_1836 type) {
        class_2583 textStyle = Styles.TEXT;
        class_2583 abilityStyle = Styles.ABILITY;
        class_2583 rightClickStyle = Styles.RIGHT_CLICK;
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.revvengine.tooltip1").method_10862(abilityStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.revvengine.tooltip2").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.revvengine.tooltip3").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.onrightclickheld").method_10862(rightClickStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.revvengine.tooltip4").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.revvengine.tooltip5").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.revvengine.tooltip6").method_10862(textStyle));
        super.method_7851(itemStack, tooltipContext, tooltip, type);
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0)
        public int p1cooldown = 240;
        @ValidatedInt.Restrict(min=0)
        public int p2cooldown = 360;
        @ValidatedInt.Restrict(min=0)
        public int p3cooldown = 440;
        @ValidatedInt.Restrict(min=0)
        public int p1windup = 10;
        @ValidatedInt.Restrict(min=0)
        public int p2windup = 40;
        @ValidatedInt.Restrict(min=0)
        public int p3windup = 80;
        @ValidatedFloat.Restrict(min=0.0f, max=1.0f)
        public float chance = 0.2f;
        @ValidatedInt.Restrict(min=0)
        public int bleedTime = 80;
        @ValidatedFloat.Restrict(min=0.0f)
        public int p1damage = 7;
        @ValidatedFloat.Restrict(min=0.0f)
        public int p2damage = 12;
        @ValidatedInt.Restrict(min=0)
        public int p2effectTime = 120;
        @ValidatedFloat.Restrict(min=0.0f)
        public int p3damage = 15;
        @ValidatedInt.Restrict(min=0)
        public int p3effectTime = 100;
        @ValidatedInt.Restrict(min=0)
        public int explosionWindup = 80;
        @ValidatedFloat.Restrict(min=0.0f)
        public int explosionDamage = 10;
        @ValidatedFloat.Restrict(min=0.0f, max=1.0f)
        public float damageBuff = 0.6f;
        @ValidatedFloat.Restrict(min=0.0f, max=1.0f)
        public float rangeBuff = 0.5f;

        public EffectSettings() {
            super((Supplier)new ItemStackTooltipAppender(new Supplier[]{ModItemsRegistry.REVVENGINE}));
        }
    }
}

