/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.item.interfaces.Weapon;
import net.rosemarythyme.simplymore.registry.ModItemsRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.util.Styles;

public class StasisItem
extends SimplyMoreUniqueSwordItem {
    int skillCooldown;
    int onHitCooldown;

    public StasisItem(class_1832 toolMaterial, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, attackDamage, attackSpeed, Weapon.SwordTypes.SWORD, settings);
        this.skillCooldown = StasisItem.effect.stasis.cooldown;
        this.onHitCooldown = StasisItem.effect.stasis.stunTime;
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (!attacker.method_37908().method_8608() && SimplyMoreHelperMethods.chance(attacker, StasisItem.effect.stasis.chance)) {
            attacker.method_37908().method_60511(null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), class_3417.field_14896, class_3419.field_15248, 0.5f, 2.0f);
            ((class_3218)attacker.method_37908()).method_14199((class_2394)class_2398.field_29644, attacker.method_23317(), attacker.method_23318() + 0.5, attacker.method_23321(), 50, 0.15, 0.25, 0.15, 0.1);
            if (target instanceof class_1657) {
                class_1657 playerTarget = (class_1657)target;
                for (class_1799 item : playerTarget.method_5877()) {
                    if (playerTarget.method_7357().method_7904(item.method_7909())) continue;
                    playerTarget.method_7357().method_7906(item.method_7909(), this.onHitCooldown);
                }
            }
        }
        return super.method_7873(stack, target, attacker);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (itemStack.method_7919() >= itemStack.method_7936() - 1) {
            return class_1271.method_22431((Object)itemStack);
        }
        user.method_6019(hand);
        return class_1271.method_22428((Object)itemStack);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingTicks) {
        if (!world.method_8608() && user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            class_3218 serverWorld = (class_3218)world;
            if (remainingTicks % 4 == 0) {
                world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14865, class_3419.field_15248, 0.5f, 1.0f);
            }
            if (remainingTicks == 1) {
                this.createLightningStrike(player, serverWorld);
                this.damageAndElectrifyEnemies(user, player, serverWorld);
                player.method_7357().method_7906(stack.method_7909(), this.skillCooldown);
            }
        }
        super.method_7852(world, user, stack, remainingTicks);
    }

    private void createLightningStrike(class_1657 player, class_3218 world) {
        for (int i = 0; i < 30; ++i) {
            int randomX = player.method_59922().method_43048(9) - 5;
            int randomZ = player.method_59922().method_43048(9) - 5;
            class_2338 position = player.method_24515().method_10069(randomX, 0, randomZ);
            class_1538 lightning = (class_1538)class_1299.field_6112.method_5883((class_1937)world);
            if (lightning == null) continue;
            lightning.method_24203((double)position.method_10263(), (double)position.method_10264(), (double)position.method_10260());
            lightning.method_29498(true);
            world.method_8649((class_1297)lightning);
        }
    }

    private void damageAndElectrifyEnemies(class_1309 user, class_1657 player, class_3218 world) {
        int boxRange = StasisItem.effect.stasis.range;
        class_238 box = new class_238(user.method_23317() - (double)boxRange, user.method_23318() - 2.0, user.method_23321() - (double)boxRange, user.method_23317() + (double)boxRange, user.method_23318() + (double)(boxRange * 2), user.method_23321() + (double)boxRange);
        for (class_1309 entity : world.method_18467(class_1309.class, box)) {
            if (entity == user || SimplyMoreHelperMethods.checkFriendlyFire(entity, user)) continue;
            entity.method_5643(player.method_48923().method_48831(), StasisItem.effect.stasis.strikeDamage);
            class_1538 lightning = (class_1538)class_1299.field_6112.method_5883((class_1937)world);
            if (lightning == null) continue;
            lightning.method_24203(entity.method_23317(), entity.method_23318(), entity.method_23321());
            lightning.method_29498(true);
            world.method_8649((class_1297)lightning);
            entity.method_5800(world, lightning);
        }
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return StasisItem.effect.stasis.strikeWindup;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8951;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, class_2398.field_28479);
        super.method_7888(stack, world, entity, slot, selected);
    }

    public void method_7851(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> tooltip, class_1836 type) {
        class_2583 textStyle = Styles.TEXT;
        class_2583 abilityStyle = Styles.ABILITY;
        class_2583 rightClickStyle = Styles.RIGHT_CLICK;
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.stasis.tooltip1").method_10862(abilityStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.stasis.tooltip2").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.stasis.tooltip3").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.onrightclickheld").method_10862(rightClickStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.stasis.tooltip4").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.stasis.tooltip5").method_10862(textStyle));
        super.method_7851(itemStack, tooltipContext, tooltip, type);
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0)
        public int cooldown = 700;
        @ValidatedInt.Restrict(min=0)
        public int stunTime = 80;
        @ValidatedFloat.Restrict(min=0.0f, max=1.0f)
        public float chance = 0.2f;
        @ValidatedFloat.Restrict(min=0.0f)
        public float strikeDamage = 16.0f;
        @ValidatedInt.Restrict(min=0)
        public int strikeWindup = 60;
        @ValidatedInt.Restrict(min=0)
        public int range = 4;

        public EffectSettings() {
            super((Supplier)new ItemStackTooltipAppender(new Supplier[]{ModItemsRegistry.STASIS}));
        }
    }
}

