/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.scripting;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collections;
import java.util.Map;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import tschipp.carryon.Constants;
import tschipp.carryon.common.scripting.CarryOnScript;
import tschipp.carryon.common.scripting.ScriptManager;
import tschipp.carryon.networking.clientbound.ClientboundSyncScriptsPacket;
import tschipp.carryon.platform.Services;

public class ScriptReloadListener
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public ScriptReloadListener() {
        super(GSON, "carryon/scripts");
    }

    protected void apply(Map<class_2960, JsonElement> objects, class_3300 manager, class_3695 profiler) {
        ScriptManager.SCRIPTS.clear();
        try {
            objects.forEach((path, jsonElem) -> {
                DataResult res = CarryOnScript.CODEC.parse((DynamicOps)JsonOps.INSTANCE, jsonElem);
                if (res.result().isPresent()) {
                    CarryOnScript script = (CarryOnScript)res.result().get();
                    if (script.isValid()) {
                        ScriptManager.SCRIPTS.add(script);
                    }
                } else {
                    Constants.LOG.warn("Error while parsing script: " + ((DataResult.Error)res.error().get()).message());
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(ScriptManager.SCRIPTS, (s1, s2) -> Long.compare(s2.priority(), s1.priority()));
    }

    public static void syncScriptsWithClient(class_3222 player) {
        if (player != null) {
            DataResult result = Codec.list(CarryOnScript.CODEC).encodeStart((DynamicOps)class_2509.field_11560, ScriptManager.SCRIPTS);
            class_2520 tag = (class_2520)result.getOrThrow(s -> {
                throw new RuntimeException("Error while synching Carry On Scripts: " + s);
            });
            Services.PLATFORM.sendPacketToPlayer(Constants.PACKET_ID_SYNC_SCRIPTS, new ClientboundSyncScriptsPacket(tag), player);
        }
    }
}

