/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround;

import dev.architectury.event.events.client.ClientCommandRegistrationEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.ReloadListenerRegistry;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1144;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.commands.Commands;
import org.orecruncher.dsurround.config.libraries.AssetLibraryEvent;
import org.orecruncher.dsurround.config.libraries.IBiomeLibrary;
import org.orecruncher.dsurround.config.libraries.IBlockLibrary;
import org.orecruncher.dsurround.config.libraries.IDimensionInformation;
import org.orecruncher.dsurround.config.libraries.IDimensionLibrary;
import org.orecruncher.dsurround.config.libraries.IEntityEffectLibrary;
import org.orecruncher.dsurround.config.libraries.IItemLibrary;
import org.orecruncher.dsurround.config.libraries.IReloadEvent;
import org.orecruncher.dsurround.config.libraries.ISoundLibrary;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.config.libraries.impl.BiomeLibrary;
import org.orecruncher.dsurround.config.libraries.impl.BlockLibrary;
import org.orecruncher.dsurround.config.libraries.impl.DimensionInformation;
import org.orecruncher.dsurround.config.libraries.impl.DimensionLibrary;
import org.orecruncher.dsurround.config.libraries.impl.EntityEffectLibrary;
import org.orecruncher.dsurround.config.libraries.impl.ItemLibrary;
import org.orecruncher.dsurround.config.libraries.impl.SoundLibrary;
import org.orecruncher.dsurround.config.libraries.impl.TagLibrary;
import org.orecruncher.dsurround.eventing.ClientState;
import org.orecruncher.dsurround.gui.keyboard.KeyBindings;
import org.orecruncher.dsurround.gui.overlay.OverlayManager;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.Library;
import org.orecruncher.dsurround.lib.config.ConfigurationData;
import org.orecruncher.dsurround.lib.config.IConfigScreenFactoryProvider;
import org.orecruncher.dsurround.lib.config.compat.ClothAPIFactoryProvider;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.di.IServiceContainer;
import org.orecruncher.dsurround.lib.events.HandlerPriority;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.logging.ModLog;
import org.orecruncher.dsurround.lib.registry.ReloadListener;
import org.orecruncher.dsurround.lib.resources.ResourceUtilities;
import org.orecruncher.dsurround.lib.seasons.ISeasonalInformation;
import org.orecruncher.dsurround.lib.seasons.SeasonManager;
import org.orecruncher.dsurround.lib.version.IVersionChecker;
import org.orecruncher.dsurround.lib.version.VersionChecker;
import org.orecruncher.dsurround.lib.version.VersionResult;
import org.orecruncher.dsurround.processing.Handlers;
import org.orecruncher.dsurround.processing.fog.HolisticFogRangeCalculator;
import org.orecruncher.dsurround.runtime.ConditionEvaluator;
import org.orecruncher.dsurround.runtime.IConditionEvaluator;
import org.orecruncher.dsurround.sound.AudioPlayer;
import org.orecruncher.dsurround.sound.AudioPlayerDebug;
import org.orecruncher.dsurround.sound.IAudioPlayer;

public final class Client {
    public static Configuration Config;
    private final IModLog logger = Library.LOGGER;
    private CompletableFuture<Optional<VersionResult>> versionInfo;

    public Client() {
        ContainerManager.getRootContainer().registerSingleton(IModLog.class, this.logger).registerSingleton(IConfigScreenFactoryProvider.class, ClothAPIFactoryProvider.class);
        Config = ConfigurationData.getConfig(Configuration.class);
        IModLog iModLog = this.logger;
        if (iModLog instanceof ModLog) {
            ModLog ml = (ModLog)iModLog;
            ml.setDebug(Client.Config.logging.enableDebugLogging);
            ml.setTraceMask(Client.Config.logging.traceMask);
        }
        Configuration.CONFIG_CHANGED.register(cfg -> {
            if (cfg instanceof Configuration) {
                Configuration config = (Configuration)cfg;
                IModLog patt0$temp = this.logger;
                if (patt0$temp instanceof ModLog) {
                    ModLog ml = (ModLog)patt0$temp;
                    ml.setDebug(config.logging.enableDebugLogging);
                    ml.setTraceMask(config.logging.traceMask);
                }
            }
        });
    }

    public void construct() {
        this.logger.info("[%s] Bootstrapping", "dsurround");
        Library.initialize();
        ContainerManager.getRootContainer().registerFactory(class_1144.class, GameUtils::getSoundManager);
        this.logger.info("[%s] Boostrap completed", "dsurround");
    }

    public void initializeClient() {
        this.logger.info("[%s] Client initializing", "dsurround");
        if (Client.Config.logging.registerCommands) {
            if (!Platform.isModLoaded((String)"quilt_loader")) {
                ClientCommandRegistrationEvent.EVENT.register(Commands::register);
            } else {
                Library.LOGGER.info("Not registering client commands as mod is running in Quilt environment", new Object[0]);
            }
        }
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_3302)new ReloadListener());
        Handlers.registerHandlers();
        ClientState.STARTED.register(this::onComplete, HandlerPriority.VERY_HIGH);
        ClientState.ON_CONNECT.register(this::onConnect, HandlerPriority.LOW);
        ContainerManager.getRootContainer().registerSingleton(Config).registerSingleton(Client.Config.logging).registerSingleton(Client.Config.soundSystem).registerSingleton(Client.Config.enhancedSounds).registerSingleton(Client.Config.soundOptions).registerSingleton(Client.Config.blockEffects).registerSingleton(Client.Config.entityEffects).registerSingleton(Client.Config.footstepAccents).registerSingleton(Client.Config.particleTweaks).registerSingleton(Client.Config.compassAndClockOptions).registerSingleton(Client.Config.fogOptions).registerSingleton(Client.Config.otherOptions).registerSingleton(IConditionEvaluator.class, ConditionEvaluator.class).registerSingleton(IVersionChecker.class, VersionChecker.class).registerSingleton(ITagLibrary.class, TagLibrary.class).registerSingleton(ISoundLibrary.class, SoundLibrary.class).registerSingleton(IBiomeLibrary.class, BiomeLibrary.class).registerSingleton(IDimensionLibrary.class, DimensionLibrary.class).registerSingleton(IDimensionInformation.class, DimensionInformation.class).registerFactory(ISeasonalInformation.class, () -> SeasonManager.HANDLER).registerSingleton(IBlockLibrary.class, BlockLibrary.class).registerSingleton(IItemLibrary.class, ItemLibrary.class).registerSingleton(IEntityEffectLibrary.class, EntityEffectLibrary.class).registerSingleton(OverlayManager.class);
        if (this.logger.isDebugging()) {
            ContainerManager.getRootContainer().registerSingleton(IAudioPlayer.class, AudioPlayerDebug.class);
        } else {
            ContainerManager.getRootContainer().registerSingleton(IAudioPlayer.class, AudioPlayer.class);
        }
        this.versionInfo = Client.Config.logging.enableModUpdateChatMessage ? CompletableFuture.supplyAsync(ContainerManager.resolve(IVersionChecker.class)::getUpdateText) : CompletableFuture.completedFuture(Optional.empty());
        KeyBindings.register();
        this.logger.info("[%s] Client initialization complete", "dsurround");
    }

    public void onComplete(class_310 client) {
        this.logger.info("[%s] Completing initialization", "dsurround");
        IServiceContainer container = ContainerManager.getRootContainer();
        AssetLibraryEvent.RELOAD.register(container.resolve(ISoundLibrary.class)::reload, HandlerPriority.VERY_HIGH);
        AssetLibraryEvent.RELOAD.register(container.resolve(ITagLibrary.class)::reload, HandlerPriority.VERY_HIGH);
        AssetLibraryEvent.RELOAD.register(container.resolve(IBiomeLibrary.class)::reload, HandlerPriority.HIGH);
        AssetLibraryEvent.RELOAD.register(container.resolve(IBlockLibrary.class)::reload, HandlerPriority.HIGH);
        AssetLibraryEvent.RELOAD.register(container.resolve(IItemLibrary.class)::reload, HandlerPriority.HIGH);
        AssetLibraryEvent.RELOAD.register(container.resolve(IEntityEffectLibrary.class)::reload, HandlerPriority.HIGH);
        AssetLibraryEvent.RELOAD.register(container.resolve(IDimensionLibrary.class)::reload, HandlerPriority.HIGH);
        ClientState.TAG_SYNC.register(event -> {
            this.logger.info("Tag sync event received - reloading libraries", new Object[0]);
            ResourceUtilities resourceUtilities = ResourceUtilities.createForCurrentState();
            ((IReloadEvent)AssetLibraryEvent.RELOAD.raise()).onReload(resourceUtilities, IReloadEvent.Scope.TAGS);
        }, HandlerPriority.VERY_HIGH);
        container.registerSingleton(HolisticFogRangeCalculator.class);
        ContainerManager.resolve(HolisticFogRangeCalculator.class);
        container.resolve(Handlers.class);
        this.logger.info("[%s] Finalization complete", "dsurround");
    }

    private void onConnect(class_310 minecraftClient) {
        try {
            Optional<VersionResult> versionQueryResult = this.versionInfo.get();
            if (versionQueryResult.isPresent()) {
                VersionResult result = versionQueryResult.get();
                this.logger.info("Update to %s version %s is available", result.displayName(), result.version());
                Optional<class_1657> player = GameUtils.getPlayer();
                player.ifPresent(p -> p.method_43496(result.getChatText()));
            } else if (Client.Config.logging.enableModUpdateChatMessage) {
                this.logger.info("The mod version is current", new Object[0]);
            }
        }
        catch (Throwable t) {
            this.logger.error(t, "Unable to process version information", new Object[0]);
        }
    }
}

