/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround;

import org.orecruncher.dsurround.config.CompassStyle;
import org.orecruncher.dsurround.config.WaterRippleStyle;
import org.orecruncher.dsurround.lib.config.ConfigurationData;

@ConfigurationData.ConfigPlacement(folderName="dsurround", fileName="dsurround")
@ConfigurationData.TranslationRoot(value="dsurround.config")
public class Configuration
extends ConfigurationData {
    @ConfigurationData.Property
    @ConfigurationData.Comment(value="Configuration options for modifying logging behavior")
    public final Logging logging = new Logging();
    @ConfigurationData.Property
    @ConfigurationData.Comment(value="Configuration options for modifying Minecraft's Sound System behavior")
    public final SoundSystem soundSystem = new SoundSystem();
    @ConfigurationData.Property
    @ConfigurationData.Comment(value="Configuration options for enhanced sound processing")
    public final EnhancedSounds enhancedSounds = new EnhancedSounds();
    @ConfigurationData.Property
    @ConfigurationData.Comment(value="Configuration options for sounds in general")
    public final SoundOptions soundOptions = new SoundOptions();
    @ConfigurationData.Property
    @ConfigurationData.Comment(value="Configuration options for block effects")
    public final BlockEffects blockEffects = new BlockEffects();
    @ConfigurationData.Property
    @ConfigurationData.Comment(value="Configuration options for entity effects")
    public final EntityEffects entityEffects = new EntityEffects();
    @ConfigurationData.Property
    @ConfigurationData.Comment(value="Configuration options for footstep accent effects")
    public final FootstepAccents footstepAccents = new FootstepAccents();
    @ConfigurationData.Property
    @ConfigurationData.Comment(value="Configuration options for tweaking particle behavior")
    public final ParticleTweaks particleTweaks = new ParticleTweaks();
    @ConfigurationData.Property
    @ConfigurationData.Comment(value="Configuration options for the compass and clock overlay")
    public final CompassAndClockOptions compassAndClockOptions = new CompassAndClockOptions();
    @ConfigurationData.Property
    @ConfigurationData.Comment(value="Configuration options for fog effects")
    public final FogOptions fogOptions = new FogOptions();
    @ConfigurationData.Property
    @ConfigurationData.Comment(value="Configuration options for other things")
    public final OtherOptions otherOptions = new OtherOptions();

    public static class Logging {
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enables/disables debug logging of the mod")
        public boolean enableDebugLogging = false;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Bitmask for toggling various debug traces")
        public int traceMask = 0;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable chat window notification of newer updates available")
        public boolean enableModUpdateChatMessage = true;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable filtering display of tags in the diagnostics overlay")
        public boolean filteredTagView = true;
        @ConfigurationData.Property
        @ConfigurationData.RestartRequired
        @ConfigurationData.Comment(value="Enable/disable registration of client side commands")
        public boolean registerCommands = true;
    }

    public static class SoundSystem {
        @ConfigurationData.Property
        @ConfigurationData.IntegerRange(min=8, max=16)
        @ConfigurationData.Slider
        @ConfigurationData.RestartRequired
        @ConfigurationData.Comment(value="The number of sound channels to reserve for streaming sounds (music, biome sounds, records, etc.)")
        public int streamingChannels = 12;
        @ConfigurationData.Property
        @ConfigurationData.IntegerRange(min=0, max=200)
        @ConfigurationData.Slider
        @ConfigurationData.Comment(value="Ticks between culled sound events (0 to disable culling)")
        public int cullInterval = 20;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enables/disables cancellation of sound that a player will not hear")
        public boolean enableSoundPruning = true;
    }

    public static class EnhancedSounds {
        @ConfigurationData.Property
        @ConfigurationData.RestartRequired
        @ConfigurationData.Comment(value="Enable/disable enhanced sound processing (reverb, occlusion, etc)")
        public boolean enableEnhancedSounds = true;
        @ConfigurationData.Property
        @ConfigurationData.IntegerRange(min=0, max=8)
        @ConfigurationData.Slider
        @ConfigurationData.RestartRequired
        @ConfigurationData.Comment(value="Number of background threads to use for enhanced sound processing (0 means use internal default)")
        public int backgroundThreadWorkers = 0;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable on the fly conversion of stereo sounds to mono as needed")
        public boolean enableMonoConversion = true;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable sound occlusion processing (sound muffling behind blocks)")
        public boolean enableOcclusionProcessing = false;
        @ConfigurationData.Property
        @ConfigurationData.IntegerRange(min=16, max=64)
        @ConfigurationData.RestartRequired
        @ConfigurationData.Comment(value="The number of rays to project around a sound location to calculate reverb effect")
        public int reverbRays = 32;
        @ConfigurationData.Property
        @ConfigurationData.IntegerRange(min=2, max=8)
        @ConfigurationData.RestartRequired
        @ConfigurationData.Comment(value="The number of reflections the ray calculation will perform before ending a ray calculation")
        public int reverbBounces = 4;
        @ConfigurationData.Property
        @ConfigurationData.IntegerRange(min=64, max=512)
        @ConfigurationData.RestartRequired
        @ConfigurationData.Comment(value="Total distance a reverb ray will traverse before ending calculation")
        public int reverbRayTraceDistance = 256;
    }

    public static class SoundOptions {
        @ConfigurationData.Property
        @ConfigurationData.Slider
        @ConfigurationData.IntegerRange(min=0, max=400)
        @ConfigurationData.Comment(value="Ambient sounds played by the mod will be multiplied by this factor")
        public int ambientVolumeScaling = 100;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enables replacement of thunder sounds with Dynamic Surroundings' version")
        public boolean replaceThunderSounds = true;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enables playing sounds that are considered scary")
        public boolean allowScarySounds = true;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enables playing biome background music while in creative")
        public boolean playBiomeMusicWhileCreative = false;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enables display of toast messages for credited music")
        public boolean displayToastMessagesForMusic = true;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enables sound remapping when sounds are played")
        public boolean remapSounds = true;
    }

    public static class BlockEffects {
        @ConfigurationData.Property
        @ConfigurationData.IntegerRange(min=16, max=64)
        @ConfigurationData.Slider
        @ConfigurationData.Comment(value="Distance that will be scanned when generating block effects")
        public int blockEffectRange = 32;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable steam column effect when liquids are adjacent to hot sources, like lava and magma")
        public boolean steamColumnEnabled = true;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable flame jets produced over lava, etc.")
        public boolean flameJetEnabled = true;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable bubble columns generated underwater")
        public boolean bubbleColumnEnabled = true;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable firefly generation")
        public boolean firefliesEnabled = true;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable waterfall effect from flowing water")
        public boolean waterfallsEnabled = true;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable sounds from waterfalls")
        public boolean enableWaterfallSounds = true;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable particles from waterfalls")
        public boolean enableWaterfallParticles = true;
        @ConfigurationData.Property
        @ConfigurationData.EnumType(value=WaterRippleStyle.class)
        @ConfigurationData.Comment(value="The style of water ripple to render when a drop hits a fluid")
        public WaterRippleStyle waterRippleStyle = WaterRippleStyle.PIXELATED_CIRCLE;
    }

    public static class EntityEffects {
        @ConfigurationData.Property
        @ConfigurationData.IntegerRange(min=16, max=64)
        @ConfigurationData.Slider
        @ConfigurationData.Comment(value="The maximum range at which entity special effects are applied")
        public int entityEffectRange = 24;
        @ConfigurationData.Property
        @ConfigurationData.RestartRequired(client=false)
        @ConfigurationData.Comment(value="Enable/disable bow pull sound effect")
        public boolean enableBowPull = true;
        @ConfigurationData.Property
        @ConfigurationData.RestartRequired(client=false)
        @ConfigurationData.Comment(value="Enable/disable breath effect in cold biomes and underwater")
        public boolean enableBreathEffect = true;
        @ConfigurationData.Property
        @ConfigurationData.RestartRequired(client=false)
        @ConfigurationData.Comment(value="Enable/disable player toolbar sound effects")
        public boolean enablePlayerToolbarEffect = true;
        @ConfigurationData.Property
        @ConfigurationData.RestartRequired(client=false)
        @ConfigurationData.Comment(value="Enable/disable sound effects for blocks on the toolbar")
        public boolean enableToolbarBlockSounds = false;
        @ConfigurationData.Property
        @ConfigurationData.RestartRequired(client=false)
        @ConfigurationData.Comment(value="Enable/disable item swing sound effects from players and mobs")
        public boolean enableSwingEffect = true;
        @ConfigurationData.Property
        @ConfigurationData.RestartRequired(client=false)
        @ConfigurationData.Comment(value="Enable/disable sound effect when walking through dense brush")
        public boolean enableBrushStepEffect = true;
    }

    public static class FootstepAccents {
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable foot step accents globally")
        public boolean enableAccents = true;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable accents for armor that is worn")
        public boolean enableArmorAccents = true;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable accents when it is raining or blocks are waterlogged")
        public boolean enableWetSurfaceAccents = true;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable accents when the player is walking on squeaky blocks")
        public boolean enableFloorSqueaks = true;
    }

    public static class ParticleTweaks {
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable showing of projectile particle trails")
        public boolean suppressProjectileParticleTrails = false;
    }

    public static class CompassAndClockOptions {
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable display of the clock display when holding a clock item")
        public boolean enableClock = true;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable display of the compass display when holding a compass item")
        public boolean enableCompass = true;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Style of compass rendering")
        @ConfigurationData.EnumType(value=CompassStyle.class)
        public CompassStyle compassStyle = CompassStyle.TRANSPARENT_WITH_INDICATOR;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Scales the display by the specified amount")
        @ConfigurationData.DoubleRange(min=0.5, max=4.0)
        public double scale = 1.0;
    }

    public static class FogOptions {
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable fog effects")
        public boolean enableFogEffects = true;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable morning fog effect")
        public boolean enableMorningFog = true;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable biome fog effect")
        public boolean enableBiomeFog = true;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable weather fog effect")
        public boolean enableWeatherFog = true;
    }

    public static class OtherOptions {
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable playing random sound at the Minecraft finish loading to main screen")
        public boolean playRandomSoundOnStartup = true;
    }

    public static class Flags {
        public static final int AUDIO_PLAYER = 1;
        public static final int BASIC_SOUND_PLAY = 2;
        public static final int RESOURCE_LOADING = 4;
    }
}

