/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.commands.handlers;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.PrintStream;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import org.orecruncher.dsurround.config.libraries.IBiomeLibrary;
import org.orecruncher.dsurround.config.libraries.IBlockLibrary;
import org.orecruncher.dsurround.config.libraries.IDimensionLibrary;
import org.orecruncher.dsurround.config.libraries.IItemLibrary;
import org.orecruncher.dsurround.config.libraries.ISoundLibrary;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.platform.IMinecraftDirectories;

public class DumpCommandHandler {
    private static final IModLog LOGGER = ContainerManager.resolve(IModLog.class);
    private static final IMinecraftDirectories directories = ContainerManager.resolve(IMinecraftDirectories.class);
    private static final IBiomeLibrary biomeLibrary = ContainerManager.resolve(IBiomeLibrary.class);
    private static final ISoundLibrary soundLibrary = ContainerManager.resolve(ISoundLibrary.class);
    private static final IDimensionLibrary dimensionLibrary = ContainerManager.resolve(IDimensionLibrary.class);
    private static final IBlockLibrary blockLibrary = ContainerManager.resolve(IBlockLibrary.class);
    private static final IItemLibrary itemLibrary = ContainerManager.resolve(IItemLibrary.class);
    private static final ITagLibrary tagLibrary = ContainerManager.resolve(ITagLibrary.class);

    public static class_2561 dumpBiomes() {
        return DumpCommandHandler.handle("biomes", biomeLibrary::dump);
    }

    public static class_2561 dumpSounds() {
        return DumpCommandHandler.handle("sounds", soundLibrary::dump);
    }

    public static class_2561 dumpDimensions() {
        return DumpCommandHandler.handle("dimensions", dimensionLibrary::dump);
    }

    public static class_2561 dumpBlockConfigRules() {
        return DumpCommandHandler.handle("blockconfigrules", blockLibrary::dumpBlockConfigRules);
    }

    public static class_2561 dumpBlockState() {
        return DumpCommandHandler.handle("blockstates", blockLibrary::dumpBlockStates);
    }

    public static class_2561 dumpBlocks(boolean noStates) {
        return DumpCommandHandler.handle("blocks", () -> blockLibrary.dumpBlocks(noStates));
    }

    public static class_2561 dumpBlocksByTag() {
        return DumpCommandHandler.handle("blocksbytag", blockLibrary::dump);
    }

    public static class_2561 dumpItems() {
        return DumpCommandHandler.handle("items", itemLibrary::dump);
    }

    public static class_2561 dumpTags() {
        return DumpCommandHandler.handle("tags", tagLibrary::dump);
    }

    public static class_2561 dumpDIRegistrations() {
        return DumpCommandHandler.handle("diregistrations", ContainerManager::dumpRegistrations);
    }

    private static class_2561 handle(String operation, Supplier<Stream<String>> supplier) {
        String fileName = operation + ".txt";
        File target = directories.getModDumpDirectory().resolve(fileName).toFile();
        try {
            try (PrintStream out = new PrintStream(target);){
                Stream<String> stream = supplier.get();
                stream.forEach(out::println);
                out.flush();
            }
            return class_2561.method_43469((String)"dsurround.command.dsdump.success", (Object[])new Object[]{operation, target.toString()});
        }
        catch (Throwable t) {
            LOGGER.error(t, "Error writing dump file '%s'", target.toString());
            return class_2561.method_43469((String)"dsurround.command.dsdump.failure", (Object[])new Object[]{operation, t.getMessage()});
        }
    }

    private static Stream<String> tbd() {
        ImmutableList result = ImmutableList.of((Object)"Not hooked up");
        return result.stream();
    }
}

