/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public enum BiomeTrait {
    UNKNOWN("UNKNOWN"),
    SYNTHETIC("SYNTHETIC"),
    INSIDE("inside"),
    VILLAGE("VILLAGE"),
    PLAYER("PLAYER"),
    SPACE("SPACE"),
    CLOUDS("CLOUDS"),
    UNDER_RIVER("UNDER_RIVER"),
    UNDER_WATER("UNDER_WATER"),
    UNDER_OCEAN("UNDER_OCEAN"),
    NONE("none"),
    TAIGA("taiga"),
    HILLS("hills"),
    JUNGLE("jungle"),
    PLAINS("plains"),
    SAVANNA("savanna"),
    ICY("icy"),
    THEEND("the_end"),
    BEACH("beach"),
    FOREST("forest"),
    OCEAN("ocean"),
    DESERT("desert"),
    RIVER("river"),
    SWAMP("swamp"),
    MUSHROOM("mushroom"),
    NETHER("nether"),
    UNDERGROUND("underground"),
    WATER("WATER"),
    WET("WET"),
    DRY("DRY"),
    HOT("HOT"),
    COLD("COLD"),
    TEMPERATE("TEMPERATE"),
    SPARSE("SPARSE"),
    DENSE("DENSE"),
    CONIFEROUS("CONIFEROUS"),
    DECIDUOUS("DECIDUOUS"),
    SPOOKY("SPOOKY"),
    DEAD("DEAD"),
    MAGICAL("MAGICAL"),
    PLATEAU("PLATEAU"),
    MOUNTAIN("MOUNTAIN"),
    SANDY("SANDY"),
    SNOWY("SNOWY"),
    WASTELAND("WASTELAND"),
    VOID("VOID"),
    OVERWORLD("OVERWORLD"),
    DEEP("DEEP"),
    WINDSWEPT("WINDSWEPT"),
    FLORAL("FLORAL"),
    BADLANDS("BADLANDS"),
    CAVES("CAVES"),
    RARE("RARE"),
    LUSH("LUSH");

    private static final Map<String, BiomeTrait> BY_NAME;
    public static final Codec<BiomeTrait> CODEC;
    private static final Map<String, BiomeTrait> mapper;
    private final String name;

    private BiomeTrait(String name) {
        this.name = name.toUpperCase();
    }

    public static BiomeTrait of(String name) {
        BiomeTrait result = mapper.get(name.toUpperCase());
        return result == null ? UNKNOWN : result;
    }

    private static void register(BiomeTrait trait) {
        mapper.put(trait.name, trait);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    static {
        BY_NAME = Arrays.stream(BiomeTrait.values()).collect(Collectors.toMap(BiomeTrait::getName, category -> category));
        CODEC = Codec.STRING.comapFlatMap(DataResult.partialGet(BY_NAME::get, () -> "unknown biome trait"), d -> d.name);
        mapper = new HashMap<String, BiomeTrait>();
        for (BiomeTrait trait : BiomeTrait.values()) {
            if (trait == UNKNOWN) continue;
            BiomeTrait.register(trait);
        }
    }
}

