/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import dev.architectury.platform.Platform;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1309;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.effects.IEntityEffect;
import org.orecruncher.dsurround.effects.entity.BowUseEffect;
import org.orecruncher.dsurround.effects.entity.BreathEffect;
import org.orecruncher.dsurround.effects.entity.ItemSwingEffect;
import org.orecruncher.dsurround.effects.entity.StepThroughBrushEffect;
import org.orecruncher.dsurround.effects.entity.ToolbarEffect;
import org.orecruncher.dsurround.lib.di.ContainerManager;

public enum EntityEffectType {
    UNKNOWN("unknown", entity -> null),
    BOW_PULL("bow_pull", entity -> EntityEffectType.getInstance(BowUseEffect.class)),
    FROST_BREATH("frost_breath", entity -> EntityEffectType.getInstance(BreathEffect.class)),
    PLAYER_TOOLBAR("player_toolbar", entity -> EntityEffectType.getInstance(ToolbarEffect.class)),
    ITEM_SWING("item_swing", entity -> EntityEffectType.getInstance(ItemSwingEffect.class)),
    BRUSH_STEP("brush_step", entity -> EntityEffectType.getInstance(StepThroughBrushEffect.class));

    private static final Map<String, EntityEffectType> BY_NAME;
    public static final Codec<EntityEffectType> CODEC;
    private final String name;
    private final Function<class_1309, IEntityEffect> factory;
    private BooleanSupplier enabled;

    private static IEntityEffect getInstance(Class<? extends IEntityEffect> clazz) {
        return ContainerManager.resolve(clazz);
    }

    private EntityEffectType(String name, Function<class_1309, IEntityEffect> factory) {
        this.name = name;
        this.factory = factory;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled.getAsBoolean();
    }

    public Optional<IEntityEffect> produce(class_1309 entity) {
        if (this.isEnabled()) {
            return Optional.ofNullable(this.factory.apply(entity));
        }
        return Optional.empty();
    }

    public static EntityEffectType byName(String name) {
        return BY_NAME.get(name);
    }

    private void setConfigProvider(BooleanSupplier supplier) {
        this.enabled = supplier;
    }

    static {
        BY_NAME = Arrays.stream(EntityEffectType.values()).collect(Collectors.toMap(EntityEffectType::getName, category -> category));
        CODEC = Codec.STRING.comapFlatMap(DataResult.partialGet(BY_NAME::get, () -> "unknown entity effect"), d -> d.name);
        Configuration.EntityEffects config = ContainerManager.resolve(Configuration.EntityEffects.class);
        UNKNOWN.setConfigProvider(() -> false);
        BOW_PULL.setConfigProvider(() -> config.enableBowPull);
        FROST_BREATH.setConfigProvider(() -> config.enableBreathEffect);
        PLAYER_TOOLBAR.setConfigProvider(() -> config.enablePlayerToolbarEffect);
        ITEM_SWING.setConfigProvider(() -> config.enableSwingEffect);
        if (Platform.isModLoaded((String)"presencefootsteps")) {
            BRUSH_STEP.setConfigProvider(() -> false);
        } else {
            BRUSH_STEP.setConfigProvider(() -> config.enableBrushStepEffect);
        }
    }
}

