/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.lang.invoke.LambdaMetafactory;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.lib.IMatcher;
import org.orecruncher.dsurround.lib.IdentityUtils;
import org.orecruncher.dsurround.lib.di.ContainerManager;

public abstract class EntityTypeMatcher
implements IMatcher<class_1297> {
    public static final Codec<IMatcher<class_1297>> CODEC = Codec.STRING.comapFlatMap(EntityTypeMatcher::manifest, (Function<IMatcher, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lorg/orecruncher/dsurround/lib/IMatcher;)Ljava/lang/String;)()).stable();

    private static DataResult<IMatcher<class_1297>> manifest(String entityTypeId) {
        try {
            if (entityTypeId.startsWith("#")) {
                class_2960 id = IdentityUtils.resolveIdentifier(entityTypeId);
                class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)id);
                return DataResult.success((Object)new MatchOnEntityTag(tagKey));
            }
            if (entityTypeId.contains(":")) {
                Optional type = class_1299.method_5898((String)entityTypeId);
                return type.map(entityType -> DataResult.success((Object)new MatchOnEntityType((class_1299<?>)entityType))).orElseGet(() -> DataResult.error(() -> String.format("Unknown entity type id %s", entityTypeId)));
            }
            return DataResult.error(() -> String.format("Unknown entity class(s) %s", entityTypeId));
        }
        catch (Throwable t) {
            return DataResult.error(t::getMessage);
        }
    }

    @Override
    public abstract boolean match(class_1297 var1);

    private static class MatchOnEntityTag
    extends EntityTypeMatcher {
        private static final ITagLibrary TAG_LIBRARY = ContainerManager.resolve(ITagLibrary.class);
        private final class_6862<class_1299<?>> tagKey;

        public MatchOnEntityTag(class_6862<class_1299<?>> tagKey) {
            this.tagKey = tagKey;
        }

        @Override
        public boolean match(class_1297 entity) {
            return TAG_LIBRARY.is(this.tagKey, entity.method_5864());
        }
    }

    private static class MatchOnEntityType
    extends EntityTypeMatcher {
        private final class_1299<?> type;

        public MatchOnEntityType(class_1299<?> type) {
            this.type = type;
        }

        @Override
        public boolean match(class_1297 entity) {
            return this.type == entity.method_5864();
        }
    }
}

