/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.config.libraries.ISoundLibrary;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.sound.ISoundFactory;

public enum ItemClassType {
    NONE("none"),
    TOOL("tool"),
    SWORD("sword"),
    SHIELD("shield"),
    AXE("axe"),
    BOW("bow"),
    CROSSBOW("crossbow"),
    POTION("potion"),
    BOOK("book");

    private static final Map<String, ItemClassType> BY_NAME;
    public static final Codec<ItemClassType> CODEC;
    private final String name;
    private final class_2960 toolBarSound;
    private final class_2960 swingSound;
    private static final ISoundLibrary SOUND_LIBRARY;

    private ItemClassType(String name) {
        this.name = name;
        this.toolBarSound = class_2960.method_60655((String)"dsurround", (String)("toolbar." + name + ".equip"));
        this.swingSound = class_2960.method_60655((String)"dsurround", (String)("toolbar." + name + ".swing"));
    }

    public String getName() {
        return this.name;
    }

    public ISoundFactory getToolBarSound() {
        return SOUND_LIBRARY.getSoundFactory(this.toolBarSound).orElseThrow();
    }

    @Nullable
    public ISoundFactory getSwingSound() {
        return SOUND_LIBRARY.getSoundFactory(this.swingSound).orElse(null);
    }

    static {
        BY_NAME = Arrays.stream(ItemClassType.values()).collect(Collectors.toMap(ItemClassType::getName, category -> category));
        CODEC = Codec.STRING.comapFlatMap(DataResult.partialGet(BY_NAME::get, () -> "unknown item class type"), d -> d.name);
        SOUND_LIBRARY = ContainerManager.resolve(ISoundLibrary.class);
    }
}

