/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.lib.IMatcher;
import org.orecruncher.dsurround.lib.IdentityUtils;
import org.orecruncher.dsurround.lib.di.ContainerManager;

public abstract class ItemTypeMatcher
implements IMatcher<class_1792> {
    public static final Codec<IMatcher<class_1792>> CODEC = Codec.STRING.comapFlatMap(ItemTypeMatcher::manifest, (Function<IMatcher, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lorg/orecruncher/dsurround/lib/IMatcher;)Ljava/lang/String;)()).stable();

    private static DataResult<IMatcher<class_1792>> manifest(String itemId) {
        try {
            class_2960 id = IdentityUtils.resolveIdentifier(itemId);
            if (itemId.startsWith("#")) {
                class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)id);
                return DataResult.success((Object)new MatchOnItemTag((class_6862<class_1792>)tagKey));
            }
            if (itemId.contains(":")) {
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
                return DataResult.success((Object)new MatchOnItem(item));
            }
            return DataResult.error(() -> String.format("Unknown item class(s) %s", itemId));
        }
        catch (Throwable t) {
            return DataResult.error(t::getMessage);
        }
    }

    @Override
    public abstract boolean match(class_1792 var1);

    private static class MatchOnItemTag
    extends ItemTypeMatcher {
        private static final ITagLibrary TAG_LIBRARY = ContainerManager.resolve(ITagLibrary.class);
        private final class_6862<class_1792> tagKey;

        public MatchOnItemTag(class_6862<class_1792> tagKey) {
            this.tagKey = tagKey;
        }

        @Override
        public boolean match(class_1792 item) {
            return TAG_LIBRARY.is(this.tagKey, item);
        }
    }

    private static class MatchOnItem
    extends ItemTypeMatcher {
        private final class_1792 item;

        MatchOnItem(class_1792 item) {
            this.item = item;
        }

        @Override
        public boolean match(class_1792 item) {
            return this.item == item;
        }
    }
}

