/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.config.data.SoundMappingConfigRule;
import org.orecruncher.dsurround.lib.IMatcher;
import org.orecruncher.dsurround.lib.collections.ObjectArray;

public record SoundMapping(class_2960 soundEvent, ObjectArray<Mapping> rules) {
    public static SoundMapping of(SoundMappingConfigRule rule) {
        ObjectArray<Mapping> mappings = new ObjectArray<Mapping>(rule.rules().size());
        rule.rules().forEach(r -> mappings.add(Mapping.of(r)));
        return new SoundMapping(rule.soundEvent(), mappings);
    }

    public boolean isBlockStateNeeded() {
        return !this.rules.isEmpty() && !this.rules.getFirst().isDefaultRule();
    }

    public Optional<class_2960> findMatch(@Nullable class_2680 state) {
        Mapping rule;
        Optional<class_2960> factory = Optional.empty();
        Iterator<Mapping> iterator = this.rules.iterator();
        while (iterator.hasNext() && !(factory = (rule = iterator.next()).findMatch(state)).isPresent()) {
        }
        return factory;
    }

    public void merge(SoundMappingConfigRule mapping) {
        if (!this.soundEvent.equals((Object)mapping.soundEvent())) {
            throw new RuntimeException("Unable to merge sound mapping rule - factories do not match");
        }
        for (SoundMappingConfigRule.MappingRule rule : mapping.rules()) {
            Mapping mapped = Mapping.of(rule);
            Optional<Mapping> existingRule = this.rules.stream().filter(r -> r.factory().equals((Object)rule.factory())).findFirst();
            if (existingRule.isPresent()) {
                if (existingRule.get().isDefaultRule()) {
                    this.insertBeforeDefaultRule(mapped);
                    continue;
                }
                existingRule.get().merge(mapped);
                continue;
            }
            Mapping last = this.rules.getLast();
            if (last.isDefaultRule()) {
                this.insertBeforeDefaultRule(mapped);
                continue;
            }
            this.rules.add(mapped);
        }
    }

    private void insertBeforeDefaultRule(Mapping mapping) {
        Mapping last = this.rules.getLast();
        if (!last.isDefaultRule()) {
            throw new RuntimeException("Last rule in sound mapping configuration is not default");
        }
        this.rules.remove(last);
        this.rules.add(mapping);
        this.rules.add(last);
    }

    public record Mapping(ObjectArray<IMatcher<class_2680>> blocks, class_2960 factory) {
        public static Mapping of(SoundMappingConfigRule.MappingRule mappingRule) {
            ObjectArray<IMatcher<class_2680>> blocks = new ObjectArray<IMatcher<class_2680>>(mappingRule.blocks().size());
            blocks.addAll((Collection<IMatcher<class_2680>>)mappingRule.blocks());
            return new Mapping(blocks, mappingRule.factory());
        }

        public Optional<class_2960> findMatch(@Nullable class_2680 state) {
            if (this.isDefaultRule()) {
                return Optional.of(this.factory);
            }
            if (state == null) {
                return Optional.empty();
            }
            for (IMatcher<class_2680> rule : this.blocks) {
                if (!rule.match(state)) continue;
                return Optional.of(this.factory);
            }
            return Optional.empty();
        }

        public boolean isDefaultRule() {
            return this.blocks.isEmpty();
        }

        public void merge(Mapping rule) {
            if (!this.factory.equals((Object)rule.factory())) {
                throw new RuntimeException("Unable to add mapping rule - factories do not match");
            }
            this.blocks.addAll((Collection<IMatcher<class_2680>>)rule.blocks());
        }
    }
}

