/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.config.BiomeTrait;
import org.orecruncher.dsurround.config.biome.biometraits.BiomeTraits;

public enum SyntheticBiome {
    NONE("none", new BiomeTrait[0]),
    INSIDE("inside", BiomeTrait.INSIDE),
    UNDERGROUND("underground", BiomeTrait.UNDERGROUND),
    PLAYER("player", BiomeTrait.PLAYER),
    VILLAGE("village", BiomeTrait.VILLAGE),
    CLOUDS("clouds", BiomeTrait.CLOUDS),
    SPACE("space", BiomeTrait.SPACE),
    UNDER_WATER("under_water", BiomeTrait.UNDER_WATER),
    UNDER_RIVER("under_river", BiomeTrait.UNDER_RIVER),
    UNDER_OCEAN("under_ocean", BiomeTrait.UNDER_OCEAN),
    UNDER_DEEP_OCEAN("under_deep_ocean", BiomeTrait.UNDER_OCEAN, BiomeTrait.DEEP);

    private static final Map<String, SyntheticBiome> lookup;
    private final String name;
    private final class_2960 id;
    private final BiomeTraits traits;

    private SyntheticBiome(String name, BiomeTrait ... traits) {
        this.name = name;
        this.id = class_2960.method_60655((String)"dsurround", (String)String.format("synthetic_biome/%s", name));
        traits = Arrays.copyOf(traits, traits.length + 1);
        traits[traits.length - 1] = BiomeTrait.SYNTHETIC;
        this.traits = BiomeTraits.from(traits);
    }

    @Nullable
    public static SyntheticBiome getByName(String name) {
        return lookup.get(name.toLowerCase());
    }

    public String getName() {
        return this.name;
    }

    public class_2960 getId() {
        return this.id;
    }

    public BiomeTraits getTraits() {
        return this.traits;
    }

    static {
        lookup = new HashMap<String, SyntheticBiome>();
        for (SyntheticBiome e : SyntheticBiome.values()) {
            if (e == NONE) continue;
            lookup.put(e.getName(), e);
        }
    }
}

