/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import java.util.Objects;
import net.minecraft.class_2960;
import org.orecruncher.dsurround.lib.random.Randomizer;

public enum WaterRippleStyle {
    NONE("none"),
    PIXELATED_CIRCLE("textures/particles/pixel_ripples.png"){
        private final int FRAMES = 7;
        private final float DELTA;
        private final int MAX_AGE;
        {
            Objects.requireNonNull(this);
            this.DELTA = 1.0f / 7.0f;
            this.MAX_AGE = this.FRAMES * 2;
        }

        @Override
        public float getU1(int age) {
            return (float)((int)((float)age / 2.0f)) * this.DELTA;
        }

        @Override
        public float getU2(int age) {
            return this.getU1(age) + this.DELTA;
        }

        @Override
        public boolean doScaling() {
            return false;
        }

        @Override
        public int getMaxAge() {
            return this.MAX_AGE;
        }
    };

    private final class_2960 resource;

    private WaterRippleStyle(String texture) {
        this.resource = class_2960.method_60655((String)"dsurround", (String)texture);
    }

    public class_2960 getTexture() {
        return this.resource;
    }

    public float getU1(int age) {
        return 0.0f;
    }

    public float getU2(int age) {
        return 1.0f;
    }

    public float getV1(int age) {
        return 0.0f;
    }

    public float getV2(int age) {
        return 1.0f;
    }

    public boolean doScaling() {
        return true;
    }

    public boolean doAlpha() {
        return true;
    }

    public int getMaxAge() {
        return 12 + Randomizer.current().method_43048(8);
    }
}

