/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config.biome;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5195;
import net.minecraft.class_5251;
import net.minecraft.class_6007;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.config.AcousticEntry;
import org.orecruncher.dsurround.config.AcousticEntryCollection;
import org.orecruncher.dsurround.config.BiomeTrait;
import org.orecruncher.dsurround.config.SoundEventType;
import org.orecruncher.dsurround.config.biome.IBiomeSoundProvider;
import org.orecruncher.dsurround.config.biome.biometraits.BiomeTraits;
import org.orecruncher.dsurround.config.data.AcousticConfig;
import org.orecruncher.dsurround.config.data.BiomeConfigRule;
import org.orecruncher.dsurround.config.libraries.ISoundLibrary;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.logging.ModLog;
import org.orecruncher.dsurround.lib.random.IRandomizer;
import org.orecruncher.dsurround.lib.registry.RegistryUtils;
import org.orecruncher.dsurround.lib.scripting.Script;
import org.orecruncher.dsurround.mixinutils.IBiomeExtended;
import org.orecruncher.dsurround.processing.fog.FogDensity;
import org.orecruncher.dsurround.runtime.IConditionEvaluator;
import org.orecruncher.dsurround.sound.ISoundFactory;

public final class BiomeInfo
implements Comparable<BiomeInfo>,
IBiomeSoundProvider {
    public static final Script DEFAULT_SOUND_CHANCE = new Script("0.008");
    private static final IModLog LOGGER = ModLog.createChild(ContainerManager.resolve(IModLog.class), "BiomeInfo");
    private static final ISoundLibrary SOUND_LIBRARY = ContainerManager.resolve(ISoundLibrary.class);
    private static final ITagLibrary TAG_LIBRARY = ContainerManager.resolve(ITagLibrary.class);
    private static final IConditionEvaluator CONDITION_EVALUATOR = ContainerManager.resolve(IConditionEvaluator.class);
    private final int version;
    private final class_2960 biomeId;
    private final String biomeName;
    private final Optional<class_1959> biome;
    private final BiomeTraits traits;
    private final boolean isRiver;
    private final boolean isOcean;
    private final boolean isDeepOcean;
    private final boolean isCave;
    private AcousticEntryCollection loopSounds = new AcousticEntryCollection();
    private AcousticEntryCollection moodSounds = new AcousticEntryCollection();
    private AcousticEntryCollection additionalSounds = new AcousticEntryCollection();
    private AcousticEntryCollection musicSounds = new AcousticEntryCollection();
    private Collection<String> comments = new ObjectArray<String>();
    private class_5251 fogColor;
    private FogDensity fogDensity;
    private Script additionalSoundChance = DEFAULT_SOUND_CHANCE;
    private Script moodSoundChance = DEFAULT_SOUND_CHANCE;

    public BiomeInfo(int version, class_2960 id, String name, BiomeTraits traits) {
        this(version, id, name, traits, null);
    }

    public BiomeInfo(int version, class_2960 id, String name, BiomeTraits traits, class_1959 biome) {
        this.version = version;
        this.biomeId = id;
        this.biomeName = name;
        this.biome = Optional.ofNullable(biome);
        this.traits = traits;
        this.isRiver = this.traits.contains(BiomeTrait.RIVER);
        this.isOcean = this.traits.contains(BiomeTrait.OCEAN);
        this.isDeepOcean = this.isOcean && this.traits.contains(BiomeTrait.DEEP);
        this.isCave = this.traits.contains(BiomeTrait.CAVES);
        this.fogDensity = FogDensity.NONE;
        if (biome != null) {
            IBiomeExtended accessor = (IBiomeExtended)biome;
            accessor.dsurround_getSpecialEffects().method_27345().ifPresent(m -> {
                ISoundFactory factory = SOUND_LIBRARY.getSoundFactoryForMusic((class_5195)m);
                AcousticEntry entry = new AcousticEntry(factory, null);
                this.musicSounds.add(entry);
            });
        }
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isRiver() {
        return this.isRiver;
    }

    public boolean isOcean() {
        return this.isOcean;
    }

    public boolean isDeepOcean() {
        return this.isDeepOcean;
    }

    public boolean isCave() {
        return this.isCave;
    }

    public class_2960 getBiomeId() {
        return this.biomeId;
    }

    void addComment(String comment) {
        if (!StringUtils.isEmpty((CharSequence)comment)) {
            this.comments.add(comment);
        }
    }

    public String getBiomeName() {
        return this.biomeName;
    }

    public class_5251 getFogColor() {
        return this.fogColor;
    }

    void setFogColor(class_5251 color) {
        this.fogColor = color;
    }

    public FogDensity getFogDensity() {
        return this.fogDensity;
    }

    public void setFogDensity(FogDensity density) {
        this.fogDensity = density;
    }

    void setAdditionalSoundChance(Script chance) {
        this.additionalSoundChance = chance;
    }

    void setMoodSoundChance(Script chance) {
        this.moodSoundChance = chance;
    }

    public BiomeTraits getTraits() {
        return this.traits;
    }

    public void mergeTraits(BiomeConfigRule configRule) {
        this.traits.mergeTraits(configRule.traits());
        configRule.comment().ifPresent(this::addComment);
    }

    public boolean hasTrait(String trait) {
        return this.traits.contains(trait);
    }

    @Override
    public Collection<ISoundFactory> findBiomeSoundMatches() {
        return this.loopSounds.findMatches().map(AcousticEntry::getAcoustic).collect(Collectors.toList());
    }

    @Override
    public Optional<ISoundFactory> getExtraSound(SoundEventType type, IRandomizer random) {
        @Nullable AcousticEntryCollection sourceList = null;
        switch (type) {
            case ADDITION: {
                Object chance = CONDITION_EVALUATOR.eval(this.additionalSoundChance);
                if (!(chance instanceof Double)) break;
                Double c = (Double)chance;
                sourceList = random.method_43058() < c ? this.additionalSounds : null;
                break;
            }
            case MOOD: {
                Object chance = CONDITION_EVALUATOR.eval(this.moodSoundChance);
                if (!(chance instanceof Double)) break;
                Double c = (Double)chance;
                sourceList = random.method_43058() < c ? this.moodSounds : null;
                break;
            }
            case MUSIC: {
                sourceList = this.musicSounds;
            }
        }
        return sourceList == null ? Optional.empty() : sourceList.makeSelection();
    }

    @Override
    public Optional<class_5195> getBackgroundMusic(IRandomizer random) {
        return this.getExtraSound(SoundEventType.MUSIC, random).map(ISoundFactory::createAsMusic);
    }

    void clearSounds() {
        this.loopSounds.clear();
        this.additionalSounds.clear();
        this.musicSounds.clear();
        this.moodSounds.clear();
        this.moodSoundChance = DEFAULT_SOUND_CHANCE;
        this.additionalSoundChance = DEFAULT_SOUND_CHANCE;
    }

    public void update(BiomeConfigRule entry) {
        entry.comment().ifPresent(this::addComment);
        entry.fogColor().ifPresent(this::setFogColor);
        entry.fogDensity().ifPresent(this::setFogDensity);
        entry.additionalSoundChance().ifPresent(this::setAdditionalSoundChance);
        entry.moodSoundChance().ifPresent(this::setMoodSoundChance);
        if (entry.clearSounds()) {
            this.addComment("> Sound Clear");
            this.clearSounds();
        }
        for (AcousticConfig sr : entry.acoustics()) {
            ISoundFactory factory = SOUND_LIBRARY.getSoundFactoryOrDefault(sr.factory());
            AcousticEntryCollection targetCollection = null;
            AcousticEntry acousticEntry = null;
            switch (sr.type()) {
                case LOOP: {
                    acousticEntry = new AcousticEntry(factory, sr.conditions());
                    targetCollection = this.loopSounds;
                    break;
                }
                case ADDITION: 
                case MOOD: 
                case MUSIC: {
                    class_6007 weight = sr.weight();
                    acousticEntry = new AcousticEntry(factory, sr.conditions(), weight);
                    if (sr.type() == SoundEventType.ADDITION) {
                        targetCollection = this.additionalSounds;
                        break;
                    }
                    if (sr.type() == SoundEventType.MOOD) {
                        targetCollection = this.moodSounds;
                        break;
                    }
                    targetCollection = this.musicSounds;
                    break;
                }
                default: {
                    LOGGER.warn("[%s] Unknown SoundEventType %s", new Object[]{this.getBiomeName(), sr.type()});
                }
            }
            if (targetCollection == null || targetCollection.add(acousticEntry)) continue;
            LOGGER.warn("[%s] Duplicate acoustic entry: %s", this.getBiomeName(), sr.toString());
        }
    }

    public void trim() {
        if (this.loopSounds.isEmpty()) {
            this.loopSounds = AcousticEntryCollection.EMPTY;
        }
        if (this.moodSounds.isEmpty()) {
            this.moodSounds = AcousticEntryCollection.EMPTY;
        }
        if (this.additionalSounds.isEmpty()) {
            this.additionalSounds = AcousticEntryCollection.EMPTY;
        }
        if (this.musicSounds.isEmpty()) {
            this.musicSounds = AcousticEntryCollection.EMPTY;
        }
        if (this.comments.isEmpty()) {
            this.comments = ImmutableList.of();
        }
    }

    public String toString() {
        String indent = "    ";
        String tags = this.biome.map(b -> {
            Optional<class_6880.class_6883<class_1959>> holder = RegistryUtils.getRegistryEntry(class_7924.field_41236, b);
            if (holder.isEmpty()) {
                return "null";
            }
            return TAG_LIBRARY.asString(TAG_LIBRARY.streamTags((class_6880)holder.get()));
        }).orElse("null");
        StringBuilder builder = new StringBuilder();
        builder.append("Biome [").append(this.getBiomeName()).append('/').append(this.biomeId).append("]");
        builder.append("\nTags: ").append(tags);
        builder.append("\n").append(this.getTraits().toString());
        builder.append("\nfogDensity: ").append(this.fogDensity.getName());
        if (this.fogColor != null) {
            builder.append(", fogColor: ").append(this.fogColor.method_27723());
        }
        if (!this.loopSounds.isEmpty()) {
            builder.append("\nLOOP sounds [\n");
            builder.append(this.loopSounds.stream().map(c -> "    " + c.toString()).collect(Collectors.joining("\n")));
            builder.append("\n]");
        } else {
            builder.append("\nLOOP sounds [NONE]");
        }
        if (!this.musicSounds.isEmpty()) {
            builder.append("\nMUSIC sounds [\n");
            builder.append(this.musicSounds.stream().map(c -> "    " + c.toString()).collect(Collectors.joining("\n")));
            builder.append("\n]");
        }
        if (!this.additionalSounds.isEmpty()) {
            builder.append("\nADDITIONAL chance: ").append(this.additionalSoundChance);
            builder.append("\nADDITIONAL sounds [\n");
            builder.append(this.additionalSounds.stream().map(c -> "    " + c.toString()).collect(Collectors.joining("\n")));
            builder.append("\n]");
        }
        if (!this.moodSounds.isEmpty()) {
            builder.append("\nMOOD chance: ").append(this.additionalSoundChance);
            builder.append("\nMOOD sounds [\n");
            builder.append(this.moodSounds.stream().map(c -> "    " + c.toString()).collect(Collectors.joining("\n")));
            builder.append("\n]");
        }
        if (!this.comments.isEmpty()) {
            builder.append("\ncomments:\n");
            builder.append(this.comments.stream().map(c -> "    " + c).collect(Collectors.joining("\n")));
            builder.append('\n');
        }
        builder.append("\n");
        return builder.toString();
    }

    @Override
    public int compareTo(BiomeInfo o) {
        return this.getBiomeId().method_12833(o.getBiomeId());
    }
}

