/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config.libraries.impl;

import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2477;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.orecruncher.dsurround.config.SyntheticBiome;
import org.orecruncher.dsurround.config.biome.BiomeInfo;
import org.orecruncher.dsurround.config.biome.biometraits.BiomeTraits;
import org.orecruncher.dsurround.config.data.BiomeConfigRule;
import org.orecruncher.dsurround.config.libraries.IBiomeLibrary;
import org.orecruncher.dsurround.config.libraries.IReloadEvent;
import org.orecruncher.dsurround.lib.Guard;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.logging.ModLog;
import org.orecruncher.dsurround.lib.registry.RegistryUtils;
import org.orecruncher.dsurround.lib.resources.DiscoveredResource;
import org.orecruncher.dsurround.lib.resources.ResourceUtilities;
import org.orecruncher.dsurround.lib.scripting.Script;
import org.orecruncher.dsurround.mixinutils.IBiomeExtended;
import org.orecruncher.dsurround.runtime.BiomeConditionEvaluator;

public final class BiomeLibrary
implements IBiomeLibrary {
    private static final String FILE_NAME = "biomes.json";
    private static final Codec<List<BiomeConfigRule>> CODEC = Codec.list(BiomeConfigRule.CODEC);
    private final IModLog logger;
    private final BiomeConditionEvaluator biomeConditionEvaluator;
    private final Map<SyntheticBiome, BiomeInfo> internalBiomes = new EnumMap<SyntheticBiome, BiomeInfo>(SyntheticBiome.class);
    private final ObjectArray<BiomeConfigRule> biomeConfigs = new ObjectArray(128);
    private int version = 0;

    public BiomeLibrary(IModLog logger) {
        this.logger = ModLog.createChild(logger, "BiomeLibrary");
        this.biomeConditionEvaluator = new BiomeConditionEvaluator(this, logger);
    }

    @Override
    public void reload(ResourceUtilities resourceUtilities, IReloadEvent.Scope scope) {
        ++this.version;
        if (scope == IReloadEvent.Scope.TAGS) {
            this.logger.info("[BiomeLibrary] received tag update notification; version is now %d", this.version);
            return;
        }
        this.internalBiomes.clear();
        this.biomeConfigs.clear();
        this.biomeConditionEvaluator.reset();
        Collection<DiscoveredResource<List<BiomeConfigRule>>> findResults = resourceUtilities.findModResources(CODEC, FILE_NAME);
        findResults.forEach(result -> this.biomeConfigs.addAll((Collection)result.resourceContent()));
        this.biomeConfigs.sort(Comparator.comparingInt(BiomeConfigRule::priority));
        for (SyntheticBiome b : SyntheticBiome.values()) {
            this.initializeSyntheticBiome(b);
        }
        this.logger.info("[BiomeLibrary] %d biome configs loaded; version is now %d", this.biomeConfigs.size(), this.version);
    }

    private void initializeSyntheticBiome(SyntheticBiome biome) {
        String match = "@" + biome.getName();
        BiomeInfo info = new BiomeInfo(this.version, biome.getId(), biome.getName(), biome.getTraits());
        for (BiomeConfigRule c : this.biomeConfigs) {
            if (!c.biomeSelector().asString().equalsIgnoreCase(match)) continue;
            info.update(c);
        }
        this.internalBiomes.put(biome, info);
    }

    private static class_2378<class_1959> getActiveRegistry() {
        return RegistryUtils.getRegistry(class_7924.field_41236).orElseThrow();
    }

    @Override
    public BiomeInfo getBiomeInfo(class_1959 biome) {
        String name;
        class_2960 id;
        BiomeInfo info = ((IBiomeExtended)biome).dsurround_getInfo();
        if (info != null && info.getVersion() == this.version) {
            return info;
        }
        if (info != null) {
            id = info.getBiomeId();
            name = info.getBiomeName();
        } else {
            id = BiomeLibrary.getBiomeId(biome);
            name = this.getBiomeName(id);
        }
        BiomeTraits traits = BiomeTraits.createFrom(id, biome);
        BiomeInfo result = new BiomeInfo(this.version, id, name, traits, biome);
        ((IBiomeExtended)biome).dsurround_setInfo(result);
        this.applyTraits(biome, result);
        Guard.execute(() -> this.applyRuleConfigs(biome, result));
        return result;
    }

    @Override
    public BiomeInfo getBiomeInfo(SyntheticBiome biome) {
        return this.internalBiomes.get((Object)biome);
    }

    @Override
    public Object eval(class_1959 biome, Script script) {
        BiomeInfo info = this.getBiomeInfo(biome);
        return this.biomeConditionEvaluator.eval(biome, info, script);
    }

    private void applyTraits(class_1959 biome, BiomeInfo info) {
        this.getNonSyntheticBiomeRules(rule -> !rule.traits().isEmpty()).forEach(rule -> {
            try {
                boolean applies = this.biomeConditionEvaluator.check(biome, info, rule.biomeSelector());
                if (applies) {
                    info.mergeTraits((BiomeConfigRule)rule);
                }
            }
            catch (Exception ex) {
                this.logger.warn("Unable to apply traits from [%s]", rule.toString());
            }
        });
    }

    private void applyRuleConfigs(class_1959 biome, BiomeInfo info) {
        this.getNonSyntheticBiomeRules(rule -> rule.traits().isEmpty()).forEach(rule -> {
            try {
                boolean applies = this.biomeConditionEvaluator.check(biome, info, rule.biomeSelector());
                if (applies) {
                    try {
                        info.update((BiomeConfigRule)rule);
                    }
                    catch (Throwable t) {
                        this.logger.warn("Unable to process biome sound configuration [%s]", rule.toString());
                    }
                }
            }
            catch (Throwable t) {
                this.logger.error(t, "Unexpected error processing biome %s", info.getBiomeId());
            }
        });
        info.trim();
    }

    private Stream<BiomeConfigRule> getNonSyntheticBiomeRules(Predicate<BiomeConfigRule> filter) {
        return this.biomeConfigs.stream().filter(c -> !c.biomeSelector().asString().startsWith("@")).filter(filter);
    }

    private static class_2960 getBiomeId(class_1959 biome) {
        return RegistryUtils.getRegistryEntry(class_7924.field_41236, biome).map(holder -> ((class_5321)holder.method_40230().orElseThrow()).method_29177()).orElseThrow();
    }

    @Override
    public String getBiomeName(class_2960 id) {
        String fmt = String.format("biome.%s.%s", id.method_12836(), id.method_12832());
        return class_2477.method_10517().method_48307(fmt);
    }

    @Override
    public Stream<String> dump() {
        Stream<String> realBiomes = BiomeLibrary.getActiveRegistry().method_10220().map(this::getBiomeInfo).map(BiomeInfo::toString).sorted();
        Stream<String> fakeBiomes = this.internalBiomes.values().stream().map(BiomeInfo::toString).sorted();
        return Stream.of(realBiomes, fakeBiomes).flatMap(Function.identity());
    }
}

