/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config.libraries.impl;

import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.orecruncher.dsurround.config.block.BlockInfo;
import org.orecruncher.dsurround.config.data.BlockConfigRule;
import org.orecruncher.dsurround.config.libraries.IBlockLibrary;
import org.orecruncher.dsurround.config.libraries.IReloadEvent;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.logging.ModLog;
import org.orecruncher.dsurround.lib.platform.IMinecraftDirectories;
import org.orecruncher.dsurround.lib.registry.RegistryUtils;
import org.orecruncher.dsurround.lib.resources.DiscoveredResource;
import org.orecruncher.dsurround.lib.resources.ResourceUtilities;
import org.orecruncher.dsurround.mixinutils.IBlockStateExtended;

public class BlockLibrary
implements IBlockLibrary {
    private static final String FILE_NAME = "blocks.json";
    private static final Codec<List<BlockConfigRule>> CODEC = Codec.list(BlockConfigRule.CODEC);
    private static final int INDEFINITE = -1;
    private static final BlockInfo DEFAULT = new BlockInfo(-1){

        @Override
        public boolean isDefault() {
            return true;
        }
    };
    private final IModLog logger;
    private final IMinecraftDirectories directories;
    private final ITagLibrary tagLibrary;
    private final Collection<BlockConfigRule> blockConfigs = new ObjectArray<BlockConfigRule>();
    private int version = 0;

    public BlockLibrary(IModLog logger, IMinecraftDirectories directories, ITagLibrary tagLibrary) {
        this.logger = ModLog.createChild(logger, "BlockLibrary");
        this.directories = directories;
        this.tagLibrary = tagLibrary;
    }

    @Override
    public void reload(ResourceUtilities resourceUtilities, IReloadEvent.Scope scope) {
        ++this.version;
        if (scope == IReloadEvent.Scope.TAGS) {
            this.logger.info("[BlockLibrary] received tag update notification; version is now %d", this.version);
            return;
        }
        this.blockConfigs.clear();
        Collection<DiscoveredResource<List<BlockConfigRule>>> findResults = resourceUtilities.findModResources(CODEC, FILE_NAME);
        findResults.forEach(result -> this.blockConfigs.addAll((Collection)result.resourceContent()));
        this.logger.info("[BlockLibrary] %d block configs loaded; version is now %d", this.blockConfigs.size(), this.version);
    }

    @Override
    public BlockInfo getBlockInfoWeak(class_2680 state) {
        BlockInfo info = ((IBlockStateExtended)state).dsurround_getBlockInfo();
        return info != null ? info : DEFAULT;
    }

    @Override
    public BlockInfo getBlockInfo(class_2680 state) {
        BlockInfo info = ((IBlockStateExtended)state).dsurround_getBlockInfo();
        if (info != null && (info.getVersion() == this.version || info == DEFAULT)) {
            return info;
        }
        info = new BlockInfo(this.version, state);
        this.blockConfigs.stream().filter(c -> c.match(state)).forEach(info::update);
        if (info.isDefault()) {
            info = DEFAULT;
        } else {
            info.trim();
        }
        ((IBlockStateExtended)state).dsurround_setBlockInfo(info);
        return info;
    }

    @Override
    public Stream<String> dumpBlockStates() {
        return RegistryUtils.getRegistry(class_7924.field_41254).orElseThrow().method_10220().flatMap(block -> block.method_9595().method_11662().stream()).map(class_2688::toString).sorted();
    }

    @Override
    public Stream<String> dumpBlockConfigRules() {
        return this.blockConfigs.stream().map(BlockLibrary::formatBlockConfigRuleOutput).sorted();
    }

    @Override
    public Stream<String> dumpBlocks(boolean noStates) {
        class_2378 blockRegistry = RegistryUtils.getRegistry(class_7924.field_41254).orElseThrow();
        Set entrySet = blockRegistry.method_29722();
        return entrySet.stream().map(kvp -> this.formatBlockOutput(((class_5321)kvp.getKey()).method_29177(), (class_2248)kvp.getValue(), noStates)).sorted();
    }

    @Override
    public Stream<String> dump() {
        return this.tagLibrary.getEntriesByTag(class_7924.field_41254).map(pair -> BlockLibrary.formatBlockTagOutput((class_6862<class_2248>)((class_6862)pair.key()), (Set)pair.value())).sorted();
    }

    private static String formatBlockConfigRuleOutput(BlockConfigRule rule) {
        return rule.toString();
    }

    private static String formatBlockTagOutput(class_6862<class_2248> blockTag, Set<class_2248> blocks) {
        class_2378 blockRegistry = RegistryUtils.getRegistry(class_7924.field_41254).orElseThrow();
        StringBuilder builder = new StringBuilder();
        builder.append("Tag: ").append(blockTag.comp_327());
        blocks.stream().map(b -> Objects.requireNonNull(blockRegistry.method_10221(b)).toString()).sorted().forEach(tag -> builder.append("\n  ").append((String)tag));
        builder.append("\n");
        return builder.toString();
    }

    private String formatBlockOutput(class_2960 id, class_2248 block, boolean noStates) {
        class_6880.class_6883<class_2248> entry = RegistryUtils.getRegistryEntry(class_7924.field_41254, block).orElseThrow();
        Stream t = this.tagLibrary.streamTags(entry);
        String tags = this.tagLibrary.asString(t);
        StringBuilder builder = new StringBuilder();
        builder.append(id.toString());
        builder.append("\nTags: ").append(tags);
        BlockInfo info = this.getBlockInfo(block.method_9564());
        builder.append("\nreflectance: ").append(info.getSoundReflectivity());
        builder.append("; occlusion: ").append(info.getSoundOcclusion());
        if (!noStates) {
            builder.append("\nstates [\n");
            for (class_2680 blockState : block.method_9595().method_11662()) {
                builder.append("  ").append(blockState.toString()).append("\n");
            }
            builder.append("]");
        }
        builder.append("\n");
        return builder.toString();
    }
}

