/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config.libraries.impl;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import org.orecruncher.dsurround.config.EntityEffectType;
import org.orecruncher.dsurround.config.libraries.IEntityEffectLibrary;
import org.orecruncher.dsurround.config.libraries.IReloadEvent;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.effects.IEntityEffect;
import org.orecruncher.dsurround.effects.entity.EntityEffectInfo;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.logging.ModLog;
import org.orecruncher.dsurround.lib.resources.ResourceUtilities;
import org.orecruncher.dsurround.mixinutils.ILivingEntityExtended;
import org.orecruncher.dsurround.tags.EntityEffectTags;

public class EntityEffectLibrary
implements IEntityEffectLibrary {
    private final ITagLibrary tagLibrary;
    private final IModLog logger;
    private final Reference2ObjectOpenHashMap<class_1299<?>, Set<EntityEffectType>> entityEffects = new Reference2ObjectOpenHashMap();
    private EntityEffectInfo defaultInfo;
    private int version;

    public EntityEffectLibrary(ITagLibrary tagLibrary, IModLog logger) {
        this.tagLibrary = tagLibrary;
        this.logger = ModLog.createChild(logger, "EntityEffectLibrary");
    }

    @Override
    public void reload(ResourceUtilities resourceUtilities, IReloadEvent.Scope scope) {
        ++this.version;
        if (scope == IReloadEvent.Scope.TAGS) {
            this.logger.info("[EntityEffectLibrary] received tag update notification; version is now %d", this.version);
            return;
        }
        this.entityEffects.clear();
        this.defaultInfo = EntityEffectInfo.createDefault(this.version);
        this.logger.info("[EntityEffectLibrary] Configured; version is now %d", this.version);
    }

    @Override
    public Stream<String> dump() {
        return Stream.of(new String[0]);
    }

    @Override
    public boolean doesEntityEffectInfoExist(class_1309 entity) {
        ILivingEntityExtended accessor = (ILivingEntityExtended)entity;
        return accessor.dsurround_getEffectInfo() != null;
    }

    @Override
    public void clearEntityEffectInfo(class_1309 entity) {
        ILivingEntityExtended accessor = (ILivingEntityExtended)entity;
        accessor.dsurround_setEffectInfo(null);
    }

    @Override
    public EntityEffectInfo getEntityEffectInfo(class_1309 entity) {
        Set types;
        List<IEntityEffect> effects;
        ILivingEntityExtended accessor = (ILivingEntityExtended)entity;
        EntityEffectInfo info = accessor.dsurround_getEffectInfo();
        if (info != null && info.getVersion() == this.version) {
            return info;
        }
        if (info != null) {
            info.deactivate();
        }
        info = !(effects = (types = (Set)this.entityEffects.computeIfAbsent((Object)entity.method_5864(), this::gatherEffectsFromConfigRules)).stream().map(e -> e.produce(entity)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).isEmpty() ? new EntityEffectInfo(this.version, entity, effects) : this.defaultInfo;
        accessor.dsurround_setEffectInfo(info);
        info.activate();
        return info;
    }

    private Set<EntityEffectType> gatherEffectsFromConfigRules(class_1299<?> entityType) {
        ReferenceOpenHashSet effectTypes = new ReferenceOpenHashSet();
        if (this.tagLibrary.is(EntityEffectTags.BOW_PULL, entityType)) {
            effectTypes.add(EntityEffectType.BOW_PULL);
        }
        if (this.tagLibrary.is(EntityEffectTags.FROST_BREATH, entityType)) {
            effectTypes.add(EntityEffectType.FROST_BREATH);
        }
        if (this.tagLibrary.is(EntityEffectTags.ITEM_SWING, entityType)) {
            effectTypes.add(EntityEffectType.ITEM_SWING);
        }
        if (this.tagLibrary.is(EntityEffectTags.TOOLBAR, entityType)) {
            effectTypes.add(EntityEffectType.PLAYER_TOOLBAR);
        }
        if (this.tagLibrary.is(EntityEffectTags.BRUSH_STEP, entityType)) {
            effectTypes.add(EntityEffectType.BRUSH_STEP);
        }
        return effectTypes;
    }
}

