/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config.libraries.impl;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5151;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.config.ItemClassType;
import org.orecruncher.dsurround.config.libraries.IItemLibrary;
import org.orecruncher.dsurround.config.libraries.IReloadEvent;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.logging.ModLog;
import org.orecruncher.dsurround.lib.registry.RegistryUtils;
import org.orecruncher.dsurround.lib.resources.ResourceUtilities;
import org.orecruncher.dsurround.sound.ISoundFactory;
import org.orecruncher.dsurround.sound.SoundFactoryBuilder;
import org.orecruncher.dsurround.tags.ItemEffectTags;
import org.orecruncher.dsurround.tags.ItemTags;

public class ItemLibrary
implements IItemLibrary {
    private final ITagLibrary tagLibrary;
    private final IModLog logger;
    private final Configuration config;
    private final Reference2ObjectOpenHashMap<class_1792, ISoundFactory> itemEquipFactories = new Reference2ObjectOpenHashMap();
    private final Reference2ObjectOpenHashMap<class_1792, ISoundFactory> itemSwingFactories = new Reference2ObjectOpenHashMap();
    private final Reference2ObjectOpenHashMap<class_1792, ISoundFactory> itemArmorStepFactories = new Reference2ObjectOpenHashMap();
    private int version;

    public ItemLibrary(ITagLibrary tagLibrary, Configuration config, IModLog logger) {
        this.tagLibrary = tagLibrary;
        this.logger = ModLog.createChild(logger, "ItemLibrary");
        this.config = config;
    }

    @Override
    public void reload(ResourceUtilities resourceUtilities, IReloadEvent.Scope scope) {
        if (scope != IReloadEvent.Scope.RESOURCES) {
            ++this.version;
            this.itemEquipFactories.clear();
            this.itemSwingFactories.clear();
            this.itemArmorStepFactories.clear();
            this.logger.info("[ItemLibrary] Configured; version is now %d", this.version);
        }
    }

    @Override
    public Optional<ISoundFactory> getItemEquipSound(class_1799 stack) {
        if (stack.method_7960()) {
            return Optional.empty();
        }
        return Optional.ofNullable((ISoundFactory)this.itemEquipFactories.computeIfAbsent((Object)stack.method_7909(), k -> this.resolve(stack, ItemClassType::getToolBarSound, ItemClassType.NONE::getToolBarSound)));
    }

    @Override
    public Optional<ISoundFactory> getItemSwingSound(class_1799 stack) {
        if (stack.method_7960()) {
            return Optional.empty();
        }
        return Optional.ofNullable((ISoundFactory)this.itemSwingFactories.computeIfAbsent((Object)stack.method_7909(), k -> this.resolve(stack, ItemClassType::getSwingSound, () -> null)));
    }

    @Override
    public Optional<ISoundFactory> getEquipableStepAccentSound(class_1799 stack) {
        if (stack.method_7960()) {
            return Optional.empty();
        }
        return Optional.ofNullable((ISoundFactory)this.itemArmorStepFactories.computeIfAbsent((Object)stack.method_7909(), k -> ItemLibrary.resolveEquipableStepSound(stack)));
    }

    @Override
    public Stream<String> dump() {
        Set itemRegistry = RegistryUtils.getRegistry(class_7924.field_41197).map(class_2378::method_29722).orElseThrow();
        return itemRegistry.stream().map(kvp -> this.formatItemOutput(((class_5321)kvp.getKey()).method_29177(), (class_1792)kvp.getValue())).sorted();
    }

    @Nullable
    private static ISoundFactory resolveEquipableStepSound(class_1799 stack) {
        class_3414 sound = ItemLibrary.getEquipableSoundEvent(stack);
        if (sound != null) {
            return SoundFactoryBuilder.create(sound).category(class_3419.field_15248).volume(0.07f).pitch(0.8f, 1.0f).build();
        }
        return null;
    }

    @Nullable
    private ISoundFactory resolve(class_1799 stack, Function<ItemClassType, ISoundFactory> resolveSound, Supplier<ISoundFactory> defaultSoundFactory) {
        ItemClassType itemClassType = this.resolveClassType(stack);
        if (itemClassType == ItemClassType.NONE) {
            class_3414 itemEquipSound = this.getSoundEvent(stack);
            if (itemEquipSound != null) {
                return SoundFactoryBuilder.create(itemEquipSound).category(class_3419.field_15248).volume(0.25f).pitch(0.8f, 1.2f).build();
            }
            return defaultSoundFactory.get();
        }
        return resolveSound.apply(itemClassType);
    }

    @Nullable
    private static class_3414 getEquipableSoundEvent(class_1799 stack) {
        class_3414 itemEquipSound = null;
        class_5151 equipable = class_5151.method_48957((class_1799)stack);
        if (equipable != null) {
            itemEquipSound = (class_3414)equipable.method_31570().comp_349();
        }
        return itemEquipSound;
    }

    @Nullable
    private class_3414 getSoundEvent(class_1799 stack) {
        class_1792 item;
        class_3414 itemEquipSound = ItemLibrary.getEquipableSoundEvent(stack);
        if (itemEquipSound != null) {
            return itemEquipSound;
        }
        if (this.config.entityEffects.enableToolbarBlockSounds && (item = stack.method_7909()) instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            class_2498 soundType = blockItem.method_7711().method_9564().method_26231();
            itemEquipSound = soundType.method_10594();
        }
        if (itemEquipSound != null) {
            return itemEquipSound;
        }
        if (this.tagLibrary.is(ItemTags.LAVA_BUCKETS, stack)) {
            itemEquipSound = class_3417.field_15202;
        } else if (this.tagLibrary.is(ItemTags.WATER_BUCKETS, stack)) {
            itemEquipSound = class_3417.field_15126;
        } else if (this.tagLibrary.is(ItemTags.ENTITY_WATER_BUCKETS, stack)) {
            itemEquipSound = class_3417.field_14568;
        } else if (this.tagLibrary.is(ItemTags.MILK_BUCKETS, stack)) {
            itemEquipSound = class_3417.field_15126;
        }
        return itemEquipSound;
    }

    private ItemClassType resolveClassType(class_1799 stack) {
        if (this.tagLibrary.is(ItemEffectTags.AXES, stack)) {
            return ItemClassType.AXE;
        }
        if (this.tagLibrary.is(ItemEffectTags.BOOKS, stack)) {
            return ItemClassType.BOOK;
        }
        if (this.tagLibrary.is(ItemEffectTags.BOWS, stack)) {
            return ItemClassType.BOW;
        }
        if (this.tagLibrary.is(ItemEffectTags.POTIONS, stack)) {
            return ItemClassType.POTION;
        }
        if (this.tagLibrary.is(ItemEffectTags.CROSSBOWS, stack)) {
            return ItemClassType.CROSSBOW;
        }
        if (this.tagLibrary.is(ItemEffectTags.SHIELDS, stack)) {
            return ItemClassType.SHIELD;
        }
        if (this.tagLibrary.is(ItemEffectTags.SWORDS, stack)) {
            return ItemClassType.SWORD;
        }
        if (this.tagLibrary.is(ItemEffectTags.TOOLS, stack)) {
            return ItemClassType.TOOL;
        }
        return ItemClassType.NONE;
    }

    private String formatItemOutput(class_2960 id, class_1792 item) {
        String tags = RegistryUtils.getRegistryEntry(class_7924.field_41197, item).map(e -> {
            Stream t = this.tagLibrary.streamTags(e);
            return this.tagLibrary.asString(t);
        }).orElse("null");
        return id.toString() + "\nTags: " + tags + "\n";
    }
}

