/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config.libraries.impl;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1113;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5195;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.config.IndividualSoundConfigEntry;
import org.orecruncher.dsurround.config.SoundMapping;
import org.orecruncher.dsurround.config.data.SoundMappingConfigRule;
import org.orecruncher.dsurround.config.data.SoundMetadataConfig;
import org.orecruncher.dsurround.config.libraries.IReloadEvent;
import org.orecruncher.dsurround.config.libraries.ISoundLibrary;
import org.orecruncher.dsurround.gui.sound.ConfigSoundInstance;
import org.orecruncher.dsurround.lib.CodecExtensions;
import org.orecruncher.dsurround.lib.Comparers;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.logging.ModLog;
import org.orecruncher.dsurround.lib.platform.IMinecraftDirectories;
import org.orecruncher.dsurround.lib.random.Randomizer;
import org.orecruncher.dsurround.lib.resources.DiscoveredResource;
import org.orecruncher.dsurround.lib.resources.ResourceUtilities;
import org.orecruncher.dsurround.sound.ISoundFactory;
import org.orecruncher.dsurround.sound.SoundFactory;
import org.orecruncher.dsurround.sound.SoundFactoryBuilder;
import org.orecruncher.dsurround.sound.SoundMetadata;

public final class SoundLibrary
implements ISoundLibrary {
    private static final String SOUNDS_JSON = "sounds.json";
    private static final String FACTORY_JSON = "sound_factories.json";
    private static final String SOUND_CONFIG_FILE = "soundconfig.json";
    private static final String SOUND_MAPPING_JSON = "sound_mappings.json";
    private static final UnboundedMapCodec<String, SoundMetadataConfig> SOUND_FILE_CODEC = Codec.unboundedMap((Codec)Codec.STRING, SoundMetadataConfig.CODEC);
    private static final Codec<List<SoundFactory>> FACTORY_FILE_CODEC = Codec.list(SoundFactory.CODEC);
    private static final Codec<List<IndividualSoundConfigEntry>> SOUND_CONFIG_CODEC = Codec.list(IndividualSoundConfigEntry.CODEC);
    private static final Codec<List<SoundMappingConfigRule>> SOUND_MAPPING_CODEC = Codec.list(SoundMappingConfigRule.CODEC);
    private static final class_2960 MISSING_RESOURCE = class_2960.method_60655((String)"dsurround", (String)"missing_sound");
    private static final class_3414 MISSING = class_3414.method_47908((class_2960)MISSING_RESOURCE);
    private static final class_2960 THUNDER_SOUND = class_3417.field_14865.method_14833();
    private static final Set<String> SOUND_REMAP_BLOCKED_MOBS = ImmutableSet.of((Object)"creeper");
    private static final class_2338.class_2339 MUTABLE_BLOCK_POS = new class_2338.class_2339();
    private final IModLog logger;
    private final Configuration config;
    private final Path soundConfigPath;
    private final Object2ObjectOpenHashMap<class_2960, class_3414> myRegistry = new Object2ObjectOpenHashMap();
    private final Object2ObjectOpenHashMap<class_2960, SoundMetadata> soundMetadata = new Object2ObjectOpenHashMap();
    private final Map<class_2960, IndividualSoundConfigEntry> individualSoundConfiguration = new Object2ObjectOpenHashMap();
    private final Map<class_2960, ISoundFactory> soundFactories = new Object2ObjectOpenHashMap();
    private final Set<class_2960> blockedSounds = new ObjectOpenHashSet();
    private final Set<class_2960> culledSounds = new ObjectOpenHashSet();
    private final List<class_2960> startupSounds = new ArrayList<class_2960>();
    private final Map<class_2960, SoundMapping> soundRemappings = new Object2ObjectOpenHashMap();
    private List<IndividualSoundConfigEntry> soundConfiguration = new ArrayList<IndividualSoundConfigEntry>();

    public SoundLibrary(Configuration config, IModLog logger, IMinecraftDirectories directories) {
        this.logger = ModLog.createChild(logger, "SoundLibrary");
        this.config = config;
        this.myRegistry.defaultReturnValue((Object)MISSING);
        this.soundMetadata.defaultReturnValue((Object)new SoundMetadata());
        this.soundConfigPath = directories.getModConfigDirectory().resolve(SOUND_CONFIG_FILE);
        this.loadSoundConfiguration();
    }

    @Override
    public Stream<String> dump() {
        return this.myRegistry.values().stream().sorted((c1, c2) -> Comparers.IDENTIFIER_NATURAL_COMPARABLE.compare(c1.method_14833(), c2.method_14833())).map(Object::toString);
    }

    @Override
    public void reload(ResourceUtilities resourceUtilities, IReloadEvent.Scope scope) {
        if (scope == IReloadEvent.Scope.TAGS) {
            return;
        }
        this.myRegistry.clear();
        this.soundMetadata.clear();
        this.soundFactories.clear();
        this.soundRemappings.clear();
        this.loadSoundConfiguration();
        class_7923.field_41172.forEach(se -> this.myRegistry.put((Object)se.method_14833(), se));
        Collection<DiscoveredResource<DiscoveredResource>> soundFiles = resourceUtilities.findResources(SOUND_FILE_CODEC, SOUNDS_JSON);
        soundFiles.forEach(this::registerSoundFile);
        Collection<DiscoveredResource<List<SoundFactory>>> findResults = resourceUtilities.findModResources(FACTORY_FILE_CODEC, FACTORY_JSON);
        findResults.forEach(this::registerSoundFactories);
        Collection<DiscoveredResource<List<SoundMappingConfigRule>>> soundMappings = resourceUtilities.findModResources(SOUND_MAPPING_CODEC, SOUND_MAPPING_JSON);
        soundMappings.forEach(this::registerSoundRemappings);
        this.logger.info("Number of SoundEvents cached: %d", this.myRegistry.size());
        this.logger.info("Number of factories cached: %d", this.soundFactories.size());
        this.logger.info("Number of sound remappings cached: %d", this.soundRemappings.size());
    }

    @Override
    public class_3414 getSound(String sound) {
        return this.getSound(class_2960.method_60654((String)sound));
    }

    @Override
    public class_3414 getSound(class_2960 sound) {
        Objects.requireNonNull(sound);
        class_3414 se = (class_3414)this.myRegistry.get((Object)sound);
        if (se == MISSING) {
            this.logger.warn("Unable to locate sound '%s'", sound.toString());
        }
        return se;
    }

    @Override
    public Collection<class_3414> getRegisteredSoundEvents() {
        return this.myRegistry.values();
    }

    @Override
    public SoundMetadata getSoundMetadata(class_2960 sound) {
        SoundMetadata result = (SoundMetadata)this.soundMetadata.get((Object)Objects.requireNonNull(sound));
        return result.isDefault() ? new SoundMetadata(sound) : result;
    }

    @Override
    public Optional<ISoundFactory> getSoundFactory(class_2960 factoryLocation) {
        return Optional.ofNullable(this.soundFactories.get(factoryLocation));
    }

    @Override
    public ISoundFactory getSoundFactoryOrDefault(class_2960 factoryLocation) {
        return this.soundFactories.computeIfAbsent(factoryLocation, loc -> SoundFactoryBuilder.create(loc).build());
    }

    @Override
    public ISoundFactory getSoundFactoryForMusic(class_5195 music) {
        return this.soundFactories.computeIfAbsent(((class_3414)music.method_27279().comp_349()).method_14833(), loc -> SoundFactoryBuilder.create(music).build());
    }

    @Override
    public boolean isBlocked(class_2960 sound) {
        return this.blockedSounds.contains(Objects.requireNonNull(sound));
    }

    @Override
    public boolean isCulled(class_2960 sound) {
        return this.culledSounds.contains(Objects.requireNonNull(sound));
    }

    @Override
    public float getVolumeScale(class_3419 category, class_2960 sound) {
        float scale = 1.0f;
        IndividualSoundConfigEntry entry = this.individualSoundConfiguration.get(Objects.requireNonNull(sound));
        if (entry != null && entry.isNotDefault()) {
            scale = (float)entry.volumeScale / 100.0f;
        }
        if (category == class_3419.field_15256 && sound.method_12836().equals("dsurround")) {
            scale *= (float)this.config.soundOptions.ambientVolumeScaling / 100.0f;
        }
        return scale;
    }

    @Override
    public Optional<class_3414> getRandomStartupSound() {
        if (this.startupSounds.isEmpty()) {
            return Optional.empty();
        }
        int idx = 0;
        if (this.startupSounds.size() > 1) {
            idx = Randomizer.current().method_43048(this.startupSounds.size());
        }
        return Optional.of(class_3414.method_47908((class_2960)this.startupSounds.get(idx)));
    }

    @Override
    public Collection<IndividualSoundConfigEntry> getIndividualSoundConfigs() {
        return this.soundConfiguration;
    }

    @Override
    public void saveIndividualSoundConfigs(Collection<IndividualSoundConfigEntry> configs) {
        this.blockedSounds.clear();
        this.soundConfiguration = configs.stream().filter(IndividualSoundConfigEntry::isNotDefault).collect(Collectors.toList());
        this.postProcess();
        this.save();
    }

    @Override
    public Optional<class_1113> remapSound(class_1113 soundInstance) {
        if (soundInstance instanceof ConfigSoundInstance) {
            return Optional.empty();
        }
        class_2960 soundLocation = soundInstance.method_4775();
        if (THUNDER_SOUND.equals((Object)soundLocation) ? !this.config.soundOptions.replaceThunderSounds : !this.config.soundOptions.remapSounds) {
            return Optional.empty();
        }
        SoundMapping mappingRule = this.soundRemappings.get(soundLocation);
        if (mappingRule != null) {
            Optional<ISoundFactory> soundFactory;
            class_2338 pos;
            class_638 level;
            class_2680 blockState = null;
            if (mappingRule.isBlockStateNeeded() && ((blockState = (level = GameUtils.getWorld().orElseThrow()).method_8320(pos = class_2338.method_49637((double)soundInstance.method_4784(), (double)(soundInstance.method_4779() + 0.25), (double)soundInstance.method_4778()).method_10074())).method_26215() || !blockState.method_51367())) {
                class_2350 dir;
                Iterator iterator = class_2350.class_2353.field_11062.iterator();
                while (iterator.hasNext() && ((blockState = level.method_8320((class_2338)MUTABLE_BLOCK_POS.method_25505((class_2382)pos, dir = (class_2350)iterator.next()))).method_26215() || !blockState.method_51367())) {
                }
            }
            if ((soundFactory = mappingRule.findMatch(blockState).map(this::getSoundFactoryOrDefault)).isPresent()) {
                soundInstance.method_4783(GameUtils.getSoundManager());
                float volumeScale = soundInstance.method_4781();
                return Optional.of(soundFactory.get().createAtLocation(soundInstance.method_4784(), soundInstance.method_4779(), soundInstance.method_4778(), volumeScale));
            }
        }
        return Optional.empty();
    }

    @Nullable
    private class_2960 remapMobStepSound(class_1113 soundInstance) {
        String mobType;
        class_2960 soundLocation = soundInstance.method_4775();
        String path = soundLocation.method_12832();
        if (path.startsWith("entity.") && path.endsWith("step") && !SOUND_REMAP_BLOCKED_MOBS.contains(mobType = path.substring(7, path.indexOf(46, 7)))) {
            class_638 level = GameUtils.getWorld().orElseThrow();
            class_2338 pos = class_2338.method_49637((double)soundInstance.method_4784(), (double)soundInstance.method_4779(), (double)soundInstance.method_4778()).method_10074();
            soundLocation = level.method_8320(pos).method_26231().method_10594().method_14833();
            this.logger.debug("Mob sound remapping from %s to %s", soundInstance.method_4775(), soundLocation);
            return soundLocation;
        }
        return null;
    }

    private void registerSoundFile(DiscoveredResource<Map<String, SoundMetadataConfig>> soundFile) {
        Map<String, SoundMetadataConfig> result = soundFile.resourceContent();
        result.forEach((key, value) -> {
            class_2960 loc = class_2960.method_60655((String)soundFile.namespace(), (String)key);
            if (!this.myRegistry.containsKey((Object)loc)) {
                this.myRegistry.put((Object)loc, (Object)class_3414.method_47908((class_2960)loc));
            }
            if (!value.isDefault()) {
                SoundMetadata data = new SoundMetadata(loc, (SoundMetadataConfig)value);
                this.soundMetadata.put((Object)loc, (Object)data);
            }
        });
        this.logger.debug("Registered %d sounds for namespace %s", soundFile.resourceContent().size(), soundFile.namespace());
    }

    private void registerSoundRemappings(DiscoveredResource<List<SoundMappingConfigRule>> mappings) {
        for (SoundMappingConfigRule mapping : mappings.resourceContent()) {
            if (!this.soundRemappings.containsKey(mapping.soundEvent())) {
                this.soundRemappings.put(mapping.soundEvent(), SoundMapping.of(mapping));
                continue;
            }
            SoundMapping existingMapping = this.soundRemappings.get(mapping.soundEvent());
            existingMapping.merge(mapping);
        }
        this.logger.debug("Registered %d sound remappings for namespace %s", mappings.resourceContent().size(), mappings.namespace());
    }

    private void registerSoundFactories(DiscoveredResource<List<SoundFactory>> factories) {
        factories.resourceContent().forEach(factory -> this.soundFactories.put(factory.getLocation(), (ISoundFactory)factory));
        this.logger.debug("Registered %d sound factories for namespace %s", factories.resourceContent().size(), factories.namespace());
    }

    private void loadSoundConfiguration() {
        this.soundConfiguration.clear();
        this.blockedSounds.clear();
        try {
            if (Files.exists(this.soundConfigPath, new LinkOption[0])) {
                String content = Files.readString(this.soundConfigPath);
                Optional<List<IndividualSoundConfigEntry>> result = CodecExtensions.deserialize(content, SOUND_CONFIG_CODEC);
                result.ifPresentOrElse(cfgList -> this.soundConfiguration.addAll((Collection<IndividualSoundConfigEntry>)cfgList), () -> this.logger.warn("Unable to obtain content of %s!", SOUND_CONFIG_FILE));
            } else {
                this.addSoundConfigDefaults();
            }
        }
        catch (Throwable t) {
            this.logger.error(t, "Unable to load sound configuration %s! Resetting to defaults.", SOUND_CONFIG_FILE);
            this.addSoundConfigDefaults();
        }
        this.postProcess();
        this.save();
    }

    private void addSoundConfigDefaults() {
        this.addSoundConfig("minecraft:entity.sheep.ambient", 100, false, true, false);
        this.addSoundConfig("minecraft:entity.chicken.ambient", 100, false, true, false);
        this.addSoundConfig("minecraft:entity.cow.ambient", 100, false, true, false);
        this.addSoundConfig("minecraft:entity.pig.ambient", 100, false, true, false);
        this.addSoundConfig("minecraft:entity.llama.ambient", 100, false, true, false);
        this.addSoundConfig("minecraft:entity.wither.spawn", 10, false, true, false);
        this.addSoundConfig("minecraft:entity.wither.death", 10, false, true, false);
        this.addSoundConfig("minecraft:entity.ender_dragon.death", 10, false, true, false);
        this.addSoundConfig("minecraft:entity.experience_orb.pickup", 100, false, false, true);
        this.addSoundConfig("minecraft:entity.chicken.egg", 100, false, false, true);
        this.addSoundConfig("minecraft:ambient.underwater.exit", 100, false, false, true);
        this.addSoundConfig("minecraft:block.water.ambient", 100, true, false, false);
    }

    private void addSoundConfig(String id, int volumeScale, boolean block, boolean cull, boolean startup) {
        IndividualSoundConfigEntry entry = new IndividualSoundConfigEntry(class_2960.method_60654((String)id), volumeScale, block, cull, startup);
        this.soundConfiguration.add(entry);
    }

    private void postProcess() {
        this.soundConfiguration.removeIf(e -> !e.isNotDefault());
        this.soundConfiguration.sort((e1, e2) -> Comparers.IDENTIFIER_NATURAL_COMPARABLE.compare(e1.soundEventId, e2.soundEventId));
        this.soundConfiguration.forEach(e -> {
            this.individualSoundConfiguration.put(e.soundEventId, (IndividualSoundConfigEntry)e);
            if (e.startup) {
                this.startupSounds.add(e.soundEventId);
            }
            if (e.block || e.volumeScale == 0) {
                this.blockedSounds.add(e.soundEventId);
            }
            if (e.cull) {
                this.culledSounds.add(e.soundEventId);
            }
        });
    }

    private void save() {
        try {
            Optional<String> result = CodecExtensions.serialize(SOUND_CONFIG_CODEC, this.soundConfiguration);
            if (result.isPresent()) {
                Files.writeString(this.soundConfigPath, (CharSequence)result.get(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            }
        }
        catch (Throwable t) {
            this.logger.error(t, "Unable to save sound configuration %s!", SOUND_CONFIG_FILE);
        }
    }
}

