/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config.libraries.impl;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.orecruncher.dsurround.Constants;
import org.orecruncher.dsurround.config.libraries.IReloadEvent;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.eventing.ClientState;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.logging.ModLog;
import org.orecruncher.dsurround.lib.registry.RegistryUtils;
import org.orecruncher.dsurround.lib.resources.ClientTagLoader;
import org.orecruncher.dsurround.lib.resources.ResourceUtilities;
import org.orecruncher.dsurround.lib.system.IStopwatch;
import org.orecruncher.dsurround.lib.system.ISystemClock;
import org.orecruncher.dsurround.tags.ModTags;

public class TagLibrary
implements ITagLibrary {
    private final IModLog logger;
    private final ISystemClock systemClock;
    private final Map<class_6862<?>, Collection<class_2960>> tagCache;
    private final ClientTagLoader tagLoader;
    private boolean isConnected;

    public TagLibrary(IModLog logger, ISystemClock systemClock) {
        this.logger = ModLog.createChild(logger, "TagLibrary");
        this.systemClock = systemClock;
        this.tagCache = new Reference2ObjectOpenHashMap();
        this.tagLoader = new ClientTagLoader(ResourceUtilities.createForCurrentState(), logger, this.systemClock);
        ClientState.ON_CONNECT.register(this::onConnect);
        ClientState.ON_DISCONNECT.register(this::onDisconnect);
    }

    @Override
    public boolean is(class_6862<class_2248> tagKey, class_2680 entry) {
        if (Constants.BLOCKS_TO_IGNORE.contains(entry.method_26204())) {
            return false;
        }
        if (entry.method_26164(tagKey)) {
            return true;
        }
        class_2960 location = ((class_5321)entry.method_41520().method_40230().orElseThrow()).method_29177();
        return this.isInCache(tagKey, location);
    }

    @Override
    public boolean is(class_6862<class_1792> tagKey, class_1799 entry) {
        if (entry.method_7960()) {
            return false;
        }
        if (entry.method_31573(tagKey)) {
            return true;
        }
        class_2960 location = ((class_5321)entry.method_41409().method_40230().orElseThrow()).method_29177();
        return this.isInCache(tagKey, location);
    }

    @Override
    public boolean is(class_6862<class_1959> tagKey, class_1959 entry) {
        Optional<class_6880.class_6883<class_1959>> registryEntry = RegistryUtils.getRegistryEntry(class_7924.field_41236, entry);
        if (registryEntry.isPresent()) {
            class_6880.class_6883<class_1959> e = registryEntry.get();
            if (e.method_40220(tagKey)) {
                return true;
            }
            class_2960 location = e.method_40237().method_29177();
            return this.isInCache(tagKey, location);
        }
        return false;
    }

    @Override
    public boolean is(class_6862<class_1299<?>> tagKey, class_1299<?> entry) {
        if (entry.method_20210(tagKey)) {
            return true;
        }
        Optional<class_6880.class_6883<class_1299<?>>> registryEntry = RegistryUtils.getRegistryEntry(class_7924.field_41266, entry);
        if (registryEntry.isPresent()) {
            class_2960 location = registryEntry.get().method_40237().method_29177();
            return this.isInCache(tagKey, location);
        }
        return false;
    }

    @Override
    public boolean is(class_6862<class_3611> tagKey, class_3610 entry) {
        if (entry.method_15769()) {
            return false;
        }
        if (entry.method_15767(tagKey)) {
            return true;
        }
        Optional<class_6880.class_6883<class_3611>> registryEntry = RegistryUtils.getRegistryEntry(class_7924.field_41270, entry.method_15772());
        if (registryEntry.isPresent()) {
            class_2960 location = registryEntry.get().method_40237().method_29177();
            return this.isInCache(tagKey, location);
        }
        return false;
    }

    @Override
    public Stream<String> dump() {
        return this.tagCache.entrySet().stream().map(kvp -> {
            StringBuilder builder = new StringBuilder();
            builder.append("Tag: ").append(((class_6862)kvp.getKey()).toString());
            Collection td = (Collection)kvp.getValue();
            if (td.isEmpty()) {
                builder.append("\n*** EMPTY ***");
            } else {
                this.formatHelper(builder, "Members", this.tagLoader.getCompleteIds((class_6862)kvp.getKey()));
            }
            builder.append("\n");
            return builder.toString();
        }).sorted();
    }

    @Override
    public void reload(ResourceUtilities resourceUtilities, IReloadEvent.Scope scope) {
        this.tagLoader.setResourceUtilities(resourceUtilities);
        this.logger.info("[TagLibrary] Cache has %d elements", this.tagCache.size());
        if (this.isConnected) {
            this.initializeTagCache();
        }
    }

    @Override
    public <T> String asString(Stream<class_6862<T>> tagStream) {
        return tagStream.map(key -> key.comp_327().toString()).sorted().collect(Collectors.joining(", "));
    }

    @Override
    public <T> Stream<Pair<class_6862<T>, Set<T>>> getEntriesByTag(class_5321<? extends class_2378<T>> registryKey) {
        class_2378 registry = RegistryUtils.getRegistry(registryKey).orElseThrow();
        return registry.method_40270().flatMap(e -> this.streamTags((class_6880)e).map(tag -> Pair.of((Object)tag, (Object)e.comp_349()))).collect(Collectors.groupingBy(Pair::key, Collectors.mapping(Pair::value, Collectors.toSet()))).entrySet().stream().map(e -> Pair.of((Object)((class_6862)e.getKey()), (Object)((Set)e.getValue())));
    }

    @Override
    public <T> Stream<class_6862<T>> streamTags(class_6880<T> registryEntry) {
        class_2960 location = ((class_5321)registryEntry.method_40230().orElseThrow()).method_29177();
        Set tags = registryEntry.method_40228().collect(Collectors.toSet());
        for (Map.Entry<class_6862<?>, Collection<class_2960>> kvp : this.tagCache.entrySet()) {
            if (!kvp.getValue().contains(location)) continue;
            tags.add(kvp.getKey());
        }
        return tags.stream();
    }

    private void onConnect(class_310 client) {
        this.isConnected = true;
        this.tagLoader.setServerType(GameUtils.getServerType());
        this.initializeTagCache();
    }

    private void onDisconnect(class_310 client) {
        this.isConnected = false;
    }

    private void initializeTagCache() {
        IStopwatch stopwatch = this.systemClock.getStopwatch();
        this.logger.info("Repopulating tag cache", new Object[0]);
        this.tagCache.clear();
        this.tagLoader.clear();
        for (class_6862<?> tagKey : ModTags.getModTags()) {
            this.tagCache.computeIfAbsent(tagKey, this.tagLoader::getMembers);
        }
        this.logger.info("Tag cache initialization complete; %d tags cached, %dmillis", this.tagCache.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    private boolean isInCache(class_6862<?> tagKey, class_2960 entry) {
        if (!ModTags.getModTags().contains(tagKey)) {
            return false;
        }
        return this.tagCache.computeIfAbsent(tagKey, this.tagLoader::getMembers).contains(entry);
    }

    private void formatHelper(StringBuilder builder, String entryName, Collection<class_2960> data) {
        builder.append("\n").append(entryName).append(" ");
        if (data.isEmpty()) {
            builder.append("NONE");
        } else {
            builder.append("[");
            for (class_2960 e : data) {
                builder.append("\n  ").append(e.toString());
            }
            builder.append("\n]");
        }
    }
}

