/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.blocks;

import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_702;
import net.minecraft.class_703;
import org.orecruncher.dsurround.config.libraries.ISoundLibrary;
import org.orecruncher.dsurround.effects.IBlockEffect;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.random.IRandomizer;
import org.orecruncher.dsurround.lib.random.Randomizer;
import org.orecruncher.dsurround.mixins.core.MixinParticleManager;
import org.orecruncher.dsurround.sound.IAudioPlayer;

public abstract class AbstractBlockEffect
implements IBlockEffect {
    protected static final IRandomizer RANDOM = Randomizer.current();
    protected static final ISoundLibrary SOUND_LIBRARY = ContainerManager.resolve(ISoundLibrary.class);
    protected static final IAudioPlayer AUDIO_PLAYER = ContainerManager.resolve(IAudioPlayer.class);
    protected final class_1937 world;
    protected final double posX;
    protected final double posY;
    protected final double posZ;
    protected final class_2338 position;
    private boolean removed = false;

    protected AbstractBlockEffect(class_1937 worldIn, double posXIn, double posYIn, double posZIn) {
        this.world = worldIn;
        this.posX = posXIn;
        this.posY = posYIn;
        this.posZ = posZIn;
        this.position = class_2338.method_49637((double)posXIn, (double)posYIn, (double)posZIn);
    }

    @Override
    public class_2338 getPos() {
        return this.position;
    }

    public void addParticle(class_703 particle) {
        GameUtils.getParticleManager().method_3058(particle);
    }

    public <T extends class_2394> Optional<class_703> createParticle(T parameters, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        class_702 pm = GameUtils.getParticleManager();
        MixinParticleManager t = (MixinParticleManager)pm;
        return Optional.ofNullable(t.dsurround_createParticle(parameters, x, y, z, velocityX, velocityY, velocityZ));
    }

    @Override
    public boolean isDone() {
        return this.removed;
    }

    @Override
    public void remove() {
        this.removed = true;
        this.cleanUp();
    }

    public abstract boolean shouldRemove();

    protected void cleanUp() {
    }

    @Override
    public final void tick() {
        if (this.shouldRemove()) {
            this.remove();
            return;
        }
        this.think();
        if (!this.isDone()) {
            this.soundUpdate();
        }
    }

    protected void soundUpdate() {
    }

    public abstract void think();
}

