/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.blocks;

import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_703;
import org.orecruncher.dsurround.effects.blocks.AbstractBlockEffect;

public abstract class AbstractParticleEmitterEffect
extends AbstractBlockEffect {
    protected final int strength;
    protected final int updateFrequency;
    protected final int ageLimit;
    protected int age;

    public AbstractParticleEmitterEffect(class_1937 world, double x, double y, double z) {
        this(1, world, x, y, z);
    }

    public AbstractParticleEmitterEffect(int strength, class_1937 world, double x, double y, double z) {
        this(strength, world, x, y, z, 3);
    }

    public AbstractParticleEmitterEffect(int strength, class_1937 world, double x, double y, double z, int freq) {
        super(world, x, y, z);
        this.strength = strength;
        this.updateFrequency = freq;
        this.ageLimit = (RANDOM.method_43048(strength) + 2) * 20;
    }

    public int getStrength() {
        return this.strength;
    }

    @Override
    public boolean shouldRemove() {
        return this.age >= this.ageLimit;
    }

    @Override
    public void think() {
        if (this.age % this.updateFrequency == 0) {
            this.handleParticles();
        }
        ++this.age;
    }

    protected void handleParticles() {
        this.produceParticle().ifPresent(this::addParticle);
    }

    protected abstract Optional<class_703> produceParticle();
}

