/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.blocks;

import java.util.Optional;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1937;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2960;
import net.minecraft.class_687;
import net.minecraft.class_703;
import org.orecruncher.dsurround.effects.blocks.AbstractParticleEmitterEffect;

public class FlameJetEffect
extends AbstractParticleEmitterEffect {
    private static final class_2960 FIRE_AMBIENT = class_2960.method_60655((String)"dsurround", (String)"fire_ambient");
    protected final boolean isLava;
    protected final class_2400 particleType;
    protected final boolean isNonLiquidBlock;
    protected boolean soundFired;

    public FlameJetEffect(int strength, class_1937 world, double x, double y, double z, boolean isNonLiquidBlock) {
        super(strength, world, x, y, z);
        this.isLava = !isNonLiquidBlock && RANDOM.method_43048(3) == 0;
        this.particleType = this.isLava ? class_2398.field_11239 : class_2398.field_11240;
        this.isNonLiquidBlock = isNonLiquidBlock;
    }

    @Override
    protected void soundUpdate() {
        if (!this.soundFired) {
            this.soundFired = true;
            if (this.strength > 1) {
                SOUND_LIBRARY.getSoundFactory(FIRE_AMBIENT).ifPresent(f -> {
                    class_1109 soundInstance = f.createAtLocation(this.getPos());
                    AUDIO_PLAYER.play((class_1113)soundInstance);
                });
            }
        }
    }

    @Override
    protected Optional<class_703> produceParticle() {
        double speedY = this.isLava ? 0.0 : (double)this.strength / 10.0;
        float scale = this.strength;
        double x = this.posX;
        double z = this.posZ;
        if (this.isNonLiquidBlock) {
            x += (RANDOM.method_43058() - RANDOM.method_43058()) * 0.5;
            z += (RANDOM.method_43058() - RANDOM.method_43058()) * 0.5;
            if (this.strength == 1) {
                speedY *= 0.5;
                scale *= 0.5f;
            }
        }
        Optional<class_703> particle = this.createParticle(this.particleType, x, this.posY, z, 0.0, speedY, 0.0);
        float finalScale = scale;
        particle.ifPresent(p -> {
            if (p instanceof class_687) {
                p.method_3087(finalScale);
            }
        });
        return particle;
    }
}

