/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.blocks.producers;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import org.orecruncher.dsurround.effects.IBlockEffect;
import org.orecruncher.dsurround.effects.IBlockEffectProducer;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.random.IRandomizer;
import org.orecruncher.dsurround.lib.scripting.Script;
import org.orecruncher.dsurround.runtime.IConditionEvaluator;

public abstract class BlockEffectProducer
implements IBlockEffectProducer {
    protected final IConditionEvaluator conditionEvaluator;
    protected final Script chance;
    protected final Script conditions;
    public static final int MAX_STRENGTH = 10;

    protected BlockEffectProducer(Script chance, Script conditions) {
        this.chance = chance;
        this.conditions = conditions;
        this.conditionEvaluator = ContainerManager.resolve(IConditionEvaluator.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean canTrigger(class_1937 world, class_2680 state, class_2338 pos, IRandomizer rand) {
        if (!this.conditionEvaluator.check(this.conditions)) return false;
        Object chance = this.conditionEvaluator.eval(this.chance);
        if (!(chance instanceof Double)) return false;
        Double c = (Double)chance;
        if (!(rand.method_43058() < c)) return false;
        return true;
    }

    @Override
    public Optional<IBlockEffect> produce(class_1937 world, class_2680 state, class_2338 pos, IRandomizer rand) {
        if (this.canTrigger(world, state, pos, rand)) {
            return this.produceImpl(world, state, pos, rand);
        }
        return Optional.empty();
    }

    protected abstract Optional<IBlockEffect> produceImpl(class_1937 var1, class_2680 var2, class_2338 var3, IRandomizer var4);

    public static int countVerticalBlocks(class_1937 provider, class_2338 pos, Predicate<class_2680> predicate, int step) {
        int count;
        class_2338.class_2339 mutable = pos.method_25503();
        for (count = 0; count < 10 && predicate.test(provider.method_8320((class_2338)mutable)); ++count) {
            mutable.method_33098(mutable.method_10264() + step);
        }
        return class_3532.method_15340((int)count, (int)0, (int)10);
    }

    public static int countCubeBlocks(class_1937 provider, class_2338 pos, Predicate<class_2680> predicate, boolean fastFirst) {
        int blockCount = 0;
        for (int k = -1; k <= 1; ++k) {
            for (int j = -1; j <= 1; ++j) {
                for (int i = -1; i <= 1; ++i) {
                    class_2680 state = provider.method_8320(pos.method_10069(i, j, k));
                    if (!predicate.test(state)) continue;
                    if (fastFirst) {
                        return 1;
                    }
                    ++blockCount;
                }
            }
        }
        return blockCount;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{chance: " + String.valueOf(this.chance) + "; conditions: " + String.valueOf(this.conditions) + "}";
    }
}

