/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.blocks.producers;

import java.util.Optional;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_5431;
import org.orecruncher.dsurround.effects.BlockEffectUtils;
import org.orecruncher.dsurround.effects.IBlockEffect;
import org.orecruncher.dsurround.effects.blocks.FlameJetEffect;
import org.orecruncher.dsurround.effects.blocks.producers.BlockEffectProducer;
import org.orecruncher.dsurround.lib.random.IRandomizer;
import org.orecruncher.dsurround.lib.scripting.Script;

public class FlameJetProducer
extends BlockEffectProducer {
    public FlameJetProducer(Script chance, Script conditions) {
        super(chance, conditions);
    }

    @Override
    protected boolean canTrigger(class_1937 world, class_2680 state, class_2338 pos, IRandomizer random) {
        return world.method_8320(pos.method_10084()).method_26215() && super.canTrigger(world, state, pos, random);
    }

    @Override
    public Optional<IBlockEffect> produceImpl(class_1937 world, class_2680 state, class_2338 pos, IRandomizer random) {
        boolean isNonLiquidBlock;
        float spawnHeight;
        int blockCount;
        if (!state.method_26227().method_15769()) {
            blockCount = FlameJetProducer.countVerticalBlocks(world, pos, BlockEffectUtils.IS_LAVA, -1);
            spawnHeight = (float)pos.method_10264() + state.method_26227().method_20785() + 0.1f;
            isNonLiquidBlock = false;
        } else {
            class_265 shape = state.method_26218((class_1922)world, pos);
            if (shape.method_1110()) {
                return Optional.empty();
            }
            double blockHeight = shape.method_1107().field_1325;
            spawnHeight = (float)((double)pos.method_10264() + blockHeight);
            isNonLiquidBlock = true;
            blockCount = state.method_30368((class_1922)world, pos, class_2350.field_11036, class_5431.field_25822) ? 2 : 1;
        }
        if (blockCount > 0) {
            FlameJetEffect effect = new FlameJetEffect(blockCount, world, (double)pos.method_10263() + 0.5, (double)spawnHeight, (double)pos.method_10260() + 0.5, isNonLiquidBlock);
            return Optional.of(effect);
        }
        return Optional.empty();
    }
}

