/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.blocks.producers;

import java.util.Optional;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5431;
import org.orecruncher.dsurround.effects.BlockEffectUtils;
import org.orecruncher.dsurround.effects.IBlockEffect;
import org.orecruncher.dsurround.effects.blocks.BubbleJetEffect;
import org.orecruncher.dsurround.effects.blocks.producers.BlockEffectProducer;
import org.orecruncher.dsurround.lib.random.IRandomizer;
import org.orecruncher.dsurround.lib.scripting.Script;

public class UnderwaterBubbleProducer
extends BlockEffectProducer {
    public UnderwaterBubbleProducer(Script chance, Script conditions) {
        super(chance, conditions);
    }

    @Override
    protected boolean canTrigger(class_1937 world, class_2680 state, class_2338 pos, IRandomizer random) {
        if (BlockEffectUtils.IS_WATER.test(state)) {
            class_2338 belowPos = pos.method_10074();
            class_2680 belowBlock = world.method_8320(belowPos);
            boolean isSolidBlock = belowBlock.method_30368((class_1922)world, belowPos, class_2350.field_11036, class_5431.field_25822);
            return isSolidBlock && super.canTrigger(world, state, pos, random);
        }
        return false;
    }

    @Override
    protected Optional<IBlockEffect> produceImpl(class_1937 world, class_2680 state, class_2338 pos, IRandomizer random) {
        int liquidBlocks = UnderwaterBubbleProducer.countVerticalBlocks(world, pos, BlockEffectUtils.IS_WATER, 1);
        if (liquidBlocks > 0) {
            BubbleJetEffect effect = new BubbleJetEffect(liquidBlocks, world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.1, (double)pos.method_10260() + 0.5);
            return Optional.of(effect);
        }
        return Optional.empty();
    }
}

