/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.entity;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2680;
import net.minecraft.class_315;
import net.minecraft.class_703;
import org.orecruncher.dsurround.effects.entity.EntityEffectBase;
import org.orecruncher.dsurround.effects.entity.EntityEffectInfo;
import org.orecruncher.dsurround.effects.particles.FrostBreathParticle;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.random.MurmurHash3;
import org.orecruncher.dsurround.lib.seasons.ISeasonalInformation;
import org.orecruncher.dsurround.lib.system.ITickCount;

public class BreathEffect
extends EntityEffectBase {
    private static final ISeasonalInformation SEASONAL_INFORMATION = ContainerManager.resolve(ISeasonalInformation.class);
    private final ITickCount tickCount;
    private int seed;

    public BreathEffect(ITickCount tickCount) {
        this.tickCount = tickCount;
    }

    @Override
    public void activate(EntityEffectInfo info) {
        this.seed = info.isRemoved() ? 0 : MurmurHash3.hash(info.getEntity().method_5628()) & 0xFFFF;
    }

    @Override
    public void tick(EntityEffectInfo info) {
        if (info.isRemoved()) {
            return;
        }
        class_1309 entity = info.getEntity();
        if (!this.isBreathVisible(entity)) {
            return;
        }
        int c = (int)(this.tickCount.getTickCount() + (long)this.seed);
        class_2338 headPos = this.getHeadPosition(entity);
        class_2680 state = entity.method_37908().method_8320(headPos);
        if (this.showWaterBubbles(state)) {
            int air = entity.method_5669();
            if (air > 0) {
                int interval = c % 3;
                if (interval == 0) {
                    this.createBubbleParticle(false);
                }
            } else if (air == 0) {
                for (int i = 0; i < 8; ++i) {
                    this.createBubbleParticle(true);
                }
            }
        } else {
            int interval = c / 10 % 8;
            if (interval < 3 && this.showFrostBreath(entity, state, headPos)) {
                this.createFrostParticle(entity);
            }
        }
    }

    protected boolean isBreathVisible(class_1309 entity) {
        class_1657 player = GameUtils.getPlayer().orElseThrow();
        class_315 settings = GameUtils.getGameSettings();
        if (entity.method_5628() == player.method_5628()) {
            return !player.method_7325() && !settings.field_1842;
        }
        return !entity.method_5756(player) && player.method_6057((class_1297)entity);
    }

    protected class_2338 getHeadPosition(class_1309 entity) {
        return class_2338.method_49638((class_2374)entity.method_33571());
    }

    protected boolean showWaterBubbles(class_2680 headBlock) {
        return !headBlock.method_26227().method_15769();
    }

    protected boolean showFrostBreath(class_1309 entity, class_2680 headBlock, class_2338 pos) {
        if (headBlock.method_26215()) {
            return SEASONAL_INFORMATION.isColdTemperature(pos);
        }
        return false;
    }

    protected void createBubbleParticle(boolean isDrowning) {
    }

    protected void createFrostParticle(class_1309 entity) {
        FrostBreathParticle particle = new FrostBreathParticle(entity);
        this.addParticle((class_703)particle);
    }
}

