/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.entity;

import com.google.common.collect.ImmutableList;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.class_1309;
import org.jetbrains.annotations.NotNull;
import org.orecruncher.dsurround.effects.IEntityEffect;
import org.orecruncher.dsurround.lib.GameUtils;

public class EntityEffectInfo {
    private final WeakReference<class_1309> entity;
    private final Collection<IEntityEffect> effects;
    private final int version;

    private EntityEffectInfo(int version) {
        this(version, null, (Collection<IEntityEffect>)ImmutableList.of());
    }

    public EntityEffectInfo(int version, class_1309 entity, Collection<IEntityEffect> effects) {
        this.version = version;
        this.entity = new WeakReference<class_1309>(entity);
        this.effects = effects;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isDefault() {
        return false;
    }

    @NotNull
    public class_1309 getEntity() {
        return Objects.requireNonNull((class_1309)this.entity.get());
    }

    public void activate() {
        if (this.isRemoved()) {
            return;
        }
        for (IEntityEffect e : this.effects) {
            e.activate(this);
        }
    }

    public void deactivate() {
        for (IEntityEffect e : this.effects) {
            e.deactivate(this);
        }
    }

    public void tick() {
        if (this.isRemoved()) {
            return;
        }
        for (IEntityEffect e : this.effects) {
            e.tick(this);
        }
    }

    public Collection<IEntityEffect> getEffects() {
        return this.effects;
    }

    public boolean isCurrentPlayer(class_1309 player) {
        return GameUtils.getPlayer().map(p -> p.method_5628() == player.method_5628()).orElse(false);
    }

    public boolean isRemoved() {
        class_1309 e = (class_1309)this.entity.get();
        return e == null || e.method_31481();
    }

    public boolean isAlive() {
        return !this.isRemoved();
    }

    public static EntityEffectInfo createDefault(int version) {
        return new EntityEffectInfo(version){

            @Override
            public boolean isDefault() {
                return true;
            }

            @Override
            @NotNull
            public class_1309 getEntity() {
                throw new RuntimeException("No entity associated with default entity effect info");
            }

            @Override
            public void activate() {
            }

            @Override
            public void deactivate() {
            }

            @Override
            public void tick() {
            }

            @Override
            public boolean isCurrentPlayer(class_1309 player) {
                return false;
            }

            @Override
            public boolean isRemoved() {
                return false;
            }

            @Override
            public boolean isAlive() {
                return true;
            }
        };
    }
}

